/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.entity;

import com.cicada.longwings.LongwingsSounds;
import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.block.JarPlaced;
import com.cicada.longwings.block.LongwingsBlocks;
import com.cicada.longwings.entity.ButterflyFlightNavigation;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.cicada.longwings.entity.LongwingsEntityTypes;
import com.cicada.longwings.entity.ai.ButterflyFeedGoal;
import com.cicada.longwings.entity.ai.ButterflyFlyToPOIGoal;
import com.cicada.longwings.entity.ai.ButterflyScareGoal;
import com.cicada.longwings.entity.ai.ButterflyTemptGoal;
import com.cicada.longwings.entity.ai.ButterflyWanderGoal;
import com.cicada.longwings.entity.ai.MothFlyToLightGoal;
import com.cicada.longwings.item.LongwingsItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6673;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.minecraft.class_7924;

public class ButterflyEntity
extends class_1429
implements class_1432 {
    public int floatCount;
    public float prevDeltaX;
    public float prevDeltaZ;
    public ButterflyVariant variant;
    private static final class_2940<String> DATA_VARIANT_ID = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> NOURISHED = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ONWALL = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> INPLANT = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SEED = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> SIZE = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_2338> HOME_POS = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13324);
    private final class_5819 randomSource = new class_5820(class_6673.method_39001());
    class_6862<class_2248> pollinationResistantCropsLevel1 = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("longwings", "pollination_resistant_crops_level_1"));
    class_6862<class_2248> pollinationResistantCropsLevel2 = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("longwings", "pollination_resistant_crops_level_2"));
    class_6862<class_2248> pollinationResistantCropsLevel3 = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("longwings", "pollination_resistant_crops_level_3"));
    class_6862<class_2248> pollinationBannedCrops = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("longwings", "pollination_banned_crops"));

    public ButterflyEntity(class_1299<? extends class_1429> p_27557_, class_1937 p_27558_) {
        super(p_27557_, p_27558_);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_22, 0.0f);
    }

    public static class_5132 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23720, 0.5).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 48.0).method_26866();
    }

    public void method_5674(class_2940<?> p_146754_) {
        super.method_5674(p_146754_);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)"monarch");
        this.field_6011.method_12784(NOURISHED, (Object)false);
        this.field_6011.method_12784(ONWALL, (Object)false);
        this.field_6011.method_12784(INPLANT, (Object)false);
        this.field_6011.method_12784(SEED, (Object)1);
        this.field_6011.method_12784(SIZE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(HOME_POS, (Object)new class_2338(0, 0, 0));
    }

    public void method_5652(class_2487 p_27587_) {
        super.method_5652(p_27587_);
        p_27587_.method_10582("Variant", this.getVariant());
        p_27587_.method_10556("Nourished", this.isNourished());
        p_27587_.method_10556("isOnWall", this.isOnWall());
        p_27587_.method_10556("isInPlant", this.isInPlant());
        p_27587_.method_10569("seed", this.getSeed().intValue());
        p_27587_.method_10548("size", this.getSize().floatValue());
        p_27587_.method_10569("HomePosX", this.getHomePos().method_10263());
        p_27587_.method_10569("HomePosY", this.getHomePos().method_10264());
        p_27587_.method_10569("HomePosZ", this.getHomePos().method_10260());
    }

    public void method_5749(class_2487 p_27576_) {
        super.method_5749(p_27576_);
        this.field_6011.method_12778(NOURISHED, (Object)p_27576_.method_10577("Nourished"));
        this.field_6011.method_12778(ONWALL, (Object)p_27576_.method_10577("isOnWall"));
        this.field_6011.method_12778(SIZE, (Object)Float.valueOf(p_27576_.method_10583("size")));
        int i = p_27576_.method_10550("HomePosX");
        int j = p_27576_.method_10550("HomePosY");
        int k = p_27576_.method_10550("HomePosZ");
        this.field_6011.method_12778(HOME_POS, (Object)new class_2338(i, j, k));
        if (p_27576_ != null && p_27576_.method_10558("variant") != null) {
            this.field_6011.method_12778(DATA_VARIANT_ID, (Object)p_27576_.method_10558("Variant"));
        }
    }

    public Float getSize() {
        return (Float)this.field_6011.method_12789(SIZE);
    }

    public void setSize(float seed) {
        this.field_6011.method_12778(SIZE, (Object)Float.valueOf(seed));
    }

    public Integer getSeed() {
        return (Integer)this.field_6011.method_12789(SEED);
    }

    public void setSeed(int seed) {
        this.field_6011.method_12778(SEED, (Object)seed);
    }

    public class_2338 getHomePos() {
        return (class_2338)this.field_6011.method_12789(HOME_POS);
    }

    public void setHomePos(class_2338 p_30220_) {
        this.field_6011.method_12778(HOME_POS, (Object)p_30220_);
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 p_146747_, class_3730 p_146748_, class_1315 groupData, class_2487 p_146750_) {
        return this.setButterflyVariantOnBiome(serverLevelAccessor, p_146747_, p_146748_, groupData, p_146750_);
    }

    public int randomHighBiasedCount(int groupMaxCount, float startProbability, float scale) {
        class_5819 randomsource = this.randomSource;
        int amount = 0;
        for (int a = 0; a < groupMaxCount && randomsource.method_43057() >= startProbability / (1.0f + (float)a * scale); ++a) {
            ++amount;
        }
        return amount;
    }

    public int randomLowBiasedCount(int groupMaxCount, float startProbability, float scale) {
        class_5819 randomsource = this.randomSource;
        int amount = 0;
        for (int a = 0; a < groupMaxCount && randomsource.method_43057() <= startProbability / (1.0f + (float)a * scale); ++a) {
            ++amount;
        }
        return amount;
    }

    public class_1315 setButterflyVariantOnBiome(class_5425 serverLevelAccessor, class_1266 p_146747_, class_3730 p_146748_, class_1315 groupData, class_2487 p_146750_) {
        boolean flag;
        ButterflyVariant[] variantPool = this instanceof MothEntity ? ButterflyVariant.getMothVariantPool() : ButterflyVariant.getButterflyVariantPool();
        class_1959 biome = (class_1959)this.method_37908().method_23753(this.method_24515()).comp_349();
        float biomeTemp = LongwingsHandler.getBiomeTemperature(biome);
        float biomeHumid = LongwingsHandler.getBiomeHumidity(biome);
        ButterflyVariant variant = ButterflyVariant.PAINTED_LADY;
        ArrayList<String> weightedListMaybe = new ArrayList<String>();
        class_5819 randomsource = this.randomSource;
        boolean cannotSpawnNaturally = false;
        ButterflyEntity entity = this;
        for (int a = 0; a < variantPool.length; ++a) {
            boolean hasValidHabitatConditions;
            ButterflyVariant selectedVariant = variantPool[a];
            boolean bl = hasValidHabitatConditions = biomeTemp >= selectedVariant.minTemp() && biomeTemp <= selectedVariant.maxTemp() && biomeHumid >= selectedVariant.minHumidity() && biomeHumid <= selectedVariant.maxHumidity();
            if (!hasValidHabitatConditions) continue;
            for (int b = 0; b < selectedVariant.getButterflySpawnRarity(); ++b) {
                weightedListMaybe.add(selectedVariant.getButterflyStringId());
            }
        }
        if (weightedListMaybe.isEmpty()) {
            weightedListMaybe.add(this instanceof MothEntity ? ButterflyVariant.SMALL_WHITE_WAVE.getButterflyStringId() : ButterflyVariant.PAINTED_LADY.getButterflyStringId());
            cannotSpawnNaturally = true;
        }
        String randomButterflyVariantString = (String)weightedListMaybe.get(randomsource.method_43048(weightedListMaybe.size()));
        for (int a = 0; a < variantPool.length; ++a) {
            if (!randomButterflyVariantString.matches(variantPool[a].getButterflyStringId())) continue;
            variant = variantPool[a];
        }
        this.applyLepidopteraTraits(variant, this);
        boolean bl = flag = p_146748_ == class_3730.field_16472 || p_146748_ == class_3730.field_16459;
        if (flag) {
            int extraButterflies = this.randomLowBiasedCount(6, 0.85f, 0.75f);
            if (biomeHumid <= 0.0f) {
                extraButterflies = this.randomLowBiasedCount(3, 0.25f, 0.9f);
            }
            boolean isMoth = this instanceof MothEntity;
            boolean canGenerateNewVariantsInGroup = false;
            if (cannotSpawnNaturally) {
                return null;
            }
            if (!isMoth && extraButterflies > 0) {
                for (int i = 0; i < extraButterflies; ++i) {
                    if (!this.method_37908().method_8477(entity.method_24515())) continue;
                    ButterflyEntity newEntity = (ButterflyEntity)LongwingsEntityTypes.BUTTERFLY.method_5883(this.method_37908());
                    if (randomsource.method_43057() <= (float)(i + 1) * 0.25f / (float)extraButterflies) {
                        canGenerateNewVariantsInGroup = true;
                    }
                    if (canGenerateNewVariantsInGroup) {
                        randomButterflyVariantString = (String)weightedListMaybe.get(randomsource.method_43048(weightedListMaybe.size()));
                        for (ButterflyVariant butterflyVariant : variantPool) {
                            if (!randomButterflyVariantString.matches(butterflyVariant.getButterflyStringId())) continue;
                            variant = butterflyVariant;
                        }
                    }
                    class_2338 scatterPos = new class_2338(this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260());
                    newEntity.method_5808(this.method_19538().method_10216(), this.method_19538().method_10214(), this.method_19538().method_10215(), entity.method_36454(), entity.method_36455());
                    this.applyLepidopteraTraits(variant, newEntity);
                    this.method_37908().method_8503().execute(() -> this.method_37908().method_8649((class_1297)newEntity));
                }
            }
        }
        return super.method_5943(serverLevelAccessor, p_146747_, p_146748_, groupData, p_146750_);
    }

    public void applyLepidopteraTraits(ButterflyVariant variant, ButterflyEntity target) {
        class_5819 randomsource = this.randomSource;
        float butterflySize = Math.min(1.0f, Math.max(0.7f, 0.7f + randomsource.method_43057() * 3.0f / 9.0f));
        if (variant.getButterflySize() == EnumButterflyTraits.ButterflySizes.NORMAL) {
            butterflySize = Math.min(1.15f, Math.max(0.85f, 0.85f + randomsource.method_43057() / 5.0f));
        }
        if (variant.getButterflySize() == EnumButterflyTraits.ButterflySizes.LARGER) {
            butterflySize = Math.min(1.15f, Math.max(0.85f, 0.85f + randomsource.method_43057() / 3.0f));
        }
        target.setVariant(variant.getButterflyStringId());
        target.setSize((float)((double)Math.round(butterflySize * 100.0f) / 100.0));
        target.setSeed((byte)randomsource.method_43048(100));
    }

    public boolean method_24828() {
        return super.method_24828();
    }

    public void method_24830(boolean p_21182_) {
        super.method_24830(p_21182_);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new ButterflyScareGoal(this));
        this.field_6201.method_6277(3, (class_1352)new ButterflyTemptGoal(this, class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("longwings:butterfly_tempt_items")))));
        this.field_6201.method_6277(4, (class_1352)new ButterflyFeedGoal(this, 7, LongwingsBlocks.SUGAR_WATER_BOWL));
        this.field_6201.method_6277(5, (class_1352)new ButterflyFlyToPOIGoal(this));
        this.field_6201.method_6277(6, (class_1352)new ButterflyWanderGoal(this));
    }

    protected class_1408 method_5965(class_1937 p_21480_) {
        ButterflyFlightNavigation flyingpathnavigation = new ButterflyFlightNavigation((class_1308)this, p_21480_);
        flyingpathnavigation.method_6354(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean method_5640(double p_19883_) {
        return super.method_5640(5.0);
    }

    public void method_5784(class_1313 type, class_243 pos) {
        if (this.isInsideJar()) {
            class_1937 level = this.method_37908();
            class_2680 state = level.method_8320(this.method_24515());
            boolean flag = (Boolean)state.method_11654((class_2769)JarPlaced.EmptyJarPlaced.OPEN);
            double clampedX = class_3532.method_15350((double)(this.method_23317() + pos.field_1352), (double)((double)this.method_24515().method_10263() + 0.35), (double)((double)(this.method_24515().method_10263() + 1) - 0.35));
            double clampedY = flag ? Math.max(this.method_23318() + pos.field_1351, (double)this.method_24515().method_10264() + 0.15) : class_3532.method_15350((double)(this.method_23318() + pos.field_1351), (double)((double)this.method_24515().method_10264() + 0.15), (double)((float)(this.method_24515().method_10264() + 1) - 0.5f));
            double clampedZ = class_3532.method_15350((double)(this.method_23321() + pos.field_1350), (double)((double)this.method_24515().method_10260() + 0.35), (double)((double)(this.method_24515().method_10260() + 1) - 0.35));
            this.method_5814(clampedX, clampedY, clampedZ);
        } else {
            super.method_5784(type, pos);
        }
    }

    public boolean isInsideJar() {
        class_1937 level = this.method_37908();
        class_2680 state = level.method_8320(this.method_24515());
        if (state.method_27852((class_2248)LongwingsBlocks.GLASS_JAR)) {
            class_265 collisionShape = this.method_37908().method_8320(this.method_24515()).method_26220((class_1922)this.method_37908(), this.method_24515());
            class_265 testShape = class_2248.method_9541((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
            if (!testShape.method_1110()) {
                return this.method_5829().method_989(0.0, 0.0, 0.0).method_994(testShape.method_1107().method_996(this.method_24515()));
            }
        } else {
            return false;
        }
        return false;
    }

    protected void method_6070() {
        if (!this.isInsideJar()) {
            super.method_6070();
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236) {
            if (!(this.method_24828() || this.isOnWall() || this.isInPlant())) {
                ++this.floatCount;
                if (this.floatCount % (5 + this.randomSource.method_43048(3)) == 0 && !this.isInsideJar()) {
                    this.method_37908().method_8486(this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, LongwingsSounds.BUTTERFLY_FLAP, class_3419.field_15254, 0.0075f - this.randomSource.method_43057() * 5.0E-4f, 0.75f + this.randomSource.method_43057(), false);
                }
            } else if (this.floatCount > 0) {
                this.floatCount = 0;
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.isInsideJar() && (double)this.method_37908().method_8409().method_43057() < 0.01) {
            this.method_5942().method_6337(this.method_23317() + (double)(-2 + this.method_37908().method_8409().method_43048(4)), this.method_23318() + (double)this.method_37908().method_8409().method_43048(3), this.method_23321() + (double)(-2 + this.method_37908().method_8409().method_43048(4)), 0.5);
        }
        class_265 translucentShape = this.method_37908().method_8320(this.method_24515()).method_26218((class_1922)this.method_37908(), this.method_24515());
        if (!this.method_37908().field_9236) {
            if (this.method_5942().method_6357() && !this.isOnWall() && !this.method_5799()) {
                this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 - (double)0.0045f, this.method_18798().field_1350);
            }
            if (this.method_5799()) {
                this.method_18800(this.method_18798().field_1352, 0.045, this.method_18798().field_1350);
                if (this.method_5942().method_6357() && this.method_37908().method_8320(this.method_24515().method_10084()).method_26215()) {
                    this.method_5942().method_6337((double)(-15 + this.method_24515().method_10263() + this.randomSource.method_43048(15) * 2), (double)(this.method_24515().method_10264() + this.randomSource.method_43048(5)), (double)(-15 + this.method_24515().method_10260() + this.randomSource.method_43048(15) * 2), (double)(0.35f + this.randomSource.method_43057()));
                }
            }
        }
        this.prevDeltaX = (float)this.method_18798().field_1352;
        this.prevDeltaZ = (float)this.method_18798().field_1350;
        boolean NS = this.method_5735() == class_2350.field_11043 || this.method_5735() == class_2350.field_11035;
        float facingModifier = this.method_5735() == class_2350.field_11035 || this.method_5735() == class_2350.field_11034 ? 0.105f : -0.105f;
        class_243 posFront = this.method_33571().method_1031(NS ? 0.0 : (double)facingModifier, (double)-0.105f, NS ? (double)facingModifier : 0.0);
        class_2338.class_2339 blockPosFront = new class_2338.class_2339(posFront.field_1352, posFront.field_1351, posFront.field_1350);
        class_265 forwardShape = this.method_37908().method_8320(class_2338.method_49638((class_2374)posFront)).method_26220((class_1922)this.method_37908(), class_2338.method_49638((class_2374)posFront));
        if (!this.method_37908().method_8608()) {
            if (this.isInPlant()) {
                if (!this.method_5942().method_6357() || translucentShape.method_1110()) {
                    this.setInPlant(false);
                }
                this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 * 0.0, this.method_18798().field_1350);
            }
            if (this.isOnWall() && (forwardShape.method_1110() || !forwardShape.method_1110() && !forwardShape.method_1107().method_996((class_2338)blockPosFront).method_994(new class_238(posFront.field_1352, posFront.field_1351, posFront.field_1350, posFront.field_1352, posFront.field_1351, posFront.field_1350)))) {
                this.setOnWall(false);
            }
            if (!this.isInsideJar()) {
                class_2680 state = this.method_37908().method_8320(this.method_24515());
                if (!state.method_27852(class_2246.field_37576) && !state.method_27852((class_2248)LongwingsBlocks.GLASS_JAR) && !this.isInPlant() && this.method_5942().method_6357() && !translucentShape.method_1110() && this.method_5829().method_989(0.0, 0.0, 0.0).method_994(translucentShape.method_1107().method_996(this.method_24515()))) {
                    this.setInPlant(true);
                    this.method_5942().method_6340();
                }
                float f = this.field_28627 = this.method_24828() || this.isOnWall() ? 0.0f : this.field_28627;
                if ((this.field_6012 < 10 || this.field_28627 > 1.0f && (double)this.randomSource.method_43057() < 0.025) && !this.isOnWall() && !forwardShape.method_1110() && forwardShape.method_1107().method_996((class_2338)blockPosFront).method_994(new class_238(posFront.field_1352, posFront.field_1351, posFront.field_1350, posFront.field_1352, posFront.field_1351, posFront.field_1350))) {
                    this.setOnWall(true);
                    this.method_5942().method_6340();
                }
            }
        }
        if (this.randomSource.method_43057() < 1.0E-5f && this.isNourished()) {
            this.setNourishment(false);
        }
        if (this.isOnWall() && !this.method_5942().method_23966()) {
            this.method_36456(this.method_5735().method_10144());
            this.method_5636(this.method_5735().method_10144());
            this.method_5847(this.method_5735().method_10144());
            this.field_5982 = this.method_36454();
            this.method_36457(-90.0f);
            this.field_6004 = this.method_36455();
            this.method_18800(0.0, 0.0, 0.0);
        }
        if (!this.method_24828() && this.randomSource.method_43048(150) == 0) {
            for (int cropNum = 0; cropNum < 8; ++cropNum) {
                class_2680 cropState = this.method_37908().method_8320(new class_2338(this.method_31477(), this.method_31478() - cropNum, this.method_31479()));
                if (!(cropState.method_26204() instanceof class_2302) || cropState.method_26164(this.pollinationBannedCrops)) continue;
                float pollinationChance = 1.0f;
                if (cropState.method_26164(this.pollinationResistantCropsLevel1)) {
                    pollinationChance = 0.25f;
                }
                if (cropState.method_26164(this.pollinationResistantCropsLevel2)) {
                    pollinationChance = 0.1f;
                }
                if (cropState.method_26164(this.pollinationResistantCropsLevel3)) {
                    pollinationChance = 0.01f;
                }
                if (!(this.randomSource.method_43057() <= pollinationChance)) continue;
                this.method_37908().method_8406((class_2394)class_2398.field_20537, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 0.0, 0.0, 0.0);
                if (((class_2302)cropState.method_26204()).method_9829(cropState) >= ((class_2302)cropState.method_26204()).method_9827()) continue;
                this.method_37908().method_43128((class_1657)null, this.method_19538().field_1352, this.method_19538().field_1351 - (double)cropNum, this.method_19538().field_1350, class_3417.field_17611, class_3419.field_15254, 0.15f, (float)Math.random() + 1.0f);
                if (!this.method_37908().method_8608()) {
                    this.method_37908().method_8501(new class_2338(this.method_31477(), this.method_31478() - cropNum, this.method_31479()), ((class_2302)cropState.method_26204()).method_9828(((class_2302)cropState.method_26204()).method_9829(cropState) + 1));
                }
                for (int a = 0; a < 5; ++a) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, (double)this.method_24515().method_10263() + Math.random(), (double)(this.method_24515().method_10264() - cropNum), (double)this.method_24515().method_10260() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void method_5623(double p_20990_, boolean p_20991_, class_2680 p_20992_, class_2338 p_20993_) {
    }

    public class_1269 method_5992(class_1657 p_27584_, class_1268 p_27585_) {
        class_1799 item = new class_1799((class_1935)(this instanceof MothEntity ? LongwingsItems.MOTH_ITEM : LongwingsItems.BUTTERFLY_ITEM));
        boolean moth = this instanceof MothEntity;
        String typeString = moth ? "moths" : "butterflies";
        boolean flag = false;
        for (int i = 0; i < p_27584_.method_31548().method_5439(); ++i) {
            class_1799 itemstack = p_27584_.method_31548().method_5438(i);
            if (!itemstack.method_31574((class_1792)LongwingsItems.LEPIDOPTERAPEDIA)) continue;
            if (itemstack.method_7948().method_10545(typeString)) {
                String lepidopteraTagListAsString = itemstack.method_7948().method_10580(typeString).method_10714();
                ArrayList<String> lepidopteriaList = new ArrayList<String>(Arrays.asList(lepidopteraTagListAsString.split(", ")));
                if (!lepidopteriaList.stream().noneMatch(s -> s.matches(this.getVariant()))) continue;
                flag = true;
                lepidopteriaList.add(this.getVariant());
                itemstack.method_7948().method_10582(typeString, String.join((CharSequence)", ", lepidopteriaList));
                continue;
            }
            flag = true;
            itemstack.method_7948().method_10582(typeString, this.getVariant());
        }
        if (this.method_37908().field_9236) {
            LongwingsHandler.getHandbookHandler().tryPlayToast(flag, this instanceof MothEntity, this.getVariant());
        }
        super.method_5992(p_27584_, p_27585_);
        if (p_27584_.method_5998(p_27585_).method_31573(class_3489.field_20344)) {
            double rand = Math.random() * 0.25 - Math.random() * 0.25;
            double randa = Math.random() * 0.25 - Math.random() * 0.25;
            double randb = Math.random() * 0.25 - Math.random() * 0.25;
            p_27584_.method_5998(p_27585_).method_7939(p_27584_.method_5998(p_27585_).method_7947() - 1);
            this.method_43077(class_3417.field_20615);
            for (int w = 0; w < 10; ++w) {
                this.method_37908().method_8406((class_2394)class_2398.field_29642, this.method_19538().field_1352 + rand, this.method_19538().field_1351 + randa, this.method_19538().field_1350 + randb, 0.25, 7.0, 0.25);
            }
            return class_1269.field_5812;
        }
        if (p_27584_.method_5998(p_27585_).method_31574((class_1792)LongwingsItems.CATCHING_NET_ITEM)) {
            if (this.method_5797() != null) {
                item.method_7948().method_10582("name", this.method_5797().getString());
            }
            item.method_7948().method_10582("variant", this.getVariant().toLowerCase(Locale.ROOT));
            item.method_7948().method_10548("size", this.getSize() != null ? this.getSize().floatValue() : 1.0f);
            if (p_27584_.method_7270(item)) {
                p_27584_.method_5998(p_27585_).method_7956(1, (class_1309)p_27584_, e -> e.method_20236(p_27585_));
                p_27584_.method_7270(item);
                p_27584_.method_5783(LongwingsSounds.CATCHING_NET_CATCH, 0.5f, 1.0f);
                this.method_31472();
            } else {
                p_27584_.method_5783(LongwingsSounds.CATCHING_NET_FULL, 0.5f, 2.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public boolean method_6150() {
        return this.method_6150();
    }

    public float method_5944(class_7 p_21440_) {
        return super.method_5944(p_21440_);
    }

    public boolean method_5747(float p_148702_, float p_148703_, class_1282 p_148704_) {
        return false;
    }

    protected void method_5712(class_2338 p_20135_, class_2680 p_20136_) {
    }

    protected void method_6013(class_1282 p_21493_) {
        super.method_6013(p_21493_);
    }

    public boolean method_30632(class_2338 p_20040_, class_2680 p_20041_) {
        return super.method_30632(p_20040_, p_20041_);
    }

    public void method_5941(class_7 p_21442_, float p_21443_) {
        super.method_5941(p_21442_, p_21443_);
    }

    public class_1296 method_5613(class_3218 p_146743_, class_1296 p_146744_) {
        return null;
    }

    public boolean method_6054() {
        return false;
    }

    public boolean method_6581() {
        return false;
    }

    public static boolean checkButterflySpawnRules(class_1299<ButterflyEntity> p_219113_, class_1936 p_219114_, class_3730 p_219115_, class_2338 p_219116_, class_5819 p_219117_) {
        boolean flag3;
        boolean flag = ((class_1959)p_219114_.method_23753(p_219116_).comp_349()).method_8712() <= 0.0f;
        boolean flag1 = p_219114_.method_8320(p_219116_.method_10074()).method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("longwings", "longwings_spawnable_on")));
        boolean flag2 = p_219114_.method_23753(p_219116_).method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("longwings", "longwings_biome_banlist")));
        class_1959 biome = (class_1959)p_219114_.method_23753(p_219116_).comp_349();
        float biomeHumid = LongwingsHandler.getBiomeHumidity(biome);
        boolean bl = flag3 = biomeHumid <= 0.0f;
        if (flag3 && Math.random() >= 0.1) {
            return false;
        }
        return !flag && flag1 && !flag2;
    }

    public boolean method_5979(class_1936 level, class_3730 spawnReason) {
        return super.method_5979(level, spawnReason);
    }

    public boolean method_31746() {
        return super.method_31746();
    }

    public String getVariant() {
        return (String)this.field_6011.method_12789(DATA_VARIANT_ID);
    }

    public void setVariant(String string) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)string);
    }

    public boolean isNourished() {
        return (Boolean)this.field_6011.method_12789(NOURISHED);
    }

    public void setNourishment(boolean nourished) {
        this.field_6011.method_12778(NOURISHED, (Object)nourished);
    }

    public boolean isOnWall() {
        return (Boolean)this.field_6011.method_12789(ONWALL);
    }

    public void setOnWall(boolean onWall) {
        this.field_6011.method_12778(ONWALL, (Object)onWall);
    }

    public boolean isInPlant() {
        return (Boolean)this.field_6011.method_12789(INPLANT);
    }

    public void setInPlant(boolean inPlant) {
        this.field_6011.method_12778(INPLANT, (Object)inPlant);
    }

    public static class MothEntity
    extends ButterflyEntity {
        public MothEntity(class_1299<? extends class_1429> p_27557_, class_1937 p_27558_) {
            super(p_27557_, p_27558_);
            this.field_6207 = new class_1331((class_1308)this, 20, true);
            this.method_5941(class_7.field_22, 0.0f);
        }

        public static boolean checkMothSpawnRules(class_1299<MothEntity> p_219113_, class_1936 p_219114_, class_3730 p_219115_, class_2338 p_219116_, class_5819 p_219117_) {
            boolean flag3;
            boolean flag = ((class_1959)p_219114_.method_23753(p_219116_).comp_349()).method_8712() <= 0.0f;
            boolean flag1 = p_219114_.method_8320(p_219116_.method_10074()).method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("longwings", "longwings_spawnable_on")));
            boolean flag2 = p_219114_.method_23753(p_219116_).method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("longwings", "longwings_biome_banlist")));
            class_1959 biome = (class_1959)p_219114_.method_23753(p_219116_).comp_349();
            float biomeHumid = LongwingsHandler.getBiomeHumidity(biome);
            boolean bl = flag3 = biomeHumid <= 0.0f;
            if (flag3 && Math.random() >= 0.5) {
                return false;
            }
            return !flag && flag1 && !flag2;
        }

        @Override
        public boolean method_5979(class_1936 p_21686_, class_3730 p_21687_) {
            return super.method_5979(p_21686_, p_21687_);
        }

        @Override
        protected void method_5959() {
            super.method_5959();
            this.field_6201.method_6277(1, (class_1352)new MothFlyToLightGoal(this));
            this.field_6201.method_6277(2, (class_1352)new ButterflyScareGoal(this));
            this.field_6201.method_6277(3, (class_1352)new ButterflyTemptGoal(this, class_1856.method_8106((class_6862)class_3489.field_20344)));
            this.field_6201.method_6277(4, (class_1352)new ButterflyFeedGoal(this, 7, LongwingsBlocks.SUGAR_WATER_BOWL));
            this.field_6201.method_6277(5, (class_1352)new ButterflyWanderGoal(this));
        }
    }
}

