/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.GlassTableBlockEntity;
import com.skniro.skniro_furniture.block.init.GlassTableBlock;
import com.skniro.skniro_furniture.block.renderer.state.GlassTableBlockEntityRendererState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class GlassTableBlockEntityRenderer
implements BlockEntityRenderer<GlassTableBlockEntity, GlassTableBlockEntityRendererState> {
    private final ItemModelResolver itemModelManager;

    public GlassTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public void extractRenderState(GlassTableBlockEntity entity, GlassTableBlockEntityRendererState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)state, tickProgress, cameraPos, crumblingOverlay);
        state.stack = entity.inventory;
        state.world = entity.getLevel();
        state.blockPos = entity.getBlockPos();
        state.blockState = entity.getBlockState();
        if (state.blockState.getBlock() instanceof GlassTableBlock) {
            int j = (int)entity.getBlockPos().asLong();
            state.triplecabinetItemStates = new ArrayList<ItemStackRenderState>();
            for (int i = 0; i < 9; ++i) {
                ItemStackRenderState itemRenderState = new ItemStackRenderState();
                this.itemModelManager.updateForTopItem(itemRenderState, entity.getItem(i), ItemDisplayContext.FIXED, entity.getLevel(), (ItemOwner)null, i + j);
                state.triplecabinetItemStates.add(itemRenderState);
            }
        }
    }

    public void submit(GlassTableBlockEntityRendererState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Direction direction = (Direction)state.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrices.pushPose();
        if (state.blockState.getBlock() instanceof GlassTableBlock) {
            switch (direction) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    matrices.translate(1.0f, 0.0f, 1.0f);
                    matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case WEST: {
                    matrices.translate(0.0f, 0.0f, 1.0f);
                    matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case EAST: {
                    matrices.translate(1.0f, 0.0f, 0.0f);
                    matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                }
            }
            matrices.translate(0.25f, 0.93f, 0.25f);
            matrices.scale(0.23f, 0.23f, 0.23f);
            List<ItemStackRenderState> list = state.triplecabinetItemStates;
            for (int i = 0; i < 9; ++i) {
                ItemStackRenderState itemRenderState = list.get(i);
                ItemStack stack = (ItemStack)state.stack.get(i);
                if (stack.isEmpty()) continue;
                matrices.pushPose();
                float x = (float)(i % 3) * 1.1f;
                float z = (float)(i / 3) * 1.1f;
                matrices.translate(x, 0.0f, z);
                itemRenderState.submit(matrices, queue, this.getLightLevel(state.world, state.blockPos), OverlayTexture.NO_OVERLAY, 0);
                matrices.popPose();
            }
            matrices.popPose();
        }
    }

    private int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.getBrightness(LightLayer.BLOCK, pos);
        int sLight = world.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)Math.max(sLight, 15));
    }

    public GlassTableBlockEntityRendererState createRenderState() {
        return new GlassTableBlockEntityRendererState();
    }
}

