/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.skniro_furniture.recipe.FurnitureRecipeType;
import com.skniro.skniro_furniture.recipe.KitchenSinkRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KitchenSinkRecipe
implements Recipe<KitchenSinkRecipeInput> {
    final ItemStack output;
    final Ingredient ingredient;
    @Nullable
    private PlacementInfo ingredientPlacement;

    public KitchenSinkRecipe(Ingredient ingredients, ItemStack output) {
        this.output = output;
        this.ingredient = ingredients;
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public ItemStack output() {
        return this.output;
    }

    public boolean matches(KitchenSinkRecipeInput input, Level world) {
        if (world.isClientSide()) {
            return false;
        }
        return this.ingredient.test(input.getItem(1));
    }

    public ItemStack assemble(KitchenSinkRecipeInput input, HolderLookup.Provider lookup) {
        return this.output.copy();
    }

    public RecipeSerializer<? extends Recipe<KitchenSinkRecipeInput>> getSerializer() {
        return FurnitureRecipeType.Kitchen_Sink_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<KitchenSinkRecipeInput>> getType() {
        return FurnitureRecipeType.Kitchen_Sink_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = PlacementInfo.create((Ingredient)this.ingredient);
        }
        return this.ingredientPlacement;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<KitchenSinkRecipe> {
        public static final MapCodec<KitchenSinkRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)inst, KitchenSinkRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, KitchenSinkRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, KitchenSinkRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, KitchenSinkRecipe::output, KitchenSinkRecipe::new);

        public MapCodec<KitchenSinkRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, KitchenSinkRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

