/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.PlateBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class PlateBlockEntityRenderer
implements BlockEntityRenderer<PlateBlockEntity> {
    public PlateBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PlateBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, Vec3 cameraPos) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = entity.getItem(0);
        Direction direction = (Direction)entity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrices.pushPose();
        matrices.translate(0.5f, 0.01f, 0.5f);
        matrices.scale(0.35f, 0.35f, 0.35f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        switch (direction) {
            case NORTH: {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case SOUTH: {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            }
        }
        itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, this.getLightLevel(entity.getLevel(), entity.getBlockPos()), OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 1);
        matrices.popPose();
    }

    private int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.getBrightness(LightLayer.BLOCK, pos);
        int sLight = world.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

