/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.skniro.skniro_furniture.block.entity.FurnitureBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FurnitureBedBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BannerPatternLayers patterns = BannerPatternLayers.EMPTY;
    @Nullable
    private Component customName;
    private final DyeColor baseColor;

    public FurnitureBedBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, DyeColor.WHITE);
    }

    public FurnitureBedBlockEntity(BlockPos pos, BlockState state, DyeColor baseColor) {
        super(FurnitureBlockEntityType.Bed_BLOCK_ENTITY.get(), pos, state);
        this.baseColor = baseColor;
    }

    public BannerPatternLayers getPatterns() {
        return this.patterns;
    }

    public void setPatterns(BannerPatternLayers patterns) {
        this.patterns = patterns;
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (!this.patterns.equals((Object)BannerPatternLayers.EMPTY)) {
            nbt.put("patterns", (Tag)BannerPatternLayers.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.patterns).getOrThrow());
        }
        if (this.customName != null) {
            nbt.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (nbt.contains("CustomName", 8)) {
            this.customName = FurnitureBedBlockEntity.parseCustomNameSafe((String)nbt.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        if (nbt.contains("patterns")) {
            BannerPatternLayers.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("patterns")).resultOrPartial(patterns -> LOGGER.error("Failed to parse banner patterns: '{}'", patterns)).ifPresent(patterns -> {
                this.patterns = patterns;
            });
        }
    }
}

