/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.entity;

import com.skniro.skniro_furniture.block.entity.FurnitureBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends AbstractFurnaceBlockEntity {
    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super(FurnitureBlockEntityType.OVEN_BLOCK_ENTITY.get(), pos, state, RecipeType.SMOKING);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"gui.skniro_furniture.oven");
    }

    protected int getBurnDuration(FuelValues fuelRegistry, ItemStack stack) {
        return super.getBurnDuration(fuelRegistry, stack) / 2;
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new SmokerMenu(syncId, playerInventory, (Container)this, this.dataAccess);
    }

    public void setChanged() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    public ItemStack getRenderStack() {
        if (this.getItem(0).isEmpty()) {
            return this.getItem(2);
        }
        return this.getItem(0);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }
}

