/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WindowBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<WindowBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WindowBlock.propertiesCodec(), (App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(block -> block.blockSetType)).apply((Applicative)instance, WindowBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<DoorHingeSide> HINGE;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty POWERED;
    public static final VoxelShape WEST_OPEN_SHAPE;
    public static final VoxelShape EAST_OPEN_SHAPE;
    public static final VoxelShape NORTH_OPEN_SHAPE;
    public static final VoxelShape SOUTH_OPEN_SHAPE;
    public static final VoxelShape WEST_CLOSED_SHAPE;
    public static final VoxelShape EAST_CLOSED_SHAPE;
    public static final VoxelShape NORTH_CLOSED_SHAPE;
    public static final VoxelShape SOUTH_CLOSED_SHAPE;
    private final BlockSetType blockSetType;

    public WindowBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings.sound(blockSetType.soundType()));
        this.blockSetType = blockSetType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockSetType getBlockSetType() {
        return this.blockSetType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        boolean closed = (Boolean)state.getValue((Property)OPEN) == false;
        boolean bl2 = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            case EAST: {
                return closed ? EAST_CLOSED_SHAPE : (bl2 ? WEST_OPEN_SHAPE : EAST_OPEN_SHAPE);
            }
            case SOUTH: {
                return closed ? SOUTH_CLOSED_SHAPE : (bl2 ? NORTH_OPEN_SHAPE : SOUTH_OPEN_SHAPE);
            }
            case WEST: {
                return closed ? WEST_CLOSED_SHAPE : (bl2 ? EAST_OPEN_SHAPE : WEST_OPEN_SHAPE);
            }
        }
        return closed ? NORTH_CLOSED_SHAPE : (bl2 ? SOUTH_OPEN_SHAPE : NORTH_OPEN_SHAPE);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        boolean powered = world.hasNeighborSignal(blockPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue(HINGE, (Comparable)this.getHinge(ctx))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!this.blockSetType.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.cycle((Property)OPEN);
        world.setBlock(pos, state, 10);
        this.playOpenCloseSound((Entity)player, world, pos, (Boolean)state.getValue((Property)OPEN));
        world.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        return InteractionResult.SUCCESS;
    }

    private DoorHingeSide getHinge(BlockPlaceContext ctx) {
        Level blockView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction direction = ctx.getHorizontalDirection();
        BlockPos blockPos2 = blockPos.above();
        Direction direction2 = direction.getCounterClockWise();
        BlockPos blockPos3 = blockPos.relative(direction2);
        BlockState blockState = blockView.getBlockState(blockPos3);
        BlockPos blockPos4 = blockPos2.relative(direction2);
        BlockState blockState2 = blockView.getBlockState(blockPos4);
        Direction direction3 = direction.getClockWise();
        BlockPos blockPos5 = blockPos.relative(direction3);
        BlockState blockState3 = blockView.getBlockState(blockPos5);
        BlockPos blockPos6 = blockPos2.relative(direction3);
        BlockState blockState4 = blockView.getBlockState(blockPos6);
        int i = (blockState.isCollisionShapeFullBlock((BlockGetter)blockView, blockPos3) ? -1 : 0) + (blockState2.isCollisionShapeFullBlock((BlockGetter)blockView, blockPos4) ? -1 : 0) + (blockState3.isCollisionShapeFullBlock((BlockGetter)blockView, blockPos5) ? 1 : 0) + (blockState4.isCollisionShapeFullBlock((BlockGetter)blockView, blockPos6) ? 1 : 0);
        if (i <= 0) {
            if (i >= 0) {
                int j = direction.getStepX();
                int k = direction.getStepZ();
                Vec3 vec3d = ctx.getClickLocation();
                double d = vec3d.x - (double)blockPos.getX();
                double e = vec3d.z - (double)blockPos.getZ();
                return !(j < 0 && e < 0.5 || j > 0 && e > 0.5 || k < 0 && d > 0.5 || k > 0 && d < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    private void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.playSound(entity, pos, open ? this.blockSetType.doorOpen() : this.blockSetType.doorClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HINGE, POWERED});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    static {
        OPEN = BlockStateProperties.OPEN;
        HINGE = BlockStateProperties.DOOR_HINGE;
        POWERED = BlockStateProperties.POWERED;
        WEST_CLOSED_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0);
        EAST_CLOSED_SHAPE = Block.box((double)14.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_CLOSED_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5);
        SOUTH_CLOSED_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)16.0);
        WEST_OPEN_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)16.0);
        EAST_OPEN_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5);
        NORTH_OPEN_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0);
        SOUTH_OPEN_SHAPE = Block.box((double)14.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

