/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.skniro_furniture.recipe.FurnitureRecipeType;
import com.skniro.skniro_furniture.recipe.KitchenSinkRecipeInput;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class KitchenSinkRecipe
implements Recipe<KitchenSinkRecipeInput> {
    final ItemStack output;
    final List<Ingredient> recipeItems;

    public KitchenSinkRecipe(List<Ingredient> recipeItems, ItemStack output) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(KitchenSinkRecipeInput inventory, Level world) {
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            if (this.recipeItems.get(i).test(inventory.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(KitchenSinkRecipeInput inventory, HolderLookup.Provider lookup) {
        return this.output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.createWithCapacity((int)1);
        list.addAll(this.recipeItems);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return FurnitureRecipeType.Kitchen_Sink_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return FurnitureRecipeType.Kitchen_Sink_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<KitchenSinkRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<KitchenSinkRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredient").forGetter(recipe -> recipe.recipeItems), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)inst, KitchenSinkRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, KitchenSinkRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<KitchenSinkRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, KitchenSinkRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        private static KitchenSinkRecipe read(RegistryFriendlyByteBuf buf) {
            int i = buf.readVarInt();
            NonNullList defaultedList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            defaultedList.replaceAll(empty -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new KitchenSinkRecipe((List<Ingredient>)defaultedList, itemStack);
        }

        private static void write(RegistryFriendlyByteBuf buf, KitchenSinkRecipe recipe) {
            buf.writeVarInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.output);
        }
    }
}

