/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.skniro_furniture.recipe.FurnitureRecipeType;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class KitchenSinkRecipe
implements Recipe<SimpleContainer> {
    private final ItemStack output;
    private final List<Ingredient> recipeItems;

    public KitchenSinkRecipe(List<Ingredient> recipeItems, ItemStack output) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer inventory, Level world) {
        if (world.m_5776_()) {
            return false;
        }
        return this.recipeItems.get(0).test(inventory.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_182647_((int)this.recipeItems.size());
        list.addAll(this.recipeItems);
        return list;
    }

    public RecipeSerializer<?> m_7707_() {
        return FurnitureRecipeType.Kitchen_Sink_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return FurnitureRecipeType.Kitchen_Sink_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<KitchenSinkRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final Codec<KitchenSinkRecipe> CODEC = RecordCodecBuilder.create(in -> in.group((App)Serializer.validateAmount((Codec<Ingredient>)Ingredient.f_290991_, 9).fieldOf("ingredient").forGetter(KitchenSinkRecipe::m_7527_), (App)ItemStack.f_302323_.fieldOf("result").forGetter(r -> r.output)).apply((Applicative)in, KitchenSinkRecipe::new));

        private static Codec<List<Ingredient>> validateAmount(Codec<Ingredient> delegate, int max) {
            return ExtraCodecs.m_264370_((Codec)ExtraCodecs.m_264370_((Codec)delegate.listOf(), list -> list.size() > max ? DataResult.error(() -> "Recipe has too many ingredients!") : DataResult.success((Object)list)), list -> list.isEmpty() ? DataResult.error(() -> "Recipe has no ingredients!") : DataResult.success((Object)list));
        }

        public Codec<KitchenSinkRecipe> m_292673_() {
            return CODEC;
        }

        public KitchenSinkRecipe fromNetwork(FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new KitchenSinkRecipe((List<Ingredient>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buf, KitchenSinkRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_(null));
        }
    }
}

