/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skniro.skniro_furniture.recipe.FurnitureRecipeType;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KitchenSinkRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<Ingredient> recipeItems;

    public KitchenSinkRecipe(List<Ingredient> recipeItems, ItemStack output, ResourceLocation id) {
        this.output = output;
        this.recipeItems = recipeItems;
        this.id = id;
    }

    public boolean matches(SimpleContainer inventory, Level world) {
        if (world.m_5776_()) {
            return false;
        }
        return this.recipeItems.get(0).test(inventory.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_182647_((int)this.recipeItems.size());
        list.addAll(this.recipeItems);
        return list;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return FurnitureRecipeType.Kitchen_Sink_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return FurnitureRecipeType.Kitchen_Sink_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<KitchenSinkRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public KitchenSinkRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new KitchenSinkRecipe((List<Ingredient>)inputs, output, resourceLocation);
        }

        @Nullable
        public KitchenSinkRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            NonNullList inputs = NonNullList.m_122780_((int)friendlyByteBuf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            ItemStack output = friendlyByteBuf.m_130267_();
            return new KitchenSinkRecipe((List<Ingredient>)inputs, output, resourceLocation);
        }

        public void toNetwork(FriendlyByteBuf buf, KitchenSinkRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_(null));
        }
    }
}

