/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;

public class StuckArrowsFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;

    public StuckArrowsFeatureRenderer(EntityRendererProvider.Context context, LivingEntityRenderer<T, M> entityRenderer) {
        super(entityRenderer);
        this.dispatcher = context.getEntityRenderDispatcher();
    }

    protected int getObjectCount(T entity) {
        return entity.getArrowCount();
    }

    protected void renderObject(PoseStack matrices, MultiBufferSource vertexConsumers, int light, Entity entity, float directionX, float directionY, float directionZ, float tickDelta) {
        float f = Mth.sqrt((float)(directionX * directionX + directionZ * directionZ));
        Arrow arrowEntity = new Arrow(entity.level(), entity.getX(), entity.getY(), entity.getZ(), ItemStack.EMPTY, null);
        arrowEntity.setYRot((float)(Math.atan2(directionX, directionZ) * 180.0 / 3.1415927410125732));
        arrowEntity.setXRot((float)(Math.atan2(directionY, f) * 180.0 / 3.1415927410125732));
        arrowEntity.yRotO = arrowEntity.getYRot();
        arrowEntity.xRotO = arrowEntity.getXRot();
        this.dispatcher.render((Entity)arrowEntity, 0.0, 0.0, 0.0, 0.0f, tickDelta, matrices, vertexConsumers, light);
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T entity, float f, float g, float h, float j, float k, float l) {
        int m = this.getObjectCount(entity);
        RandomSource random = RandomSource.create((long)entity.getId());
        if (m > 0) {
            for (int n = 0; n < m; ++n) {
                matrixStack.pushPose();
                ModelPart modelPart = ((HumanoidModel)this.getParentModel()).body;
                ModelPart.Cube cuboid = modelPart.getRandomCube(random);
                modelPart.translateAndRotate(matrixStack);
                float o = random.nextFloat();
                float p = random.nextFloat();
                float q = random.nextFloat();
                float r = Mth.lerp((float)o, (float)cuboid.minX, (float)cuboid.maxX) / 16.0f;
                float s = Mth.lerp((float)p, (float)cuboid.minY, (float)cuboid.maxY) / 16.0f;
                float t = Mth.lerp((float)q, (float)cuboid.minZ, (float)cuboid.maxZ) / 16.0f;
                matrixStack.translate(r, s, t);
                o = -1.0f * (o * 2.0f - 1.0f);
                p = -1.0f * (p * 2.0f - 1.0f);
                q = -1.0f * (q * 2.0f - 1.0f);
                this.renderObject(matrixStack, vertexConsumerProvider, i, (Entity)entity, o, p, q, h);
                matrixStack.popPose();
            }
        }
    }
}

