/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class AnonymousBehaviour<E extends BirdEntity>
extends ExtendedBehaviour<E> {
    private final List<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories;
    private final BiPredicate<E, Brain<?>> callback;

    public AnonymousBehaviour(List<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories, BiPredicate<E, Brain<?>> callback) {
        this.requiredMemories = requiredMemories;
        this.callback = callback;
        for (Pair<MemoryModuleType<?>, MemoryStatus> memory : requiredMemories) {
            this.entryCondition.put((MemoryModuleType)memory.getFirst(), (MemoryStatus)memory.getSecond());
        }
    }

    public AnonymousBehaviour(BiPredicate<E, Brain<?>> callback) {
        this.requiredMemories = List.of();
        this.callback = callback;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of();
    }

    protected boolean shouldRun(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        for (Pair<MemoryModuleType<?>, MemoryStatus> memoryPair : this.requiredMemories) {
            if (brain.checkMemory((MemoryModuleType)memoryPair.getFirst(), (MemoryStatus)memoryPair.getSecond())) continue;
            return false;
        }
        return this.callback.test(entity, entity.getBrain());
    }
}

