/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SpeedModifiableBehaviour;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.item.ItemEntity;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetItemWalkTarget<E extends BirdEntity>
extends SpeedModifiableBehaviour<E> {
    private static final MemoryList MEMORY_REQUIREMENTS = MemoryList.create(4).registered(MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS).present((MemoryModuleType<?>)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()));
    protected Function<E, Integer> radius = entity -> 32;

    public SetItemWalkTarget<E> radius(int radius) {
        return this.radius(entity -> radius);
    }

    public SetItemWalkTarget<E> radius(Function<E, Integer> function) {
        this.radius = function;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected void start(E entity) {
        Brain brain = entity.getBrain();
        List wantedItems = (List)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()));
        ItemEntity targetItem = (ItemEntity)wantedItems.getFirst();
        if (targetItem.closerThan(entity, (double)this.radius.apply(entity).intValue()) && entity.level().getWorldBorder().isWithinBounds(targetItem.blockPosition())) {
            WalkTarget newWalkTarget = new WalkTarget((PositionTracker)new EntityTracker((Entity)targetItem, false), ((Float)this.speedModifier.apply(entity, targetItem.position())).floatValue(), 0);
            if (!BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)) {
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)targetItem, true));
            }
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)newWalkTarget);
        }
    }
}

