/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.ai.brain.TeleportTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SpeedModifiableBehaviour;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetOwnerTarget
extends SpeedModifiableBehaviour<PigeonEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(3).registered(FowlPlayMemoryModuleType.TELEPORT_TARGET.get(), MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET);
    private LivingEntity owner;
    private int updateCountdownTicks;
    protected UniformInt range = UniformInt.of((int)5, (int)10);

    public SetOwnerTarget setRange(int min, int max) {
        this.range = UniformInt.of((int)min, (int)max);
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean shouldRun(ServerLevel world, PigeonEntity pigeon) {
        LivingEntity owner = pigeon.getOwner();
        if (owner == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (pigeon.isSitting()) {
            return false;
        }
        if (pigeon.distanceToSqr((Entity)owner) < (double)(this.range.getMinValue() * this.range.getMinValue())) {
            return false;
        }
        if (pigeon.getRecipientUuid() != null) {
            return false;
        }
        this.owner = owner;
        return super.checkExtraStartConditions(world, (LivingEntity)pigeon);
    }

    protected boolean shouldKeepRunning(PigeonEntity pigeon) {
        if (pigeon.getRecipientUuid() != null) {
            return false;
        }
        if (pigeon.getNavigation().isDone()) {
            return false;
        }
        if (pigeon.isSitting()) {
            return false;
        }
        return pigeon.distanceToSqr((Entity)this.owner) > (double)(this.range.getMaxValue() * this.range.getMaxValue());
    }

    protected void tick(PigeonEntity pigeon) {
        Brain brain = pigeon.getBrain();
        BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.owner, true));
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 20;
            if (!pigeon.isLeashed() && !pigeon.isPassenger()) {
                if (pigeon.distanceToSqr((Entity)this.owner) >= 144.0) {
                    BrainUtils.setMemory((Brain)brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get(), (Object)new TeleportTarget((Entity)this.owner));
                } else {
                    BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)this.owner, ((Float)this.speedModifier.apply(pigeon, this.owner.position())).floatValue(), 0));
                }
            }
        }
    }
}

