/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.pathing.BirdTargeting;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetPerchWalkTarget<E extends FlyingBirdEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryList MEMORIES = MemoryList.create(1).absent((MemoryModuleType<?>)MemoryModuleType.WALK_TARGET);
    public static final CylindricalRadius PERCH_RANGE = new CylindricalRadius(32, 32);
    public static final CylindricalRadius GROUND_RANGE = new CylindricalRadius(8, 64);

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        Brain brain = entity.getBrain();
        Vec3 target = BirdTargeting.findPerchOrGround(entity, PERCH_RANGE, GROUND_RANGE);
        if (target != null) {
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target, 1.0f, 0));
        } else {
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
        }
    }
}

