/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.TeleportTarget;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class TeleportToTarget
extends ExtendedBehaviour<BirdEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(1).present((MemoryModuleType<?>)FowlPlayMemoryModuleType.TELEPORT_TARGET.get());

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean shouldKeepRunning(BirdEntity entity) {
        return BrainUtils.hasMemory((LivingEntity)entity, FowlPlayMemoryModuleType.TELEPORT_TARGET.get());
    }

    protected void tick(BirdEntity entity) {
        Brain brain = entity.getBrain();
        if (this.tryTeleport(entity, brain)) {
            BrainUtils.clearMemory((Brain)brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get());
        }
    }

    private boolean tryTeleport(BirdEntity entity, Brain<?> brain) {
        if (!BrainUtils.hasMemory(brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get())) {
            return false;
        }
        Entity target = ((TeleportTarget)BrainUtils.getMemory(brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get())).entity();
        BlockPos pos = target.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int j = entity.getRandom().nextIntBetweenInclusive(-3, 3);
            int k = entity.getRandom().nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = entity.getRandom().nextIntBetweenInclusive(-1, 1);
            if (!this.tryTeleportTo(entity, pos.getX() + j, pos.getY() + l, pos.getZ() + k)) continue;
            return true;
        }
        return false;
    }

    private boolean tryTeleportTo(BirdEntity entity, int x, int y, int z) {
        if (!this.canTeleportTo(entity, new BlockPos(x, y, z))) {
            return false;
        }
        entity.moveTo((double)x + 0.5, y, (double)z + 0.5, entity.getYRot(), entity.getXRot());
        entity.getNavigation().stop();
        return true;
    }

    private boolean canTeleportTo(BirdEntity entity, BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)entity, (BlockPos)pos.mutable());
        if (pathNodeType != PathType.WALKABLE) {
            return false;
        }
        BlockPos distance = pos.subtract((Vec3i)entity.blockPosition());
        return entity.level().noCollision((Entity)entity, entity.getBoundingBox().move(distance));
    }
}

