/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.control;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.control.BirdMoveControl;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class BirdAquaticMoveControl
extends BirdMoveControl {
    private static final float field_40123 = 10.0f;
    private final int pitchChange;
    private final int yawChange;
    private final float speedInWater;
    private final float speedInAir;
    private final boolean buoyant;

    public BirdAquaticMoveControl(BirdEntity bird, int pitchChange, int yawChange, float speedInWater, float speedInAir, boolean buoyant) {
        super(bird);
        this.pitchChange = pitchChange;
        this.yawChange = yawChange;
        this.speedInWater = speedInWater;
        this.speedInAir = speedInAir;
        this.buoyant = buoyant;
    }

    @Override
    public void tick() {
        if (this.bird.isInWaterOrBubble() && !this.bird.isBaby()) {
            this.tickSwimming();
        } else {
            super.tick();
        }
    }

    private void tickSwimming() {
        if (this.buoyant && this.mob.isInWater()) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
            double f;
            double e;
            double d = this.wantedX - this.mob.getX();
            double g = d * d + (e = this.wantedY - this.mob.getY()) * e + (f = this.wantedZ - this.mob.getZ()) * f;
            if (g < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
            } else {
                float h = (float)(Mth.atan2((double)f, (double)d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), h, this.yawChange));
                this.mob.yBodyRot = this.mob.getYRot();
                this.mob.yHeadRot = this.mob.getYRot();
                float speed = (float)(this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * 4.0);
                if (this.mob.isInWater()) {
                    float k;
                    this.mob.setSpeed(speed * this.speedInWater);
                    double j = Math.sqrt(d * d + f * f);
                    if (Math.abs(e) > (double)1.0E-5f || Math.abs(j) > (double)1.0E-5f) {
                        k = -((float)(Mth.atan2((double)e, (double)j) * 180.0 / 3.1415927410125732));
                        k = Mth.clamp((float)Mth.wrapDegrees((float)k), (float)(-this.pitchChange), (float)this.pitchChange);
                        this.mob.setXRot(this.rotlerp(this.mob.getXRot(), k, 5.0f));
                    }
                    k = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    float l = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    this.mob.zza = k * speed;
                    this.mob.yya = -l * speed;
                } else {
                    float m = Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - h)));
                    float n = BirdAquaticMoveControl.method_45335(m);
                    this.mob.setSpeed(speed * this.speedInAir * n);
                }
            }
        } else {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }

    private static float method_45335(float f) {
        return 1.0f - Mth.clamp((float)((f - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }
}

