/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TargetingUtil {
    @Nullable
    public static BlockPos validateAny(PathfinderMob entity, BlockPos pos) {
        BlockPos adjustedPos = RandomPos.moveUpOutOfSolid((BlockPos)pos, (int)entity.level().getMaxBuildHeight(), currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.isNotStable((PathNavigation)entity.getNavigation(), (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos validateWater(PathfinderMob entity, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 0, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        if (!GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos validateNonAir(PathfinderMob entity, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionNonAir(entity, adjustedPos)) {
            return null;
        }
        return entity.level().isWaterAt(adjustedPos.below()) ? adjustedPos.below() : adjustedPos;
    }

    @Nullable
    public static BlockPos validateGround(PathfinderMob entity, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionGrounded(entity, adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos validatePerch(PathfinderMob entity, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, Heightmap.Types.MOTION_BLOCKING, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) && !TargetingUtil.isPerch(entity, currentPos));
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos.below()) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPerch(entity, adjustedPos)) {
            return null;
        }
        return entity.level().getBlockState(adjustedPos).getBlock() instanceof LeavesBlock ? adjustedPos.below() : adjustedPos;
    }

    @Nullable
    public static BlockPos towardTarget(PathfinderMob entity, int horizontalRange, boolean posTargetInRange, BlockPos relativeInRangePos) {
        BlockPos adjustedPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)entity, (int)horizontalRange, (RandomSource)entity.getRandom(), (BlockPos)relativeInRangePos);
        if (GoalUtils.isOutsideLimits((BlockPos)adjustedPos, (PathfinderMob)entity) || GoalUtils.isRestricted((boolean)posTargetInRange, (PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    public static BlockPos findSurfacePosition(PathfinderMob entity, BlockPos initialPos, Heightmap.Types heightmap, int blocksAbove, Predicate<BlockPos> predicate) {
        BlockPos adjustedPos = initialPos.getY() > entity.level().getHeight(heightmap, initialPos.getX(), initialPos.getZ()) ? new BlockPos(initialPos.getX(), entity.level().getHeight(heightmap, initialPos.getX(), initialPos.getZ()) + blocksAbove, initialPos.getZ()) : RandomPos.moveUpOutOfSolid((BlockPos)initialPos, (int)entity.level().getMaxBuildHeight(), predicate).above(blocksAbove - 1);
        return adjustedPos;
    }

    public static boolean isPerch(PathfinderMob entity, BlockPos pos) {
        return entity.level().getBlockState(pos).is(FowlPlayBlockTags.PERCHES);
    }

    public static boolean isPositionNonAir(PathfinderMob entity, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return TargetingUtil.isFullBlockAt(entity, belowPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)belowPos);
    }

    public static boolean isPositionGrounded(PathfinderMob entity, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return TargetingUtil.isFullBlockAt(entity, belowPos);
    }

    public static boolean isFullBlockAt(PathfinderMob entity, BlockPos pos) {
        return entity.level().getBlockState(pos).isSolidRender((BlockGetter)entity.level(), pos);
    }

    public static boolean isWithinAngle(Vec3 normalVec, Vec3 targetVec, double angle) {
        float cosMaxAngle;
        float cosVectorAngle = (float)(normalVec = normalVec.normalize()).dot(targetVec = targetVec.normalize());
        return cosVectorAngle >= (cosMaxAngle = Mth.cos((float)((float)angle)));
    }

    public static boolean isPosWithinViewAngle(PathfinderMob entity, BlockPos pos, double angle) {
        Vec3 lookVec = entity.getViewVector(1.0f);
        Vec3 target = Vec3.atCenterOf((Vec3i)pos);
        Vec3 targetVec = target.subtract(entity.position());
        return TargetingUtil.isWithinAngle(lookVec, targetVec, angle);
    }
}

