/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.ai.control.BirdBodyControl;
import aqario.fowlplay.common.entity.ai.control.BirdLookControl;
import aqario.fowlplay.common.entity.ai.control.BirdMoveControl;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.platform.CustomSpawnGroup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BirdEntity
extends Animal {
    private boolean ambient;
    private int eatingTime;
    protected int idleAnimationChance;
    protected int callChance;
    protected int songChance;

    protected BirdEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21553_(true);
        this.f_21342_ = this.createMoveControl();
        this.f_21365_ = new BirdLookControl((Mob)this, 85);
        this.idleAnimationChance = this.f_19796_.m_188503_(this.getIdleAnimationDelay()) - this.getIdleAnimationDelay();
        this.callChance = this.f_19796_.m_188503_(this.getCallDelay()) - this.getCallDelay();
        this.songChance = this.f_19796_.m_188503_(this.getSongDelay()) - this.getSongDelay();
    }

    public static AttributeSupplier.Builder createBirdAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.m_146922_(world.m_213780_().m_188501_() * 360.0f);
        this.m_5618_(this.m_146908_());
        this.m_5616_(this.m_146908_());
        if (this.m_6095_().m_20674_() == CustomSpawnGroup.ambientBirds()) {
            this.setAmbient(true);
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("ambient", this.ambient);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("ambient")) {
            this.setAmbient(nbt.m_128471_("ambient"));
        } else {
            this.setAmbient(this.m_6095_().m_20674_() == CustomSpawnGroup.ambientBirds());
        }
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    protected void setAmbient(boolean ambient) {
        this.ambient = ambient;
    }

    public boolean m_6785_(double distanceSquared) {
        return this.isAmbient() && !this.m_21532_() && !this.m_8077_();
    }

    public int m_5792_() {
        return 8;
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentSlot = BirdEntity.m_147233_((ItemStack)stack);
        if (!this.m_6844_(equipmentSlot).m_41619_()) {
            return false;
        }
        return equipmentSlot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack heldStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return this.getFood().test(stack) && !this.getFood().test(heldStack);
    }

    private void dropWithoutDelay(ItemStack stack, Entity thrower) {
        ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        if (thrower != null) {
            item.m_32052_(thrower.m_20148_());
        }
        this.m_9236_().m_7967_((Entity)item);
    }

    protected void m_7581_(ItemEntity item) {
        Entity thrower = item.m_19749_();
        ItemStack stack = item.m_32055_();
        if (this.m_7252_(stack)) {
            int i = stack.m_41613_();
            if (i > 1) {
                this.dropWithoutDelay(stack.m_41620_(i - 1), thrower);
            }
            this.m_19983_(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(item);
            this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41620_(1));
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)item, stack.m_41613_());
            item.m_146870_();
            this.eatingTime = 0;
            if (this.m_6274_().m_21876_(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_PRESENT)) {
                this.m_6274_().m_21936_(FowlPlayMemoryModuleType.SEES_FOOD.get());
            }
        }
    }

    public boolean isBelowWaterline() {
        return this.m_5842_() || this.m_204036_(FluidTags.f_13131_) > (double)this.getWaterline();
    }

    public abstract float getWaterline();

    private boolean canEat(ItemStack stack) {
        return this.getFood().test(stack);
    }

    public abstract Ingredient getFood();

    public boolean canHunt(LivingEntity target) {
        return false;
    }

    public boolean shouldAttack(LivingEntity target) {
        return false;
    }

    public boolean shouldAvoid(LivingEntity entity) {
        return false;
    }

    public int getFleeRange(LivingEntity target) {
        return Birds.notFlightless((Entity)target) ? 32 : 12;
    }

    public boolean hasLowHealth() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    public boolean m_6779_(LivingEntity target) {
        return super.m_6779_(target) && (this.shouldAttack(target) || this.canHunt(target));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            ++this.eatingTime;
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(stack)) {
                if (this.eatingTime > 40 && this.f_19796_.m_188501_() < 0.05f || this.eatingTime > 200) {
                    if (stack.m_41720_().m_41472_()) {
                        this.m_5634_(stack.m_41720_().m_41473_().m_38744_());
                    } else {
                        stack.m_41774_(1);
                    }
                    ItemStack usedStack = stack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!usedStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, usedStack);
                    }
                    this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                    this.eatingTime = 0;
                    return;
                }
                if (this.eatingTime > 20 && this.f_19796_.m_188501_() < 0.05f) {
                    this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            } else if (!stack.m_41619_() && !this.getFood().test(stack) && this.f_19796_.m_188501_() < 0.1f) {
                this.m_19983_(this.m_6844_(EquipmentSlot.MAINHAND));
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
    }

    public void m_7822_(byte status) {
        if (status == 45) {
            ItemStack food = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!food.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, food), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(status);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_9236_().m_46473_().m_6180_("birdBaseTick");
        if (this.m_6084_() && this.f_19796_.m_188503_(1000) < this.callChance++) {
            this.resetCallDelay();
            if (this.canCall()) {
                this.playCallSound();
            }
        } else if (this.m_6084_() && this.f_19796_.m_188503_(1000) < this.songChance++) {
            this.resetSongDelay();
            if (this.canSing()) {
                this.playSongSound();
            }
        }
        this.m_9236_().m_46473_().m_7238_();
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.updateAnimations();
        }
        super.m_8119_();
    }

    protected void updateAnimations() {
    }

    protected int getIdleAnimationDelay() {
        return 240;
    }

    protected void resetIdleAnimationDelay() {
        this.idleAnimationChance = -(this.getIdleAnimationDelay() + this.f_19796_.m_216332_(-200, 200));
    }

    protected boolean canCall() {
        return this.m_9236_().m_46461_() || this.f_19796_.m_188501_() < 0.05f;
    }

    protected boolean canSing() {
        return this.m_9236_().m_46461_() && this.m_20096_() && !this.m_6162_();
    }

    private void resetCallDelay() {
        this.callChance = -(this.getCallDelay() + this.f_19796_.m_216332_(-150, 150));
    }

    private void resetSongDelay() {
        this.songChance = -(this.getSongDelay() + this.f_19796_.m_216332_(-150, 150));
    }

    public final void playCallSound() {
        SoundEvent call = this.getCallSound();
        if (call != null) {
            this.m_5496_(call, this.getCallVolume(), this.m_6100_());
        }
    }

    public final void playSongSound() {
        SoundEvent song = this.getSongSound();
        if (song != null) {
            this.m_5496_(song, this.getSongVolume(), this.m_6100_());
        }
    }

    protected void m_6677_(DamageSource damageSource) {
        this.resetCallDelay();
        this.resetSongDelay();
        SoundEvent hurt = this.m_7975_(damageSource);
        if (hurt != null) {
            this.m_5496_(hurt, this.getCallVolume(), this.m_6100_());
        }
    }

    public int getCallDelay() {
        return 240;
    }

    public int getSongDelay() {
        return 720;
    }

    @Nullable
    protected SoundEvent getCallSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getSongSound() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return FowlPlaySoundEvents.ENTITY_BIRD_EAT.get();
    }

    protected float getCallVolume() {
        return 1.0f;
    }

    protected float getSongVolume() {
        return 1.0f;
    }

    public int m_21529_() {
        return 100;
    }

    public int m_8132_() {
        return 100;
    }

    public int m_8085_() {
        return 90;
    }

    protected MoveControl createMoveControl() {
        return new BirdMoveControl(this);
    }

    protected BodyRotationControl m_7560_() {
        return new BirdBodyControl(this);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.SOUNDS;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.05f + 1.0f;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }
}

