/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.pathing.FlightNavigation;
import aqario.fowlplay.common.entity.ai.pathing.GroundNavigation;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.object.SquareRadius;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class FlyingBirdEntity
extends BirdEntity {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(FlyingBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isFlightNavigation;
    private float prevRoll;
    private float visualRoll;
    public int timeFlying = 0;
    private static final int ROLL_FACTOR = 4;
    private static final float MIN_HEALTH_TO_FLY = 1.5f;
    private static final int MIN_FLIGHT_TIME = 15;

    protected FlyingBirdEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
        this.setNavigation(false);
    }

    public static AttributeSupplier.Builder createFlyingBirdAttributes() {
        return BirdEntity.createBirdAttributes().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22280_, (double)0.235f);
    }

    private static boolean hasSkyAccess(LevelAccessor world, BlockPos pos) {
        return world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_();
    }

    private static boolean isMidairSpawn(LevelAccessor world, BlockPos pos) {
        return world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_() - 32 && world.m_8055_(pos.m_7495_()).m_60795_();
    }

    public static boolean canSpawnPasserines(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.m_8055_(pos.m_7495_()).m_60734_() instanceof LeavesBlock && (Integer)world.m_8055_(pos.m_7495_()).m_61143_((Property)BlockStateProperties.f_61414_) < 7 || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    public static boolean canSpawnShorebirds(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.m_8055_(pos.m_7495_()).m_204336_(FowlPlayBlockTags.SHOREBIRDS_SPAWNABLE_ON) || world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    public static boolean canSpawnWaterfowl(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    protected PathNavigation m_6037_(Level world) {
        this.setNavigation(this.isFlying());
        return this.f_21344_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("flying", this.isFlying());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setFlying(nbt.m_128471_("flying"));
    }

    protected void m_142043_() {
        this.m_5496_(FowlPlaySoundEvents.ENTITY_BIRD_FLAP.get(), this.getFlapVolume(), this.getFlapPitch());
    }

    public abstract int getFlapFrequency();

    public abstract float getFlapVolume();

    public abstract float getFlapPitch();

    public SquareRadius getWalkRange() {
        return new SquareRadius(16.0, 8.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isFlying()) {
                ++this.timeFlying;
                this.m_20242_(true);
                this.f_19789_ = 0.0f;
                if (this.shouldStopFlying()) {
                    this.stopFlying();
                }
            } else {
                this.timeFlying = 0;
                this.m_20242_(false);
            }
            if (this.isFlying() != this.isFlightNavigation) {
                this.setNavigation(this.isFlying());
            }
        }
        this.prevRoll = this.visualRoll;
        this.visualRoll = this.calculateRoll(this.f_19859_, this.m_146908_());
    }

    private float calculateRoll(float prevYaw, float currentYaw) {
        float difference = currentYaw - prevYaw;
        if (difference >= 180.0f) {
            difference = 360.0f - difference;
        }
        if (difference < -180.0f) {
            difference = -(360.0f + difference);
        }
        return -difference * 4.0f;
    }

    public float getRoll(float tickDelta) {
        return tickDelta == 1.0f ? this.visualRoll : Mth.m_14179_((float)tickDelta, (float)this.prevRoll, (float)this.visualRoll);
    }

    protected PathNavigation getLandNavigation() {
        return new GroundNavigation((Mob)this, this.m_9236_());
    }

    protected FlightNavigation getFlightNavigation() {
        FlightNavigation navigation = new FlightNavigation(this, this.m_9236_());
        navigation.m_26477_(false);
        navigation.m_148214_(true);
        navigation.m_7008_(this.canSwim());
        return navigation;
    }

    public int getMaxPitchChange() {
        return 20;
    }

    public int getMaxYawChange() {
        return 20;
    }

    protected boolean canSwim() {
        return false;
    }

    public void setNavigation(boolean isFlying) {
        if (isFlying) {
            this.f_21344_ = this.getFlightNavigation();
            this.isFlightNavigation = true;
        } else {
            this.f_21344_ = this.getLandNavigation();
            this.isFlightNavigation = false;
        }
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return this.m_6095_().m_204039_(FowlPlayEntityTypeTags.PASSERINES) && world.m_8055_(pos.m_7495_()).m_204336_(FowlPlayBlockTags.PERCHES) ? 1.0f : 0.0f;
    }

    protected float m_274460_() {
        return this.isFlying() ? this.m_6113_() : super.m_274460_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return !this.isFlying() && super.m_142535_(fallDistance, damageMultiplier, damageSource);
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        if (!this.isFlying()) {
            super.m_7840_(heightDifference, onGround, landedState, landedPosition);
        }
    }

    public boolean canStartFlying() {
        return !this.isFlying() && !this.isBelowWaterline() && this.m_21223_() >= 1.5f;
    }

    public boolean shouldStopFlying() {
        if (this.m_5842_()) {
            return true;
        }
        if (this.timeFlying < 15) {
            return false;
        }
        return this.m_20096_() || this.isBelowWaterline() || this.m_21223_() < 1.5f;
    }

    public void startFlying() {
        this.setFlying(true);
        this.setNavigation(true);
    }

    public void stopFlying() {
        this.setFlying(false);
        this.setNavigation(false);
        this.m_21573_().m_26573_();
        Brain brain = this.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26370_);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    @VisibleForTesting
    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    protected void playSecondaryStepSound(BlockState state) {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected void playCombinationStepSounds(BlockState primaryState, BlockState secondaryState) {
    }

    public void m_267651_(boolean flutter) {
        float speed;
        float yDelta = (float)(this.m_20186_() - this.f_19855_);
        float posDelta = !this.isFlying() || yDelta > 0.0f ? (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)0.0, (double)(this.m_20189_() - this.f_19856_)) : (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)yDelta, (double)(this.m_20189_() - this.f_19856_));
        if (this.isFlying()) {
            speed = Math.abs(1.0f - Math.min(posDelta * 0.8f, 1.0f));
            if (yDelta > 0.0f) {
                speed = (float)Math.sqrt(speed * speed + yDelta * yDelta * 4.0f);
            }
        } else {
            speed = Math.min(posDelta * 4.0f, 1.0f);
        }
        this.f_267362_.m_267566_(speed, 0.4f);
    }

    protected void m_267689_(float posDelta) {
    }

    public void m_7023_(Vec3 movementInput) {
        if (!this.isFlying()) {
            super.m_7023_(movementInput);
            return;
        }
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(this.isBelowWaterline() ? 0.02f : this.m_6113_(), movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                float friction = 0.75f;
                this.m_19920_(this.m_6113_(), movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)friction));
            }
        }
        this.m_267651_(false);
    }
}

