/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTasks;
import aqario.fowlplay.common.entity.ai.brain.task.GoToNearestItemTask;
import aqario.fowlplay.common.entity.ai.brain.task.MoveAwayFromTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetWalkTargetToClosestAdult;
import aqario.fowlplay.common.entity.ai.brain.task.TargetlessFlyTask;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class HawkEntity
extends TrustingBirdEntity
implements SmartBrainOwner<HawkEntity> {
    public final AnimationState standingState = new AnimationState();
    public final AnimationState glidingState = new AnimationState();
    public final AnimationState floatingState = new AnimationState();
    private int timeSinceLastFlap = this.getFlapFrequency();
    private int flapTime = 0;

    public HawkEntity(EntityType<? extends HawkEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public int getFlapFrequency() {
        return 100;
    }

    public static AttributeSupplier.Builder createHawkAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, (double)0.225f).m_22268_(Attributes.f_22280_, (double)0.24f);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.7f;
    }

    @Override
    public int getMaxPitchChange() {
        return 15;
    }

    @Override
    public int getMaxYawChange() {
        return 15;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
    }

    public boolean m_6162_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.m_204132_(FowlPlayItemTags.HAWK_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.HAWK_AVOIDS);
    }

    @Override
    public boolean canHunt(LivingEntity target) {
        return target.m_6095_().m_204039_(FowlPlayEntityTypeTags.HAWK_HUNT_TARGETS) || target.m_6095_().m_204039_(FowlPlayEntityTypeTags.HAWK_BABY_HUNT_TARGETS) && target.m_6162_();
    }

    @Override
    public boolean shouldAttack(LivingEntity target) {
        if (this.hasLowHealth()) {
            return false;
        }
        Optional hurtBy = this.m_6274_().m_21952_(MemoryModuleType.f_26382_);
        return hurtBy.isPresent() && ((LivingEntity)hurtBy.get()).equals((Object)target);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() != MobEffects.f_19612_ && super.m_7301_(effect);
    }

    @Override
    public void updateAnimations() {
        this.standingState.m_246184_(!this.isFlying() && !this.m_20072_(), this.f_19797_);
        this.glidingState.m_246184_(this.isFlying(), this.f_19797_);
        if (this.isFlying()) {
            if (this.timeSinceLastFlap > this.getFlapFrequency()) {
                this.timeSinceLastFlap = 0;
                ++this.flapTime;
            } else if (this.isCurrentlyFlapping()) {
                ++this.flapTime;
            } else {
                ++this.timeSinceLastFlap;
                this.flapTime = 0;
            }
        } else {
            this.timeSinceLastFlap = this.getFlapFrequency();
            this.flapTime = 0;
        }
        this.floatingState.m_246184_(!this.isFlying() && this.m_20072_(), this.f_19797_);
    }

    private boolean isCurrentlyFlapping() {
        return this.flapTime > 0 && this.flapTime < 60;
    }

    protected boolean m_142039_() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.8f;
    }

    @Override
    public float getFlapPitch() {
        return 0.6f;
    }

    @Override
    public float getWaterline() {
        return 0.5f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_HAWK_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().hawkCallVolume;
    }

    @Override
    public int getCallDelay() {
        return 800;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_HAWK_HURT.get();
    }

    protected Brain.Provider<HawkEntity> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends HawkEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10), new AttackTargetSensor().setScanRate(bird -> 10)});
    }

    public BrainActivityGroup<? extends HawkEntity> getCoreTasks() {
        return new BrainActivityGroup(Activity.f_37978_).priority(0).behaviours(new Behavior[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightTasks.stopFalling(), new SetAttackTarget().attackPredicate(Birds::canAttack), new LookAtTarget().runFor(entity -> entity.m_217043_().m_216332_(45, 90)), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<? extends HawkEntity> getIdleTasks() {
        return new BrainActivityGroup(Activity.f_37979_).priority(10).behaviours(new Behavior[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTargetTask.create(Birds::isPlayerHoldingFood), new SetRandomLookTarget().lookTime(entity -> entity.m_217043_().m_216332_(150, 250)), new OneRandomBehaviour(new Pair[]{Pair.of(TargetlessFlyTask.create(), (Object)1)}).startCondition(entity -> entity.isFlying() && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(24.0, 12.0).startCondition(Predicate.not(Birds::isPerched)), (Object)4), Pair.of((Object)new Idle().runFor(entity -> entity.m_217043_().m_216332_(100, 300)), (Object)4)}).startCondition(entity -> !entity.isFlying() && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_))}).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.IS_AVOIDING.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(MemoryModuleType.f_26372_, MemoryStatus.VALUE_ABSENT);
    }

    public BrainActivityGroup<? extends HawkEntity> getPerchTasks() {
        return new BrainActivityGroup(FowlPlayActivities.PERCH.get()).priority(10).behaviours(new Behavior[]{TargetlessFlyTask.perch().startCondition(entity -> !Birds.isPerched(entity) && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new Idle().runFor(entity -> entity.m_217043_().m_216332_(300, 1000)), (Object)8), Pair.of(TargetlessFlyTask.perch(), (Object)1)}).startCondition(Birds::isPerched)}).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.IS_AVOIDING.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(MemoryModuleType.f_26372_, MemoryStatus.VALUE_ABSENT);
    }

    public BrainActivityGroup<? extends HawkEntity> getSoarTasks() {
        return new BrainActivityGroup(FowlPlayActivities.SOAR.get()).priority(10).behaviours(new Behavior[]{new OneRandomBehaviour(new Pair[]{Pair.of(TargetlessFlyTask.perch(), (Object)1), Pair.of(TargetlessFlyTask.create(), (Object)5), Pair.of(SetWalkTargetToClosestAdult.create(Birds.STAY_NEAR_ENTITY_RANGE), (Object)2)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_))}).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.IS_AVOIDING.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(MemoryModuleType.f_26372_, MemoryStatus.VALUE_ABSENT);
    }

    public BrainActivityGroup<? extends HawkEntity> getAvoidTasks() {
        return new BrainActivityGroup(Activity.f_37991_).priority(10).behaviours(new Behavior[]{MoveAwayFromTargetTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.f_26383_, entity -> Float.valueOf(1.4f), true)}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{FowlPlayMemoryModuleType.IS_AVOIDING.get()});
    }

    public BrainActivityGroup<? extends HawkEntity> getPickupFoodTasks() {
        return new BrainActivityGroup(FowlPlayActivities.PICK_UP.get()).priority(10).behaviours(new Behavior[]{GoToNearestItemTask.create(Birds::canPickupFood, entity -> Float.valueOf(1.4f), true, 32)}).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.IS_AVOIDING.get(), MemoryStatus.VALUE_ABSENT);
    }

    public BrainActivityGroup<? extends HawkEntity> getFightTasks() {
        return new BrainActivityGroup(Activity.f_37988_).priority(10).behaviours(new Behavior[]{new InvalidateAttackTarget(), FlightTasks.startFlying(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0), new InvalidateMemory(MemoryModuleType.f_26372_).invalidateIf((entity, memory) -> BehaviorUtils.m_217126_((LivingEntity)entity))}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{MemoryModuleType.f_26372_});
    }

    public Map<Activity, BrainActivityGroup<? extends HawkEntity>> getAdditionalTasks() {
        Object2ObjectOpenHashMap taskList = new Object2ObjectOpenHashMap();
        taskList.put((Object)FowlPlayActivities.PERCH.get(), this.getPerchTasks());
        taskList.put((Object)FowlPlayActivities.SOAR.get(), this.getSoarTasks());
        taskList.put((Object)Activity.f_37991_, this.getAvoidTasks());
        taskList.put((Object)FowlPlayActivities.PICK_UP.get(), this.getPickupFoodTasks());
        return taskList;
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.f_37991_, Activity.f_37988_, FowlPlayActivities.PICK_UP.get(), FowlPlayActivities.PERCH.get(), FowlPlayActivities.SOAR.get(), Activity.f_37979_});
    }

    protected void m_8024_() {
        Brain brain = this.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        this.tickBrain((LivingEntity)this);
        if (activity == Activity.f_37988_ && brain.m_21968_().orElse(null) != Activity.f_37988_) {
            brain.m_21882_(MemoryModuleType.f_148201_, (Object)true, 2400L);
        }
        super.m_8024_();
    }
}

