/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.task.BreatheAirTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToLandTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToNearestItemTask;
import aqario.fowlplay.common.entity.ai.brain.task.MoveAwayFromTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.PenguinSpecificTasks;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetWalkTargetToClosestAdult;
import aqario.fowlplay.common.entity.ai.brain.task.SlideTasks;
import aqario.fowlplay.common.entity.ai.control.BirdAquaticMoveControl;
import aqario.fowlplay.common.entity.ai.pathing.AmphibiousNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlayEntityType;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlayParticleTypes;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PenguinEntity
extends BirdEntity
implements SmartBrainOwner<PenguinEntity> {
    private static final int SLIDING_TRANSITION_TICKS = 15;
    private static final int STANDING_TRANSITION_TICKS = 20;
    private static final long LAST_POSE_CHANGE_TICKS = 0L;
    public static final EntityDataAccessor<Long> LAST_POSE_TICK = SynchedEntityData.m_135353_(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final int SWIM_PARTICLE_COUNT = 15;
    public final AnimationState standingState = new AnimationState();
    public final AnimationState slidingState = new AnimationState();
    public final AnimationState slidingTransitionState = new AnimationState();
    public final AnimationState standingTransitionState = new AnimationState();
    public final AnimationState flappingState = new AnimationState();
    public final AnimationState swimmingState = new AnimationState();
    public final AnimationState dancingState = new AnimationState();
    private boolean songPlaying;
    @Nullable
    private BlockPos songSource;

    public PenguinEntity(EntityType<? extends PenguinEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 85);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_20089_() == Pose.LONG_JUMPING || this.m_20089_() == Pose.SWIMMING ? 0.4f : 1.35f;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected float m_274460_() {
        return this.m_20072_() ? this.m_6113_() : super.m_274460_();
    }

    public float m_6113_() {
        return this.m_20089_() == Pose.LONG_JUMPING ? super.m_6113_() * 1.5f : super.m_6113_();
    }

    @Override
    protected MoveControl createMoveControl() {
        return new BirdAquaticMoveControl(this, 85, 15, 1.0f, 1.0f, true);
    }

    @Override
    public int m_8132_() {
        return this.m_20072_() ? 1 : super.m_8132_();
    }

    @Override
    public int m_8085_() {
        return this.m_20072_() ? 1 : super.m_8085_();
    }

    protected PathNavigation m_6037_(Level world) {
        return new AmphibiousNavigation((Mob)this, this.m_9236_());
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.initLastPoseTick(world.m_6018_().m_46467_());
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)FowlPlayEntityType.PENGUIN.get().m_20615_((Level)world);
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return this.getFood().test(stack);
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.m_204132_(FowlPlayItemTags.PENGUIN_FOOD);
    }

    @Override
    public boolean canHunt(LivingEntity target) {
        return target.m_6095_().m_204039_(FowlPlayEntityTypeTags.PENGUIN_HUNT_TARGETS);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.PENGUIN_AVOIDS);
    }

    public static AttributeSupplier.Builder createPenguinAttributes() {
        return BirdEntity.createBirdAttributes().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.145f);
    }

    public void m_6818_(BlockPos songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    @Override
    public void m_8107_() {
        if (this.songSource == null || !this.songSource.m_203195_((Position)this.m_20182_(), 5.0) || !this.m_9236_().m_8055_(this.songSource).m_60713_(Blocks.f_50131_)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        super.m_8107_();
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_POSE_TICK, (Object)0L);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128356_("lastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_TICK)).longValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        long l = nbt.m_128454_("lastPoseTick");
        if (l < 0L) {
            this.m_20124_(Pose.LONG_JUMPING);
        }
        this.setLastPoseTick(l);
    }

    public void m_269505_(List<SynchedEntityData.DataValue<?>> entries) {
        super.m_269505_(entries);
        this.m_6210_();
    }

    @Override
    public void m_8119_() {
        if (this.m_6688_() != null && this.m_20072_()) {
            this.m_6688_().m_8127_();
        }
        if (this.m_20072_() && !this.isSliding()) {
            this.setSliding();
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.m_20072_() && this.m_20184_().m_82556_() > 0.02) {
            this.addSwimParticles();
        }
        if (this.m_6069_()) {
            this.m_20124_(Pose.SWIMMING);
        } else if (this.isSliding()) {
            this.m_20124_(Pose.LONG_JUMPING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
    }

    private void addSwimParticles() {
        Vec3 velocity = this.m_20154_().m_82548_().m_82490_(0.5);
        for (int i = 0; i < 15; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)FowlPlayParticleTypes.SMALL_BUBBLE.get(), this.m_20185_() + (double)(this.f_19796_.m_188501_() * 0.75f - 0.375f), this.m_20186_() + this.m_20191_().m_82376_() / 2.0 + (double)(this.f_19796_.m_188501_() * 0.75f - 0.375f), this.m_20189_() + (double)(this.f_19796_.m_188501_() * 0.75f - 0.375f), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    protected void updateAnimations() {
        this.standingState.m_246184_(this.m_20096_() && !this.m_20072_() && !this.isSliding(), this.f_19797_);
        if (this.m_20072_()) {
            this.standingState.m_216973_();
            this.swimmingState.m_216982_(this.f_19797_);
        } else {
            this.swimmingState.m_216973_();
        }
        if (this.shouldUpdateSlidingAnimations() && !this.m_20072_()) {
            this.standingState.m_216973_();
            if (this.shouldPlaySlidingTransition()) {
                this.slidingTransitionState.m_216982_(this.f_19797_);
                this.slidingState.m_216973_();
            } else {
                this.slidingTransitionState.m_216973_();
                this.slidingState.m_216982_(this.f_19797_);
            }
        } else {
            this.slidingTransitionState.m_216973_();
            this.slidingState.m_216973_();
            this.standingTransitionState.m_246184_(this.isChangingPose() && this.getLastPoseTickDelta() >= 0L, this.f_19797_);
        }
        if (this.isSongPlaying() && this.m_20096_()) {
            this.dancingState.m_216982_(this.f_19797_);
            this.setStanding();
            this.standingState.m_216973_();
        } else {
            this.dancingState.m_216973_();
        }
    }

    public boolean canStartSliding() {
        return !this.m_20072_() && !this.m_20160_() && this.m_20096_() && (this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_204336_(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.m_9236_().m_8055_(this.m_20183_()).m_204336_(FowlPlayBlockTags.PENGUINS_SLIDE_ON));
    }

    public boolean isSliding() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_TICK) < 0L;
    }

    public boolean shouldUpdateSlidingAnimations() {
        return this.getLastPoseTickDelta() < 0L != this.isSliding();
    }

    public boolean isChangingPose() {
        long l = this.getLastPoseTickDelta();
        return l < (long)(this.isSliding() ? 15 : 20);
    }

    private boolean shouldPlaySlidingTransition() {
        return this.isSliding() && this.getLastPoseTickDelta() < 15L && this.getLastPoseTickDelta() >= 0L;
    }

    public void startSliding() {
        if (!this.isSliding()) {
            this.m_20124_(Pose.LONG_JUMPING);
            this.setLastPoseTick(-this.m_9236_().m_46467_());
        }
    }

    public void stopSliding() {
        if (this.isSliding()) {
            this.m_20124_(Pose.STANDING);
            this.setLastPoseTick(this.m_9236_().m_46467_());
        }
    }

    public void setStanding() {
        this.m_20124_(Pose.STANDING);
        this.initLastPoseTick(this.m_9236_().m_46467_());
    }

    public void setSliding() {
        this.m_20124_(Pose.LONG_JUMPING);
        this.setLastPoseTick(-Math.max(0L, this.m_9236_().m_46467_() - 15L - 1L));
    }

    private void setLastPoseTick(long lastPoseTick) {
        this.f_19804_.m_135381_(LAST_POSE_TICK, (Object)lastPoseTick);
    }

    private void initLastPoseTick(long time) {
        this.setLastPoseTick(Math.max(0L, time - 20L - 1L));
    }

    public long getLastPoseTickDelta() {
        return this.m_9236_().m_46467_() - Math.abs((Long)this.f_19804_.m_135370_(LAST_POSE_TICK));
    }

    public void m_5844_() {
        this.m_20282_(this.m_20072_() && !this.m_20159_());
    }

    protected void clampPassengerYaw(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity passenger) {
        this.clampPassengerYaw(passenger);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        float g = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
        Vec3 vec3d = new Vec3(this.getMountedXOffset(), 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        passenger.m_6034_(this.m_20185_() + vec3d.f_82479_, this.m_20186_() + (double)g, this.m_20189_() + vec3d.f_82481_);
        super.m_19956_(passenger, positionUpdater);
    }

    public double m_6048_() {
        return 0.0;
    }

    public double getMountedXOffset() {
        return -0.1;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 vec3d = PenguinEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)passenger.m_20205_(), (float)passenger.m_146908_());
        double d = this.m_20185_() + vec3d.f_82479_;
        double e = this.m_20189_() + vec3d.f_82481_;
        BlockPos blockPos = new BlockPos((int)d, (int)this.m_20191_().f_82292_, (int)e);
        BlockPos blockPos2 = blockPos.m_7495_();
        if (!this.m_9236_().m_46801_(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.m_9236_().m_45573_(blockPos);
            if (DismountHelper.m_38439_((double)f)) {
                list.add(new Vec3(d, (double)blockPos.m_123342_() + f, e));
            }
            if (DismountHelper.m_38439_((double)(g = this.m_9236_().m_45573_(blockPos2)))) {
                list.add(new Vec3(d, (double)blockPos2.m_123342_() + g, e));
            }
            for (Pose entityPose : passenger.m_7431_()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.m_20124_(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    public float m_274421_() {
        return this.m_20089_() == Pose.LONG_JUMPING ? 1.1f : super.m_274421_();
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.62f : 1.0f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        return pose == Pose.LONG_JUMPING || pose == Pose.SWIMMING ? dimensions.m_20390_(1.0f, 0.35f) : dimensions;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    protected boolean canBreed() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7848_(Animal other) {
        if (other == this) return false;
        if (!(other instanceof PenguinEntity)) return false;
        PenguinEntity penguin = (PenguinEntity)other;
        if (!this.canBreed()) return false;
        if (!penguin.canBreed()) return false;
        return true;
    }

    public boolean shouldStepDown() {
        BlockPos pos = this.m_20183_();
        return !this.m_20096_() && this.f_19789_ > 0.0f && this.f_19789_ < 0.1f && !this.m_9236_().m_8055_(pos.m_7495_()).m_60812_((BlockGetter)this.m_9236_(), pos.m_7495_()).m_83281_();
    }

    @Nullable
    public LivingEntity m_6688_() {
        return (LivingEntity)this.m_146895_();
    }

    protected boolean m_7310_(Entity passenger) {
        return super.m_7310_(passenger) && !this.m_5842_();
    }

    protected boolean m_20073_() {
        boolean touchingWater = this.m_20069_();
        boolean bl = super.m_20073_();
        if (touchingWater != this.m_20069_()) {
            this.m_20124_(this.m_20069_() ? Pose.SWIMMING : Pose.STANDING);
            this.m_6210_();
        }
        return bl;
    }

    public static boolean canSpawnPenguins(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_204166_(pos).m_203656_(FowlPlayBiomeTags.SPAWNS_PENGUINS) && world.m_8055_(pos.m_7495_()).m_204336_(FowlPlayBlockTags.PENGUINS_SPAWNABLE_ON);
    }

    protected void m_274498_(Player player, Vec3 input) {
        super.m_274498_(player, input);
        float sidewaysMovement = player.f_20900_;
        double rotation = 3.0;
        if (Math.abs(sidewaysMovement) == 0.0f) {
            rotation = 0.0;
        }
        this.m_19915_((float)((double)this.m_146908_() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)), this.m_146909_());
        player.m_146922_((float)((double)player.m_146908_() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)) % 360.0f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 input) {
        float forwardMovement = player.f_20902_ * 0.2f;
        if (this.m_9236_().m_8055_(this.m_20099_()).m_204336_(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.m_146900_().m_204336_(FowlPlayBlockTags.PENGUINS_SLIDE_ON)) {
            forwardMovement *= 2.0f;
        }
        return new Vec3(0.0, 0.0, (double)Math.max(forwardMovement, 0.0f));
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public int m_6062_() {
        return 9600;
    }

    protected int m_7305_(int air) {
        return this.m_6062_();
    }

    @Override
    public float getWaterline() {
        return 0.0f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean bl = this.m_6898_(player.m_21120_(hand));
        if (!(bl || this.m_20160_() || player.m_36341_() || this.m_6162_() || !this.isSliding())) {
            if (!this.m_9236_().f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        if (this.m_20089_() == Pose.LONG_JUMPING) {
            return (super.m_5639_(fallDistance, damageMultiplier) - 3) / 2;
        }
        return super.m_5639_(fallDistance, damageMultiplier);
    }

    @Override
    protected boolean canCall() {
        return !this.m_20072_() && super.canCall();
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return this.m_6162_() ? FowlPlaySoundEvents.ENTITY_PENGUIN_BABY_CALL.get() : FowlPlaySoundEvents.ENTITY_PENGUIN_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().penguinCallVolume;
    }

    protected SoundEvent m_5501_() {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_SWIM.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_HURT.get();
    }

    protected Brain.Provider<PenguinEntity> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends PenguinEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new ItemTemptingSensor().temptedWith((entity, stack) -> this.getFood().test(stack)), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10), new AttackTargetSensor().setScanRate(bird -> 10)});
    }

    public BrainActivityGroup<? extends PenguinEntity> getCoreTasks() {
        return new BrainActivityGroup(Activity.f_37978_).priority(0).behaviours(new Behavior[]{new BreatheAirTask(), new SetAttackTarget().attackPredicate(Birds::canAquaticAttack), new LookAtTarget().runFor(entity -> entity.m_217043_().m_216332_(45, 90)), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<? extends PenguinEntity> getIdleTasks() {
        return new BrainActivityGroup(Activity.f_37979_).priority(10).behaviours(new Behavior[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTargetTask.create(EntityType.f_20532_), new FollowTemptation(), new SetRandomLookTarget().lookTime(entity -> entity.m_217043_().m_216332_(150, 250)), new OneRandomBehaviour(new Pair[]{Pair.of(GoToLandTask.create(32), (Object)5), Pair.of(PenguinSpecificTasks.swim(), (Object)2)}).startCondition(entity -> entity.m_20072_() && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(24.0, 12.0), (Object)2), Pair.of(SlideTasks.toggleSliding(20), (Object)5), Pair.of((Object)new Idle().runFor(entity -> entity.m_217043_().m_216332_(400, 800)), (Object)5), Pair.of(SetWalkTargetToClosestAdult.create(Birds.STAY_NEAR_ENTITY_RANGE), (Object)2), Pair.of(PenguinSpecificTasks.goToWater(), (Object)6)}).startCondition(entity -> !entity.m_20072_() && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_))}).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.IS_AVOIDING.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_ABSENT).onlyStartWithMemoryStatus(MemoryModuleType.f_26372_, MemoryStatus.VALUE_ABSENT);
    }

    public BrainActivityGroup<? extends PenguinEntity> getAvoidTasks() {
        return new BrainActivityGroup(Activity.f_37991_).priority(10).behaviours(new Behavior[]{MoveAwayFromTargetTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.f_26383_, entity -> Float.valueOf(1.4f), true)}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{FowlPlayMemoryModuleType.IS_AVOIDING.get()});
    }

    public BrainActivityGroup<? extends PenguinEntity> getPickupFoodTasks() {
        return new BrainActivityGroup(FowlPlayActivities.PICK_UP.get()).priority(10).behaviours(new Behavior[]{SlideTasks.startSliding(), GoToNearestItemTask.create(Birds::canPickupFood, entity -> Float.valueOf(1.4f), true, 32)}).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.SEES_FOOD.get(), MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus(FowlPlayMemoryModuleType.IS_AVOIDING.get(), MemoryStatus.VALUE_ABSENT);
    }

    public BrainActivityGroup<? extends PenguinEntity> getFightTasks() {
        return new BrainActivityGroup(Activity.f_37988_).priority(10).behaviours(new Behavior[]{new InvalidateAttackTarget(), SlideTasks.startSliding(), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.4f)), new AnimatableMeleeAttack(0), new InvalidateMemory(MemoryModuleType.f_26372_).invalidateIf((entity, memory) -> BehaviorUtils.m_217126_((LivingEntity)entity))}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{MemoryModuleType.f_26372_});
    }

    public Map<Activity, BrainActivityGroup<? extends PenguinEntity>> getAdditionalTasks() {
        Object2ObjectOpenHashMap taskList = new Object2ObjectOpenHashMap();
        taskList.put((Object)Activity.f_37991_, this.getAvoidTasks());
        taskList.put((Object)FowlPlayActivities.PICK_UP.get(), this.getPickupFoodTasks());
        return taskList;
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.f_37979_, Activity.f_219847_, Activity.f_37991_, FowlPlayActivities.PICK_UP.get(), Activity.f_37988_});
    }

    protected void m_8024_() {
        Brain brain = this.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        this.tickBrain((LivingEntity)this);
        if (activity == Activity.f_37988_ && brain.m_21968_().orElse(null) != Activity.f_37988_) {
            brain.m_21882_(MemoryModuleType.f_148201_, (Object)true, 2400L);
        }
        super.m_8024_();
    }
}

