/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlaySensorType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class AttackedSensor<E extends BirdEntity>
extends PredicateSensor<DamageSource, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ImmutableList.of((Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26383_, FowlPlayMemoryModuleType.SEES_FOOD.get(), FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD.get());

    public AttackedSensor() {
        super((damageSource, entity) -> true);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return FowlPlaySensorType.ATTACKED.get();
    }

    protected void sense(ServerLevel world, E bird) {
        Brain brain = bird.m_6274_();
        DamageSource damageSource = bird.m_21225_();
        if (damageSource == null) {
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26381_);
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26382_);
            return;
        }
        if (this.predicate().test(damageSource, bird)) {
            LivingEntity attacker2;
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26381_, (Object)damageSource);
            Entity entity = damageSource.m_7639_();
            if (entity instanceof LivingEntity && (attacker2 = (LivingEntity)entity).m_6084_() && attacker2.m_9236_() == bird.m_9236_()) {
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26382_, (Object)attacker2);
                AttackedSensor.onAttacked(bird, attacker2);
            }
            return;
        }
        BrainUtils.withMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26382_, attacker -> {
            if (!attacker.m_6084_() || attacker.m_9236_() != bird.m_9236_()) {
                BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26382_);
            }
        });
    }

    public static <T extends BirdEntity> void onAttacked(T bird, LivingEntity attacker) {
        Brain brain = bird.m_6274_();
        BrainUtils.clearMemory((Brain)brain, FowlPlayMemoryModuleType.SEES_FOOD.get());
        if (attacker instanceof Player) {
            TrustingBirdEntity trustingBird;
            Player player = (Player)attacker;
            BrainUtils.setForgettableMemory((Brain)brain, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD.get(), (Object)true, (int)1200);
            if (bird instanceof TrustingBirdEntity && (trustingBird = (TrustingBirdEntity)bird).trusts(player)) {
                trustingBird.stopTrusting(player);
            }
        }
        if (attacker.m_6095_() != bird.m_6095_() && !bird.shouldAttack(attacker)) {
            Birds.alertOthers(bird, attacker);
        }
    }
}

