/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.task;

import aqario.fowlplay.common.entity.BirdEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ChooseDestinationTasks {
    private static final int DEFAULT_HORIZONTAL_RADIUS = 64;
    private static final int DEFAULT_VERTICAL_RADIUS = 24;
    private static final int[][] RADII = new int[][]{{1, 1}, {3, 3}, {5, 5}, {6, 5}, {7, 7}, {64, 16}};

    public static OneShot<BirdEntity> create() {
        return ChooseDestinationTasks.create(true);
    }

    public static OneShot<BirdEntity> create(boolean strollInsideWater) {
        return ChooseDestinationTasks.create(bird -> LandRandomPos.m_148488_((PathfinderMob)bird, (int)64, (int)24), strollInsideWater ? bird -> true : bird -> !bird.m_20072_());
    }

    public static BehaviorControl<BirdEntity> create(int horizontalRadius, int verticalRadius) {
        return ChooseDestinationTasks.create(bird -> LandRandomPos.m_148488_((PathfinderMob)bird, (int)horizontalRadius, (int)verticalRadius), bird -> true);
    }

    public static BehaviorControl<BirdEntity> createSolidTargeting() {
        return ChooseDestinationTasks.create(bird -> ChooseDestinationTasks.findTargetPos(bird, 64, 24), bird -> true);
    }

    public static BehaviorControl<BirdEntity> createDynamicRadius() {
        return ChooseDestinationTasks.create(ChooseDestinationTasks::findTargetPos, Entity::m_20072_);
    }

    private static OneShot<BirdEntity> create(Function<BirdEntity, Vec3> targetGetter, Predicate<BirdEntity> shouldRun) {
        return BehaviorBuilder.m_258034_(context -> context.group((App)context.m_258080_(MemoryModuleType.f_26370_)).apply((Applicative)context, walkTarget -> (world, bird, time) -> {
            if (!shouldRun.test((BirdEntity)bird)) {
                return false;
            }
            Optional<Vec3> optional = Optional.ofNullable((Vec3)targetGetter.apply((BirdEntity)bird));
            walkTarget.m_257564_(optional.map(pos -> new WalkTarget(pos, 1.0f, 0)));
            return true;
        }));
    }

    @Nullable
    private static Vec3 findTargetPos(BirdEntity bird) {
        Vec3 vec3d = null;
        Vec3 vec3d2 = null;
        for (int[] is : RADII) {
            vec3d2 = vec3d == null ? BehaviorUtils.m_147444_((PathfinderMob)bird, (int)is[0], (int)is[1]) : bird.m_20182_().m_82549_(bird.m_20182_().m_82505_(vec3d).m_82541_().m_82542_((double)is[0], (double)is[1], (double)is[0]));
            if (vec3d2 == null || bird.m_9236_().m_6425_(BlockPos.m_274446_((Position)vec3d2)).m_76178_()) {
                return vec3d;
            }
            vec3d = vec3d2;
        }
        return vec3d2;
    }

    @Nullable
    private static Vec3 findTargetPos(BirdEntity bird, int horizontalRadius, int verticalRadius) {
        Vec3 vec3d = bird.m_20252_(0.0f);
        return AirAndWaterRandomPos.m_148357_((PathfinderMob)bird, (int)horizontalRadius, (int)verticalRadius, (int)-2, (double)vec3d.f_82479_, (double)vec3d.f_82481_, (double)1.5707963705062866);
    }
}

