/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.task;

import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.ai.brain.TeleportTarget;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FollowOwnerTask
extends ExtendedBehaviour<PigeonEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(3).registered(FowlPlayMemoryModuleType.TELEPORT_TARGET.get(), MemoryModuleType.f_26371_, MemoryModuleType.f_26370_);
    private LivingEntity owner;
    private int updateCountdownTicks;
    protected Function<PigeonEntity, Float> speedModifier = entity -> Float.valueOf(1.0f);
    protected UniformInt range = UniformInt.m_146622_((int)5, (int)10);

    public FollowOwnerTask speedModifier(float modifier) {
        return this.speedModifier(entity -> Float.valueOf(modifier));
    }

    public FollowOwnerTask speedModifier(Function<PigeonEntity, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public FollowOwnerTask range(int min, int max) {
        this.range = UniformInt.m_146622_((int)min, (int)max);
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean shouldRun(ServerLevel world, PigeonEntity pigeon) {
        LivingEntity owner = pigeon.m_269323_();
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (pigeon.isSitting()) {
            return false;
        }
        if (pigeon.m_20280_((Entity)owner) < (double)(this.range.m_142739_() * this.range.m_142739_())) {
            return false;
        }
        if (pigeon.getRecipientUuid() != null) {
            return false;
        }
        this.owner = owner;
        return super.m_6114_(world, (LivingEntity)pigeon);
    }

    protected boolean shouldKeepRunning(PigeonEntity pigeon) {
        if (pigeon.getRecipientUuid() != null) {
            return false;
        }
        if (pigeon.m_21573_().m_26571_()) {
            return false;
        }
        if (pigeon.isSitting()) {
            return false;
        }
        return pigeon.m_20280_((Entity)this.owner) > (double)(this.range.m_142737_() * this.range.m_142737_());
    }

    protected void tick(PigeonEntity pigeon) {
        Brain brain = pigeon.m_6274_();
        BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.owner, true));
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 20;
            if (!pigeon.m_21523_() && !pigeon.m_20159_()) {
                if (pigeon.m_20280_((Entity)this.owner) >= 144.0) {
                    BrainUtils.setMemory((Brain)brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get(), (Object)new TeleportTarget((Entity)this.owner));
                } else {
                    BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget((Entity)this.owner, this.speedModifier.apply(pigeon).floatValue(), 0));
                }
            }
        }
    }
}

