/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.task;

import aqario.fowlplay.common.entity.ai.pathing.FlightTargeting;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WalkToTargetTask
extends Behavior<Mob> {
    private static final int MAX_UPDATE_COUNTDOWN = 80;
    private int pathUpdateCountdownTicks;
    @Nullable
    private Path path;
    @Nullable
    private BlockPos lookTargetPos;
    private float speed;

    public WalkToTargetTask() {
        this(150, 250);
    }

    public WalkToTargetTask(int minRunTime, int maxRunTime) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT), minRunTime, maxRunTime);
    }

    protected boolean shouldRun(ServerLevel world, Mob entity) {
        if (this.pathUpdateCountdownTicks > 0) {
            --this.pathUpdateCountdownTicks;
            return false;
        }
        Brain brain = entity.m_6274_();
        if (brain.m_21876_(FowlPlayMemoryModuleType.TELEPORT_TARGET.get(), MemoryStatus.VALUE_PRESENT)) {
            return false;
        }
        WalkTarget walkTarget = (WalkTarget)brain.m_21952_(MemoryModuleType.f_26370_).get();
        boolean reachedTarget = WalkToTargetTask.hasReached(entity, walkTarget);
        if (!reachedTarget && this.hasFinishedPath(entity, walkTarget, world.m_46467_())) {
            this.lookTargetPos = walkTarget.m_26420_().m_6675_();
            return true;
        }
        brain.m_21936_(MemoryModuleType.f_26370_);
        if (reachedTarget) {
            brain.m_21936_(MemoryModuleType.f_26326_);
        }
        return false;
    }

    protected boolean shouldKeepRunning(ServerLevel world, Mob entity, long l) {
        if (this.path == null || this.lookTargetPos == null) {
            return false;
        }
        Optional walkTarget = entity.m_6274_().m_21952_(MemoryModuleType.f_26370_);
        boolean isTargetSpectator = walkTarget.map(WalkToTargetTask::isTargetSpectator).orElse(false);
        PathNavigation navigation = entity.m_21573_();
        return !navigation.m_26571_() && walkTarget.isPresent() && !WalkToTargetTask.hasReached(entity, (WalkTarget)walkTarget.get()) && !isTargetSpectator;
    }

    protected void finishRunning(ServerLevel world, Mob entity, long l) {
        if (entity.m_6274_().m_21874_(MemoryModuleType.f_26370_) && !WalkToTargetTask.hasReached(entity, (WalkTarget)entity.m_6274_().m_21952_(MemoryModuleType.f_26370_).get()) && entity.m_21573_().m_26577_()) {
            this.pathUpdateCountdownTicks = world.m_213780_().m_188503_(80);
        }
        entity.m_21573_().m_26573_();
        entity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26377_);
        this.path = null;
    }

    protected void run(ServerLevel world, Mob entity, long l) {
        entity.m_6274_().m_21879_(MemoryModuleType.f_26377_, (Object)this.path);
        entity.m_21573_().m_26536_(this.path, (double)this.speed);
    }

    protected void keepRunning(ServerLevel world, Mob entity, long l) {
        WalkTarget walkTarget;
        Path path = entity.m_21573_().m_26570_();
        Brain brain = entity.m_6274_();
        if (this.path != path) {
            this.path = path;
            brain.m_21879_(MemoryModuleType.f_26377_, (Object)path);
        }
        if (path != null && this.lookTargetPos != null && (walkTarget = (WalkTarget)brain.m_21952_(MemoryModuleType.f_26370_).get()).m_26420_().m_6675_().m_123331_((Vec3i)this.lookTargetPos) > 4.0 && this.hasFinishedPath(entity, walkTarget, world.m_46467_())) {
            this.lookTargetPos = walkTarget.m_26420_().m_6675_();
            this.run(world, entity, l);
        }
    }

    private boolean hasFinishedPath(Mob entity, WalkTarget walkTarget, long time) {
        boolean bl;
        BlockPos targetPos = walkTarget.m_26420_().m_6675_();
        this.path = entity.m_21573_().m_7864_(targetPos, 0);
        this.speed = walkTarget.m_26421_();
        Brain brain = entity.m_6274_();
        if (WalkToTargetTask.hasReached(entity, walkTarget)) {
            brain.m_21936_(MemoryModuleType.f_26326_);
            return false;
        }
        boolean bl2 = bl = this.path != null && this.path.m_77403_();
        if (bl) {
            brain.m_21936_(MemoryModuleType.f_26326_);
        } else if (!brain.m_21874_(MemoryModuleType.f_26326_)) {
            brain.m_21879_(MemoryModuleType.f_26326_, (Object)time);
        }
        if (this.path != null) {
            return true;
        }
        Vec3 target = FlightTargeting.findTo((PathfinderMob)entity, 32, 16, Vec3.m_82539_((Vec3i)targetPos));
        if (target != null) {
            this.path = entity.m_21573_().m_26524_(target.f_82479_, target.f_82480_, target.f_82481_, 0);
            return this.path != null;
        }
        return false;
    }

    private static boolean hasReached(Mob entity, WalkTarget walkTarget) {
        return walkTarget.m_26420_().m_6675_().m_123333_((Vec3i)entity.m_20183_()) <= walkTarget.m_26422_();
    }

    private static boolean isTargetSpectator(WalkTarget target) {
        EntityTracker entityLookTarget;
        PositionTracker positionTracker = target.m_26420_();
        return positionTracker instanceof EntityTracker && (entityLookTarget = (EntityTracker)positionTracker).m_147481_().m_5833_();
    }
}

