/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.control;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BirdMoveControl
extends MoveControl {
    protected final BirdEntity bird;

    public BirdMoveControl(BirdEntity bird) {
        super((Mob)bird);
        this.bird = bird;
    }

    public void m_8126_() {
        FlyingBirdEntity flyingBird;
        BirdEntity birdEntity = this.bird;
        if (birdEntity instanceof FlyingBirdEntity && (flyingBird = (FlyingBirdEntity)birdEntity).isFlying()) {
            this.tickFlying();
        } else {
            super.m_8126_();
        }
    }

    private void tickFlying() {
        FlyingBirdEntity flyingBird = (FlyingBirdEntity)this.bird;
        this.f_24981_ = MoveControl.Operation.MOVE_TO;
        Vec3 distance = new Vec3(this.f_24975_ - flyingBird.m_20185_(), this.f_24976_ - flyingBird.m_20186_(), this.f_24977_ - flyingBird.m_20189_());
        double squaredDistance = distance.m_82556_();
        if (squaredDistance < 2.500000277905201E-7) {
            flyingBird.m_21564_(0.0f);
            return;
        }
        float yaw = (float)(Mth.m_14136_((double)distance.f_82481_, (double)distance.f_82479_) * 180.0 / 3.1415927410125732) - 90.0f;
        flyingBird.m_146922_(this.m_24991_(flyingBird.m_146908_(), yaw, flyingBird.getMaxYawChange()));
        flyingBird.f_20883_ = flyingBird.m_146908_();
        flyingBird.f_20885_ = flyingBird.m_146908_();
        float speed = (float)(flyingBird.m_21133_(Attributes.f_22280_) * 2.0);
        flyingBird.m_7910_(speed);
        double horizontalDistance = Math.sqrt(distance.f_82479_ * distance.f_82479_ + distance.f_82481_ * distance.f_82481_);
        if (Math.abs(distance.f_82480_) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
            float pitch = -((float)(Mth.m_14136_((double)distance.f_82480_, (double)horizontalDistance) * 180.0 / Math.PI));
            pitch = Mth.m_14036_((float)Mth.m_14177_((float)pitch), (float)(-flyingBird.m_8132_()), (float)flyingBird.m_8132_());
            flyingBird.m_146926_(this.m_24991_(flyingBird.m_146909_(), pitch, flyingBird.getMaxPitchChange()));
        }
        float x = Mth.m_14089_((float)(flyingBird.m_146909_() * ((float)Math.PI / 180)));
        float y = Mth.m_14031_((float)(flyingBird.m_146909_() * ((float)Math.PI / 180)));
        flyingBird.f_20902_ = x * speed;
        flyingBird.f_20901_ = -y * speed;
    }

    private void tickWalking() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            Vec3 distance = new Vec3(this.f_24975_ - this.bird.m_20185_(), this.f_24976_ - this.bird.m_20186_(), this.f_24977_ - this.bird.m_20189_());
            if (distance.m_82556_() < 2.500000277905201E-7) {
                this.bird.m_21564_(0.0f);
                this.f_24981_ = MoveControl.Operation.WAIT;
                return;
            }
            float angle = (float)(Mth.m_14136_((double)distance.f_82481_, (double)distance.f_82479_) * 180.0 / 3.1415927410125732) - 90.0f;
            this.bird.m_146922_(this.m_24991_(this.bird.m_146908_(), angle, 15.0f));
            this.bird.m_7910_((float)(this.f_24978_ * this.bird.m_21133_(Attributes.f_22279_)));
            BlockPos pos = this.bird.m_20183_();
            BlockState state = this.bird.m_9236_().m_8055_(pos);
            VoxelShape collisionShape = state.m_60812_((BlockGetter)this.bird.m_9236_(), pos);
            double horizontalSqDistance = distance.f_82479_ * distance.f_82479_ + distance.f_82481_ * distance.f_82481_;
            if (distance.f_82480_ > (double)this.bird.m_274421_() && horizontalSqDistance < (double)Math.max(1.0f, this.bird.m_20205_()) || !collisionShape.m_83281_() && this.bird.m_20186_() < collisionShape.m_83297_(Direction.Axis.Y) + (double)pos.m_123342_() && !state.m_204336_(BlockTags.f_13103_) && !state.m_204336_(BlockTags.f_13039_)) {
                this.bird.m_21569_().m_24901_();
                this.f_24981_ = MoveControl.Operation.JUMPING;
            }
            if (distance.f_82480_ < (double)this.bird.m_274421_() && horizontalSqDistance < (double)Math.max(1.0f, this.bird.m_20205_()) || !collisionShape.m_83281_() && this.bird.m_20186_() > collisionShape.m_83297_(Direction.Axis.Y) + (double)pos.m_123342_() && !state.m_204336_(BlockTags.f_13103_) && !state.m_204336_(BlockTags.f_13039_)) {
                this.bird.m_20260_(true);
            }
        } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
            this.bird.m_7910_((float)(this.f_24978_ * this.bird.m_21133_(Attributes.f_22279_)));
            if (this.bird.m_20096_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        } else if (this.f_24981_ == MoveControl.Operation.STRAFE) {
            this.f_24981_ = MoveControl.Operation.WAIT;
        } else {
            this.bird.m_21564_(0.0f);
        }
    }
}

