/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.pathing;

import aqario.fowlplay.common.util.Birds;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlightTargeting {
    @Nullable
    public static Vec3 find(PathfinderMob entity, int horizontalRange, int verticalRange) {
        return FlightTargeting.find(entity, horizontalRange, verticalRange, arg_0 -> ((PathfinderMob)entity).m_21692_(arg_0));
    }

    @Nullable
    public static Vec3 find(PathfinderMob entity, int horizontalRange, int verticalRange, ToDoubleFunction<BlockPos> scorer) {
        boolean posTargetInRange = GoalUtils.m_148442_((PathfinderMob)entity, (int)horizontalRange);
        Vec3 direction = entity.m_20252_(1.0f);
        double angle = 15.0;
        return RandomPos.m_148561_(() -> {
            BlockPos blockPos = RandomPos.m_217855_((RandomSource)entity.m_217043_(), (int)horizontalRange, (int)verticalRange, (int)0, (double)direction.f_82479_, (double)direction.f_82481_, (double)0.2617993877991494);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = FlightTargeting.towardTarget(entity, horizontalRange, posTargetInRange, blockPos);
            if (blockPos2 == null) {
                return null;
            }
            return !Birds.isPosWithinViewAngle(entity, blockPos2, 0.2617993877991494) ? null : FlightTargeting.validate(entity, blockPos2);
        }, scorer);
    }

    @Nullable
    public static Vec3 findTo(PathfinderMob entity, int horizontalRange, int verticalRange, Vec3 end) {
        Vec3 vec3d = end.m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        boolean bl = GoalUtils.m_148442_((PathfinderMob)entity, (int)horizontalRange);
        return FlightTargeting.findValid(entity, horizontalRange, verticalRange, vec3d, bl);
    }

    @Nullable
    public static Vec3 findFrom(PathfinderMob entity, int horizontalRange, int verticalRange, Vec3 start) {
        Vec3 vec3d = entity.m_20182_().m_82546_(start);
        boolean bl = GoalUtils.m_148442_((PathfinderMob)entity, (int)horizontalRange);
        return FlightTargeting.findValid(entity, horizontalRange, verticalRange, vec3d, bl);
    }

    @Nullable
    private static Vec3 findValid(PathfinderMob entity, int horizontalRange, int verticalRange, Vec3 direction, boolean posTargetInRange) {
        return RandomPos.m_148542_((PathfinderMob)entity, () -> {
            BlockPos blockPos = RandomPos.m_217855_((RandomSource)entity.m_217043_(), (int)horizontalRange, (int)verticalRange, (int)0, (double)direction.f_82479_, (double)direction.f_82481_, (double)1.5707963705062866);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = FlightTargeting.towardTarget(entity, horizontalRange, posTargetInRange, blockPos);
            return blockPos2 == null ? null : FlightTargeting.validate(entity, blockPos2);
        });
    }

    @Nullable
    public static BlockPos validate(PathfinderMob entity, BlockPos pos) {
        return !GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)(pos = RandomPos.m_148545_((BlockPos)pos, (int)entity.m_9236_().m_151558_(), currentPos -> GoalUtils.m_148461_((PathfinderMob)entity, (BlockPos)currentPos)))) && !GoalUtils.m_148458_((PathfinderMob)entity, (BlockPos)pos) ? pos : null;
    }

    @Nullable
    public static BlockPos towardTarget(PathfinderMob entity, int horizontalRange, boolean posTargetInRange, BlockPos relativeInRangePos) {
        BlockPos blockPos = RandomPos.m_217863_((PathfinderMob)entity, (int)horizontalRange, (RandomSource)entity.m_217043_(), (BlockPos)relativeInRangePos);
        return !GoalUtils.m_148451_((BlockPos)blockPos, (PathfinderMob)entity) && !GoalUtils.m_148454_((boolean)posTargetInRange, (PathfinderMob)entity, (BlockPos)blockPos) && !GoalUtils.m_148448_((PathNavigation)entity.m_21573_(), (BlockPos)blockPos) ? blockPos : null;
    }
}

