/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;

public final class Birds {
    public static final float NORMAL_SPEED = 1.0f;
    public static final float FAST_SPEED = 1.4f;
    public static final float FLY_SPEED = 2.0f;
    public static final float SWIM_SPEED = 4.0f;
    public static final int ITEM_PICK_UP_RANGE = 32;
    public static final SquareRadius FLY_AVOID_RANGE = new SquareRadius(6.0, 6.0);
    public static final int AVOID_TICKS = 160;
    public static final int CANNOT_PICKUP_FOOD_TICKS = 1200;
    public static final UniformInt STAY_NEAR_ENTITY_RANGE = UniformInt.m_146622_((int)16, (int)32);

    public static void tryFlyingAlongPath(FlyingBirdEntity bird, Path path) {
        if (bird.canStartFlying() && (Birds.shouldFlyToDestination(bird, path.m_77406_().m_252807_()) && (!bird.m_6095_().m_204039_(FowlPlayEntityTypeTags.WATERBIRDS) || !bird.m_20072_()) || Birds.shouldFlyFromAvoidTarget(bird))) {
            bird.startFlying();
        }
    }

    public static boolean shouldFlyToDestination(FlyingBirdEntity bird, Vec3 target) {
        Vec3 pos = bird.m_20182_();
        double dx = target.f_82479_ - pos.f_82479_;
        double dy = target.f_82480_ - pos.f_82480_;
        double dz = target.f_82481_ - pos.f_82481_;
        double dxz2 = dx * dx + dz * dz;
        double dy2 = dy * dy;
        double xzRadius = bird.getWalkRange().xzRadius();
        double yRadius = bird.getWalkRange().yRadius();
        return dxz2 > xzRadius * xzRadius || dy2 > yRadius * yRadius;
    }

    public static boolean shouldFlyFromAvoidTarget(FlyingBirdEntity bird) {
        Brain brain = bird.m_6274_();
        if (!BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26383_) || !BrainUtils.hasMemory((Brain)brain, FowlPlayMemoryModuleType.IS_AVOIDING.get())) {
            return false;
        }
        LivingEntity target = (LivingEntity)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26383_);
        if (target.m_20142_() && !target.m_5833_() || target.m_20159_()) {
            return true;
        }
        Vec3 pos = bird.m_20182_();
        Vec3 targetPos = target.m_20182_();
        double dx = targetPos.f_82479_ - pos.f_82479_;
        double dy = targetPos.f_82480_ - pos.f_82480_;
        double dz = targetPos.f_82481_ - pos.f_82481_;
        double dxz2 = dx * dx + dz * dz;
        double dy2 = dy * dy;
        double xzRadius = FLY_AVOID_RANGE.xzRadius();
        double yRadius = FLY_AVOID_RANGE.yRadius();
        return dxz2 <= xzRadius * xzRadius && dy2 <= yRadius * yRadius;
    }

    public static boolean isWithinAngle(Vec3 normalVec, Vec3 targetVec, double angle) {
        float cosMaxAngle;
        float cosVectorAngle = (float)(normalVec = normalVec.m_82541_()).m_82526_(targetVec = targetVec.m_82541_());
        return cosVectorAngle >= (cosMaxAngle = Mth.m_14089_((float)((float)angle)));
    }

    public static boolean isPosWithinViewAngle(PathfinderMob entity, BlockPos pos, double angle) {
        Vec3 lookVec = entity.m_20252_(1.0f);
        Vec3 target = Vec3.m_82512_((Vec3i)pos);
        Vec3 targetVec = target.m_82546_(entity.m_20182_());
        return Birds.isWithinAngle(lookVec, targetVec, angle);
    }

    public static boolean notFlightless(Entity entity) {
        return entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.BIRDS) && !entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.FLIGHTLESS);
    }

    public static <T extends BirdEntity> void alertOthers(T bird, LivingEntity attacker) {
        Birds.getNearbyVisibleAdults(bird).forEach(other -> {
            Brain brain = other.m_6274_();
            if (attacker instanceof Player) {
                BrainUtils.setForgettableMemory((Brain)brain, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD.get(), (Object)true, (int)1200);
            }
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26326_);
            BrainUtils.setForgettableMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26383_, (Object)attacker, (int)160);
        });
    }

    public static <T extends BirdEntity> List<? extends AgeableMob> getNearbyVisibleAdults(T bird) {
        return (List)bird.m_6274_().m_21952_(FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS.get()).orElse(ImmutableList.of());
    }

    public static boolean isPlayerHoldingFood(BirdEntity bird, LivingEntity target) {
        return target.m_6095_() == EntityType.f_20532_ && target.m_21093_((Predicate)bird.getFood());
    }

    public static boolean canPickupFood(BirdEntity bird) {
        Brain brain = bird.m_6274_();
        if (BrainUtils.hasMemory((Brain)brain, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD.get())) {
            return false;
        }
        if (!BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()))) {
            return false;
        }
        List foodItems = (List)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()));
        if (foodItems.isEmpty() || bird.getFood().test(bird.m_21205_())) {
            return false;
        }
        NearestVisibleLivingEntities visibleMobs = (NearestVisibleLivingEntities)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_148205_);
        if (visibleMobs == null) {
            return false;
        }
        List<LivingEntity> avoidTargets = visibleMobs.m_186128_(entity -> true).filter(entity -> Birds.shouldAvoid(bird, entity)).filter(entity -> entity.m_19950_((Entity)foodItems.get(0), (double)bird.getFleeRange((LivingEntity)entity))).toList();
        return avoidTargets.isEmpty();
    }

    public static boolean shouldAvoid(BirdEntity bird, LivingEntity target) {
        Optional attackTarget;
        Brain brain = bird.m_6274_();
        if (!(bird.shouldAvoid(target) && EntitySelector.f_20406_.test(target) || Birds.shouldAvoidAttacker(brain, target))) {
            return false;
        }
        if (target instanceof Player) {
            TrustingBirdEntity trusting;
            Player player = (Player)target;
            if (bird instanceof TrustingBirdEntity && (trusting = (TrustingBirdEntity)bird).trusts(player)) {
                return false;
            }
        }
        if ((attackTarget = brain.m_257414_(MemoryModuleType.f_26372_)) != null && attackTarget.isPresent() && ((LivingEntity)attackTarget.get()).equals((Object)target)) {
            return false;
        }
        return !bird.shouldAttack(target);
    }

    public static boolean shouldAvoidAttacker(Brain<?> brain, LivingEntity attacker) {
        LivingEntity hurtBy = (LivingEntity)BrainUtils.getMemory(brain, (MemoryModuleType)MemoryModuleType.f_26382_);
        return hurtBy != null && hurtBy.equals((Object)attacker);
    }

    public static boolean canAttack(BirdEntity bird) {
        return !bird.m_20072_() && !BehaviorUtils.m_217126_((LivingEntity)bird);
    }

    public static boolean canAquaticAttack(BirdEntity bird) {
        return !BehaviorUtils.m_217126_((LivingEntity)bird);
    }

    public static boolean isPerched(BirdEntity entity) {
        return entity.m_9236_().m_8055_(entity.m_20099_()).m_204336_(FowlPlayBlockTags.PERCHES);
    }
}

