/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api.internal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.api.EzActionsApi;
import org.z2six.ezactions.api.ImportExport;
import org.z2six.ezactions.api.MenuRead;
import org.z2six.ezactions.api.MenuWrite;
import org.z2six.ezactions.api.internal.ImportExportImpl;
import org.z2six.ezactions.api.internal.MenuReadImpl;
import org.z2six.ezactions.api.internal.MenuWriteImpl;
import org.z2six.ezactions.api.internal.TreeOps;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.json.MenuImportExport;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;
import org.z2six.ezactions.gui.editor.menu.MenuNavUtil;

public final class EzActionsApiImpl
implements EzActionsApi {
    private final MenuRead read = new MenuReadImpl();
    private final MenuWrite write = new MenuWriteImpl();
    private final ImportExport io = new ImportExportImpl();

    @Override
    public void openEditor(Screen parent) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            mc.setScreen((Screen)new MenuEditorScreen(parent));
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] openEditor failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addAction(String parentIdOrNull, String title, String noteOrNull, IClickAction action) {
        if (action == null) {
            return null;
        }
        List<String> path = MenuNavUtil.capturePathTitles();
        try {
            List<MenuItem> dst;
            List<MenuItem> list = dst = parentIdOrNull == null ? RadialMenu.rootMutable() : TreeOps.findChildrenListById(RadialMenu.rootMutable(), parentIdOrNull);
            if (dst == null) {
                String string = null;
                return string;
            }
            String id = EzActionsApiImpl.freshId("act");
            MenuItem item = new MenuItem(id, EzActionsApiImpl.safe(title), EzActionsApiImpl.safe(noteOrNull), null, action, null);
            dst.add(item);
            RadialMenu.persist();
            String string = id;
            return string;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] addAction failed: {}", (Object)"EZActions", (Object)t.toString());
            String string = null;
            return string;
        }
        finally {
            MenuNavUtil.restorePathTitles(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addBundle(String parentIdOrNull, String title, String noteOrNull) {
        List<String> path = MenuNavUtil.capturePathTitles();
        try {
            List<MenuItem> dst;
            List<MenuItem> list = dst = parentIdOrNull == null ? RadialMenu.rootMutable() : TreeOps.findChildrenListById(RadialMenu.rootMutable(), parentIdOrNull);
            if (dst == null) {
                String string = null;
                return string;
            }
            String id = EzActionsApiImpl.freshId("bundle");
            MenuItem cat = new MenuItem(id, EzActionsApiImpl.safe(title), EzActionsApiImpl.safe(noteOrNull), null, null, new ArrayList<MenuItem>());
            dst.add(cat);
            RadialMenu.persist();
            String string = id;
            return string;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] addBundle failed: {}", (Object)"EZActions", (Object)t.toString());
            String string = null;
            return string;
        }
        finally {
            MenuNavUtil.restorePathTitles(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeItem(String id) {
        if (id == null || id.isBlank()) {
            return false;
        }
        List<String> path = MenuNavUtil.capturePathTitles();
        try {
            List<MenuItem> root = RadialMenu.rootMutable();
            if (root == null) {
                boolean bl = false;
                return bl;
            }
            boolean ok = TreeOps.removeByIdRecursive(root, id);
            if (ok) {
                RadialMenu.persist();
            }
            boolean bl = ok;
            return bl;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] removeItem failed: {}", (Object)"EZActions", (Object)t.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            MenuNavUtil.restorePathTitles(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveWithin(String parentIdOrNull, int fromIndex, int toIndex) {
        List<String> path = MenuNavUtil.capturePathTitles();
        try {
            MenuItem moved;
            List<MenuItem> list;
            List<MenuItem> list2 = list = parentIdOrNull == null ? RadialMenu.rootMutable() : TreeOps.findChildrenListById(RadialMenu.rootMutable(), parentIdOrNull);
            if (list == null) {
                boolean bl = false;
                return bl;
            }
            int n = list.size();
            if (n == 0) {
                boolean bl = false;
                return bl;
            }
            if (fromIndex < 0 || fromIndex >= n) {
                boolean bl = false;
                return bl;
            }
            if (toIndex < 0) {
                toIndex = 0;
            }
            if (toIndex > n) {
                toIndex = n;
            }
            if ((moved = list.remove(fromIndex)) == null) {
                boolean bl = false;
                return bl;
            }
            if (toIndex > fromIndex) {
                --toIndex;
            }
            list.add(toIndex, moved);
            RadialMenu.persist();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] moveWithin failed: {}", (Object)"EZActions", (Object)t.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            MenuNavUtil.restorePathTitles(path);
        }
    }

    @Override
    public void persist() {
        try {
            RadialMenu.persist();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int importFromClipboard() {
        try {
            return MenuImportExport.importFromClipboard();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] importFromClipboard failed: {}", (Object)"EZActions", (Object)t.toString());
            return -1;
        }
    }

    @Override
    public boolean exportToClipboard() {
        try {
            MenuImportExport.exportToClipboard();
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] exportToClipboard failed: {}", (Object)"EZActions", (Object)t.toString());
            return false;
        }
    }

    @Override
    public MenuRead menuRead() {
        return this.read;
    }

    @Override
    public MenuWrite menuWrite() {
        return this.write;
    }

    @Override
    public ImportExport importExport() {
        return this.io;
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String freshId(String prefix) {
        long t = System.currentTimeMillis();
        return prefix + "_" + Long.toHexString(t) + "_" + Integer.toHexString((int)(Math.random() * 65535.0));
    }
}

