/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.api.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.z2six.ezactions.api.ApiMenuItem;
import org.z2six.ezactions.api.MenuPath;
import org.z2six.ezactions.api.MenuRead;
import org.z2six.ezactions.api.internal.TreeOps;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;

final class MenuReadImpl
implements MenuRead {
    MenuReadImpl() {
    }

    @Override
    public List<ApiMenuItem> list(MenuPath path) {
        List<MenuItem> root = RadialMenu.rootMutable();
        List<MenuItem> at = path == null || path.titles().isEmpty() ? root : TreeOps.findBundleByTitles(root, path.titles());
        ArrayList<ApiMenuItem> out = new ArrayList<ApiMenuItem>();
        if (at == null) {
            return out;
        }
        for (MenuItem mi : at) {
            out.add(MenuReadImpl.snap(mi));
        }
        return out;
    }

    @Override
    public Optional<ApiMenuItem> findById(String id) {
        MenuItem mi = TreeOps.findFirstById(RadialMenu.rootMutable(), id);
        return mi == null ? Optional.empty() : Optional.of(MenuReadImpl.snap(mi));
    }

    @Override
    public List<String> currentPath() {
        return TreeOps.currentPathTitles();
    }

    @Override
    public boolean existsPath(MenuPath path) {
        return TreeOps.existsPath(RadialMenu.rootMutable(), path == null ? List.of() : path.titles());
    }

    private static ApiMenuItem snap(MenuItem mi) {
        String type = mi.isCategory() ? "BUNDLE" : "ACTION";
        return new ApiMenuItem(MenuReadImpl.safe(mi.id()), MenuReadImpl.safe(mi.title()), mi.isCategory(), type, MenuReadImpl.nullToNull(mi.note()), null);
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String nullToNull(String s) {
        return s;
    }
}

