/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.config;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.z2six.ezactions.Constants;

public final class DesignClientConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.IntValue deadzone;
    public static final ModConfigSpec.IntValue baseOuterRadius;
    public static final ModConfigSpec.IntValue ringThickness;
    public static final ModConfigSpec.IntValue scaleStartThreshold;
    public static final ModConfigSpec.IntValue scalePerItem;
    public static final ModConfigSpec.IntValue ringColor;
    public static final ModConfigSpec.IntValue hoverColor;

    private DesignClientConfig() {
    }

    public static void onConfigLoad(ModConfigEvent.Loading e) {
        block31: {
            if (e.getConfig().getSpec() != SPEC) {
                return;
            }
            try {
                Path dir = FMLPaths.CONFIGDIR.get().resolve("ezactions");
                Path toml = dir.resolve("design-client.toml");
                Path legacyJson = dir.resolve("radial.json");
                boolean migrated = false;
                if (Files.exists(toml, new LinkOption[0])) {
                    try (CommentedFileConfig cfg = CommentedFileConfig.of((Path)toml, (ConfigFormat)TomlFormat.instance());){
                        boolean hasAny;
                        cfg.load();
                        boolean bl = hasAny = cfg.contains("deadzone") || cfg.contains("baseOuterRadius") || cfg.contains("ringThickness") || cfg.contains("scaleStartThreshold") || cfg.contains("scalePerItem") || cfg.contains("ringColor") || cfg.contains("hoverColor");
                        if (hasAny) {
                            DesignClientConfig.setIntSafely(deadzone, cfg.getOrElse("deadzone", (Object)((Integer)deadzone.get())));
                            DesignClientConfig.setIntSafely(baseOuterRadius, cfg.getOrElse("baseOuterRadius", (Object)((Integer)baseOuterRadius.get())));
                            DesignClientConfig.setIntSafely(ringThickness, cfg.getOrElse("ringThickness", (Object)((Integer)ringThickness.get())));
                            DesignClientConfig.setIntSafely(scaleStartThreshold, cfg.getOrElse("scaleStartThreshold", (Object)((Integer)scaleStartThreshold.get())));
                            DesignClientConfig.setIntSafely(scalePerItem, cfg.getOrElse("scalePerItem", (Object)((Integer)scalePerItem.get())));
                            ringColor.set((Object)DesignClientConfig.parseColorAny(cfg.get("ringColor"), (Integer)ringColor.get()));
                            hoverColor.set((Object)DesignClientConfig.parseColorAny(cfg.get("hoverColor"), (Integer)hoverColor.get()));
                            migrated = true;
                            Constants.LOG.info("[{}] Imported existing design-client.toml into ModConfigSpec (Configured-visible).", (Object)"EZActions");
                        }
                    }
                    catch (Throwable t) {
                        Constants.LOG.debug("[{}] Could not read existing design-client.toml for migration: {}", (Object)"EZActions", (Object)t.toString());
                    }
                }
                if (migrated || !Files.exists(legacyJson, new LinkOption[0])) break block31;
                try (BufferedReader r = Files.newBufferedReader(legacyJson, StandardCharsets.UTF_8);){
                    JsonObject obj = JsonParser.parseReader((Reader)r).getAsJsonObject();
                    if (obj.has("deadzone")) {
                        deadzone.set((Object)obj.get("deadzone").getAsInt());
                    }
                    if (obj.has("baseOuterRadius")) {
                        baseOuterRadius.set((Object)obj.get("baseOuterRadius").getAsInt());
                    }
                    if (obj.has("ringThickness")) {
                        ringThickness.set((Object)obj.get("ringThickness").getAsInt());
                    }
                    if (obj.has("scaleStartThreshold")) {
                        scaleStartThreshold.set((Object)obj.get("scaleStartThreshold").getAsInt());
                    }
                    if (obj.has("scalePerItem")) {
                        scalePerItem.set((Object)obj.get("scalePerItem").getAsInt());
                    }
                    if (obj.has("ringColor")) {
                        ringColor.set((Object)DesignClientConfig.parseColor(obj.get("ringColor").getAsString(), (Integer)ringColor.get()));
                    }
                    if (obj.has("hoverColor")) {
                        hoverColor.set((Object)DesignClientConfig.parseColor(obj.get("hoverColor").getAsString(), (Integer)hoverColor.get()));
                    }
                    try {
                        Files.move(legacyJson, legacyJson.resolveSibling("radial.json.bak"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable ex) {
                        Constants.LOG.debug("[{}] Could not rename legacy radial.json: {}", (Object)"EZActions", (Object)ex.toString());
                    }
                    Constants.LOG.info("[{}] Migrated legacy radial.json \u2192 design-client.toml (ModConfigSpec).", (Object)"EZActions");
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Could not migrate legacy radial.json: {}", (Object)"EZActions", (Object)t.toString());
                }
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] DesignClientConfig load hook failed: {}", (Object)"EZActions", (Object)t.toString());
            }
        }
    }

    private static void setIntSafely(ModConfigSpec.IntValue v, Object raw) {
        try {
            if (raw instanceof Number) {
                Number n = (Number)raw;
                v.set((Object)n.intValue());
            } else if (raw instanceof String) {
                String s = (String)raw;
                v.set((Object)Integer.parseInt(s.trim()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int parseColorAny(Object raw, int dflt) {
        try {
            if (raw == null) {
                return dflt;
            }
            if (raw instanceof Number) {
                Number n = (Number)raw;
                return n.intValue();
            }
            if (raw instanceof String) {
                String s = (String)raw;
                return DesignClientConfig.parseColor(s, dflt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dflt;
    }

    private static int parseColor(String s, int fallback) {
        try {
            Object t;
            Object object = t = s == null ? "" : s.trim();
            if (((String)t).isEmpty()) {
                return fallback;
            }
            if (((String)t).startsWith("0x") || ((String)t).startsWith("0X")) {
                t = ((String)t).substring(2);
            } else if (((String)t).startsWith("#")) {
                t = ((String)t).substring(1);
            }
            if (((String)t).matches("(?i)^[0-9a-f]{6}$")) {
                t = "FF" + (String)t;
            }
            long val = Long.parseUnsignedLong((String)t, 16);
            return (int)val;
        }
        catch (Throwable e) {
            Constants.LOG.warn("[{}] Bad color literal '{}'; using fallback 0x{}", new Object[]{"EZActions", s, Integer.toHexString(fallback)});
            return fallback;
        }
    }

    static {
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        deadzone = b.comment("Deadzone radius in pixels where no slice is selected.").defineInRange("deadzone", 18, 0, 90);
        baseOuterRadius = b.comment("Outer radius of the ring in pixels (UI scale 1.0).").defineInRange("baseOuterRadius", 72, 24, 512);
        ringThickness = b.comment("Ring thickness in pixels.").defineInRange("ringThickness", 28, 6, 256);
        scaleStartThreshold = b.comment("Minimum item count before scaling down begins.").defineInRange("scaleStartThreshold", 8, 0, 128);
        scalePerItem = b.comment("Outer-radius increment per extra item above threshold (pixels).").defineInRange("scalePerItem", 6, 0, 100);
        ringColor = b.comment("ARGB color as int (0xAARRGGBB). Signed 32-bit; negatives are normal for opaque colors.").defineInRange("ringColor", -1442840576, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hoverColor = b.comment("Hover ARGB color as int (0xAARRGGBB).").defineInRange("hoverColor", -917436, Integer.MIN_VALUE, Integer.MAX_VALUE);
        SPEC = b.build();
    }
}

