/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.z2six.ezactions.Constants;

public final class GeneralClientConfig {
    public static final ModConfigSpec SPEC;
    public static final GeneralClientConfig CONFIG;
    public final ModConfigSpec.BooleanValue moveWhileRadialOpen;
    public final ModConfigSpec.IntValue commandEditorVisibleLines;

    private GeneralClientConfig(ModConfigSpec.Builder b) {
        b.push("general");
        this.moveWhileRadialOpen = b.comment("Allow moving the player while the radial menu is open (hold hotkey).").translation("ezactions.config.moveWhileRadialOpen").define("moveWhileRadialOpen", true);
        this.commandEditorVisibleLines = b.comment(new String[]{"How many lines are visible in the multi-line Command editor box.", "This only affects the widget height (scrollbar will appear for longer content).", "Range: 1..20, Default: 5"}).translation("ezactions.config.commandEditorVisibleLines").defineInRange("commandEditorVisibleLines", 5, 1, 20);
        b.pop();
    }

    public boolean moveWhileRadialOpen() {
        try {
            return (Boolean)this.moveWhileRadialOpen.get();
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] GeneralClientConfig read failed (moveWhileRadialOpen): {}", (Object)"EZActions", (Object)t.toString());
            return true;
        }
    }

    public int commandEditorVisibleLines() {
        try {
            int v = (Integer)this.commandEditorVisibleLines.get();
            if (v < 1) {
                v = 1;
            }
            if (v > 20) {
                v = 20;
            }
            return v;
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] GeneralClientConfig read failed (commandEditorVisibleLines): {}", (Object)"EZActions", (Object)t.toString());
            return 5;
        }
    }

    private GeneralClientConfig() {
        throw new AssertionError((Object)"unreachable");
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(GeneralClientConfig::new);
        CONFIG = (GeneralClientConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

