/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.z2six.ezactions.Constants;

public final class RadialAnimConfig {
    public static final ModConfigSpec SPEC;
    public static final RadialAnimConfig CONFIG;
    public final ModConfigSpec.BooleanValue animationsEnabled;
    public final ModConfigSpec.BooleanValue animOpenClose;
    public final ModConfigSpec.BooleanValue animHover;
    public final ModConfigSpec.DoubleValue hoverGrowPct;
    public final ModConfigSpec.IntValue openCloseMs;

    private RadialAnimConfig(ModConfigSpec.Builder b) {
        b.push("animations");
        this.animationsEnabled = b.comment("Master switch for all animations.").translation("ezactions.config.animationsEnabled").define("animationsEnabled", true);
        this.animOpenClose = b.comment("Animate the menu opening/closing with a radial wipe.").translation("ezactions.config.animOpenClose").define("animOpenClose", true);
        this.animHover = b.comment("Animate hover (slice grow + fill).").translation("ezactions.config.animHover").define("animHover", true);
        this.hoverGrowPct = b.comment("How much the hovered slice grows at full hover (0.00..0.50).").translation("ezactions.config.hoverGrowPct").defineInRange("hoverGrowPct", 0.05, 0.0, 0.5);
        this.openCloseMs = b.comment("Menu open/close animation duration in milliseconds (0..2000).").translation("ezactions.config.openCloseMs").defineInRange("openCloseMs", 125, 0, 2000);
        b.pop();
    }

    public boolean animationsEnabled() {
        try {
            return (Boolean)this.animationsEnabled.get();
        }
        catch (Throwable t) {
            RadialAnimConfig.log(t);
            return true;
        }
    }

    public boolean animOpenClose() {
        try {
            return (Boolean)this.animOpenClose.get();
        }
        catch (Throwable t) {
            RadialAnimConfig.log(t);
            return true;
        }
    }

    public boolean animHover() {
        try {
            return (Boolean)this.animHover.get();
        }
        catch (Throwable t) {
            RadialAnimConfig.log(t);
            return true;
        }
    }

    public double hoverGrowPct() {
        try {
            double v = (Double)this.hoverGrowPct.get();
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                return 0.05;
            }
            return Math.max(0.0, Math.min(0.5, v));
        }
        catch (Throwable t) {
            RadialAnimConfig.log(t);
            return 0.05;
        }
    }

    public int openCloseMs() {
        try {
            int v = (Integer)this.openCloseMs.get();
            if (v < 0) {
                return 0;
            }
            if (v > 2000) {
                return 2000;
            }
            return v;
        }
        catch (Throwable t) {
            RadialAnimConfig.log(t);
            return 125;
        }
    }

    private static void log(Throwable t) {
        Constants.LOG.debug("[{}] RadialAnimConfig read failed: {}", (Object)"EZActions", (Object)t.toString());
    }

    private RadialAnimConfig() {
        throw new AssertionError((Object)"unreachable");
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(RadialAnimConfig::new);
        CONFIG = (RadialAnimConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

