/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.icon;

import com.google.gson.JsonObject;
import org.z2six.ezactions.Constants;

public final class IconSpec {
    private final Kind kind;
    private final String id;

    public IconSpec(Kind kind, String id) {
        this.kind = kind == null ? Kind.ITEM : kind;
        this.id = id == null ? "minecraft:stone" : id;
    }

    public static IconSpec item(String itemId) {
        return new IconSpec(Kind.ITEM, itemId);
    }

    public Kind kind() {
        return this.kind;
    }

    public String id() {
        return this.id;
    }

    public JsonObject serialize() {
        JsonObject o = new JsonObject();
        try {
            o.addProperty("kind", this.kind.name());
            o.addProperty("id", this.id);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] IconSpec serialize failed: {}", (Object)"EZActions", (Object)t.toString());
        }
        return o;
    }

    public static IconSpec deserialize(JsonObject o) {
        try {
            String k = o.has("kind") ? o.get("kind").getAsString() : "ITEM";
            String id = o.has("id") ? o.get("id").getAsString() : "minecraft:stone";
            Kind kind = Kind.ITEM;
            try {
                kind = Kind.valueOf(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return new IconSpec(kind, id);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] IconSpec deserialize failed: {}", (Object)"EZActions", (Object)t.toString());
            return new IconSpec(Kind.ITEM, "minecraft:stone");
        }
    }

    public String toString() {
        return String.valueOf((Object)this.kind) + ":" + this.id;
    }

    public static enum Kind {
        ITEM;

    }
}

