/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionCommand;
import org.z2six.ezactions.data.click.ClickActionKey;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.helper.InputInjector;

public final class MenuLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "menu.json";

    private MenuLoader() {
    }

    public static Path getMenuPath() {
        Path cfg = FMLPaths.CONFIGDIR.get();
        Path dir = cfg.resolve("ezactions");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Constants.LOG.warn("[{}] Failed to ensure config dir {}: {}", new Object[]{"EZActions", dir, e.toString()});
        }
        return dir.resolve(FILE_NAME);
    }

    public static List<MenuItem> loadMenu() {
        ArrayList<MenuItem> arrayList;
        block11: {
            Path path = MenuLoader.getMenuPath();
            if (!Files.exists(path, new LinkOption[0])) {
                Constants.LOG.info("[{}] Menu file missing; writing defaults to {}", (Object)"EZActions", (Object)path);
                List<MenuItem> defaults = MenuLoader.defaultMenu();
                MenuLoader.saveMenu(defaults);
                return defaults;
            }
            BufferedReader r = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                JsonElement rootEl = JsonParser.parseReader((Reader)r);
                if (!rootEl.isJsonArray()) {
                    throw new JsonParseException("Root must be an array");
                }
                JsonArray arr = rootEl.getAsJsonArray();
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                for (JsonElement el : arr) {
                    if (!el.isJsonObject()) continue;
                    items.add(MenuItem.deserialize(el.getAsJsonObject()));
                }
                Constants.LOG.debug("[{}] Loaded {} menu items.", (Object)"EZActions", (Object)items.size());
                arrayList = items;
                if (r == null) break block11;
            }
            catch (Throwable rootEl) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            rootEl.addSuppressed(throwable);
                        }
                    }
                    throw rootEl;
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Failed to load menu.json: {} (writing defaults)", (Object)"EZActions", (Object)t.toString());
                    List<MenuItem> defaults = MenuLoader.defaultMenu();
                    MenuLoader.saveMenu(defaults);
                    return defaults;
                }
            }
            r.close();
        }
        return arrayList;
    }

    public static void saveMenu(List<MenuItem> items) {
        Path path = MenuLoader.getMenuPath();
        JsonArray arr = new JsonArray();
        for (MenuItem mi : items) {
            arr.add((JsonElement)mi.serialize());
        }
        try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            GSON.toJson((JsonElement)arr, (Appendable)w);
            Constants.LOG.debug("[{}] Saved menu to {}", (Object)"EZActions", (Object)path);
        }
        catch (IOException e) {
            Constants.LOG.warn("[{}] Failed to save menu.json: {}", (Object)"EZActions", (Object)e.toString());
        }
    }

    private static List<MenuItem> defaultMenu() {
        ArrayList<MenuItem> out = new ArrayList<MenuItem>();
        out.add(new MenuItem("inventory", "Inventory", IconSpec.item("minecraft:chest"), new ClickActionKey("key.inventory", false, InputInjector.DeliveryMode.AUTO), List.of()));
        out.add(new MenuItem("advancements", "Advancements", IconSpec.item("minecraft:book"), new ClickActionKey("key.advancements", false, InputInjector.DeliveryMode.AUTO), List.of()));
        out.add(new MenuItem("chat", "Open Chat", IconSpec.item("minecraft:paper"), new ClickActionKey("key.chat", false, InputInjector.DeliveryMode.AUTO), List.of()));
        out.add(new MenuItem("saytime", "Say /time query", IconSpec.item("minecraft:clock"), new ClickActionCommand("/time query daytime"), List.of()));
        return out;
    }
}

