/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.menu;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.json.ClickActionSerializer;

public final class MenuItem {
    private final String id;
    private final Component titleC;
    private final Component noteC;
    private final String titleStr;
    private final String noteStr;
    private final IconSpec icon;
    private final IClickAction action;
    private final List<MenuItem> children;
    private final boolean hideFromMainRadial;
    private final boolean bundleKeybindEnabled;

    public MenuItem(String id, String title, String note, IconSpec icon, IClickAction action, List<MenuItem> children) {
        this(id, MenuItem.safeLiteral(title), MenuItem.safeLiteral(note), icon, action, children, false, false);
    }

    public MenuItem(String id, Component title, Component note, IconSpec icon, IClickAction action, List<MenuItem> children) {
        this(id, title, note, icon, action, children, false, false);
    }

    public MenuItem(String id, Component title, Component note, IconSpec icon, IClickAction action, List<MenuItem> children, boolean hideFromMainRadial, boolean bundleKeybindEnabled) {
        this.id = (String)((Object)Objects.requireNonNullElse(id, "item_" + Long.toUnsignedString(System.nanoTime(), 36)));
        this.titleC = title == null ? Component.literal((String)"Unnamed") : title;
        this.noteC = note == null ? Component.literal((String)"") : note;
        this.titleStr = this.titleC.getString();
        this.noteStr = this.noteC.getString();
        this.icon = icon == null ? IconSpec.item("minecraft:stone") : icon;
        this.action = action;
        this.children = children == null ? new ArrayList<MenuItem>() : new ArrayList<MenuItem>(children);
        this.hideFromMainRadial = hideFromMainRadial;
        this.bundleKeybindEnabled = bundleKeybindEnabled;
    }

    public MenuItem(String id, String title, IconSpec icon, IClickAction action, List<MenuItem> children) {
        this(id, title, "", icon, action, children);
    }

    public MenuItem(String id, String title, String note, IconSpec icon, IClickAction action, List<MenuItem> children, boolean hideFromMainRadial, boolean bundleKeybindEnabled) {
        this(id, MenuItem.safeLiteral(title), MenuItem.safeLiteral(note), icon, action, children, hideFromMainRadial, bundleKeybindEnabled);
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.titleStr;
    }

    public String note() {
        return this.noteStr;
    }

    public Component titleComponent() {
        return this.titleC;
    }

    public Component noteComponent() {
        return this.noteC;
    }

    public IconSpec icon() {
        return this.icon;
    }

    public IClickAction action() {
        return this.action;
    }

    public IClickAction clickAction() {
        return this.action;
    }

    public List<MenuItem> children() {
        return Collections.unmodifiableList(this.children);
    }

    public List<MenuItem> childrenMutable() {
        return this.children;
    }

    public boolean isCategory() {
        return this.action == null;
    }

    public boolean hideFromMainRadial() {
        return this.hideFromMainRadial;
    }

    public boolean bundleKeybindEnabled() {
        return this.bundleKeybindEnabled;
    }

    public MenuItem withIcon(IconSpec newIcon) {
        try {
            IconSpec use = newIcon == null ? IconSpec.item("minecraft:stone") : newIcon;
            return new MenuItem(this.id, this.titleC, this.noteC, use, this.action, this.children, this.hideFromMainRadial, this.bundleKeybindEnabled);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] MenuItem.withIcon failed: {}", (Object)"EZActions", (Object)t.toString());
            return this;
        }
    }

    public MenuItem withTitle(String newTitle) {
        Component use = newTitle == null || newTitle.isBlank() ? this.titleC : Component.literal((String)newTitle);
        return new MenuItem(this.id, use, this.noteC, this.icon, this.action, this.children, this.hideFromMainRadial, this.bundleKeybindEnabled);
    }

    public MenuItem withTitle(Component newTitle) {
        Component use = newTitle == null ? this.titleC : newTitle;
        return new MenuItem(this.id, use, this.noteC, this.icon, this.action, this.children, this.hideFromMainRadial, this.bundleKeybindEnabled);
    }

    public MenuItem withNote(String newNote) {
        MutableComponent use = newNote == null ? Component.literal((String)"") : Component.literal((String)newNote);
        return new MenuItem(this.id, this.titleC, (Component)use, this.icon, this.action, this.children, this.hideFromMainRadial, this.bundleKeybindEnabled);
    }

    public MenuItem withNote(Component newNote) {
        Component use = newNote == null ? Component.literal((String)"") : newNote;
        return new MenuItem(this.id, this.titleC, use, this.icon, this.action, this.children, this.hideFromMainRadial, this.bundleKeybindEnabled);
    }

    public MenuItem withAction(IClickAction newAction) {
        return new MenuItem(this.id, this.titleC, this.noteC, this.icon, newAction, Collections.emptyList(), this.hideFromMainRadial, this.bundleKeybindEnabled);
    }

    public MenuItem withChildren(List<MenuItem> newChildren) {
        return new MenuItem(this.id, this.titleC, this.noteC, this.icon, null, newChildren, this.hideFromMainRadial, this.bundleKeybindEnabled);
    }

    public MenuItem withHideFromMainRadial(boolean hide) {
        return new MenuItem(this.id, this.titleC, this.noteC, this.icon, this.action, this.children, hide, this.bundleKeybindEnabled);
    }

    public MenuItem withBundleKeybindEnabled(boolean enabled) {
        return new MenuItem(this.id, this.titleC, this.noteC, this.icon, this.action, this.children, this.hideFromMainRadial, enabled);
    }

    public JsonObject serialize() {
        JsonObject o = new JsonObject();
        try {
            o.addProperty("id", this.id);
            o.add("title", MenuItem.serializeComponent(this.titleC));
            String iconId = "minecraft:stone";
            try {
                iconId = this.icon.id();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            o.addProperty("icon", iconId);
            if (this.noteC != null && !this.noteStr.isEmpty()) {
                o.add("note", MenuItem.serializeComponent(this.noteC));
            }
            if (this.hideFromMainRadial) {
                o.addProperty("hideFromMainRadial", Boolean.valueOf(true));
            }
            if (this.bundleKeybindEnabled) {
                o.addProperty("bundleKeybindEnabled", Boolean.valueOf(true));
            }
            if (this.action != null) {
                o.add("action", (JsonElement)ClickActionSerializer.serialize(this.action));
            } else {
                JsonArray arr = new JsonArray();
                for (MenuItem child : this.children) {
                    arr.add((JsonElement)child.serialize());
                }
                o.add("children", (JsonElement)arr);
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] MenuItem.serialize failed: {}", (Object)"EZActions", (Object)t.toString());
        }
        return o;
    }

    public static MenuItem deserialize(JsonObject o) {
        try {
            String id = MenuItem.getString(o, "id", "item_" + Long.toUnsignedString(System.nanoTime(), 36));
            Component titleC = MenuItem.readComponent(o.get("title"), (Component)Component.literal((String)"Unnamed"));
            String iconId = MenuItem.getString(o, "icon", "minecraft:stone");
            MutableComponent noteC = Component.literal((String)"");
            if (o.has("note")) {
                noteC = MenuItem.readComponent(o.get("note"), (Component)Component.literal((String)""));
            }
            boolean hideFromMainRadial = MenuItem.getBoolean(o, "hideFromMainRadial", false);
            boolean bundleKeybindEnabled = MenuItem.getBoolean(o, "bundleKeybindEnabled", false);
            IClickAction action = null;
            List<MenuItem> children = Collections.emptyList();
            if (o.has("action") && o.get("action").isJsonObject()) {
                action = ClickActionSerializer.deserialize(o.getAsJsonObject("action"));
            } else if (o.has("children") && o.get("children").isJsonArray()) {
                ArrayList<MenuItem> list = new ArrayList<MenuItem>();
                for (JsonElement el : o.getAsJsonArray("children")) {
                    if (!el.isJsonObject()) continue;
                    list.add(MenuItem.deserialize(el.getAsJsonObject()));
                }
                children = list;
            }
            return new MenuItem(id, titleC, (Component)noteC, IconSpec.item(iconId), action, children, hideFromMainRadial, bundleKeybindEnabled);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] MenuItem.deserialize failed: {}", (Object)"EZActions", (Object)t.toString());
            return new MenuItem("invalid", (Component)Component.literal((String)"Invalid"), (Component)Component.literal((String)""), IconSpec.item("minecraft:barrier"), null, Collections.emptyList(), false, false);
        }
    }

    private static String getString(JsonObject o, String key, String def) {
        try {
            if (o.has(key) && o.get(key).isJsonPrimitive()) {
                return o.get(key).getAsString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return def;
    }

    private static boolean getBoolean(JsonObject o, String key, boolean def) {
        try {
            if (o.has(key) && o.get(key).isJsonPrimitive()) {
                return o.get(key).getAsJsonPrimitive().getAsBoolean();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return def;
    }

    private static Component safeLiteral(String s) {
        if (s == null) {
            return Component.literal((String)"");
        }
        return Component.literal((String)s);
    }

    private static Component readComponent(JsonElement el, Component fallback) {
        try {
            JsonPrimitive p;
            if (el == null || el instanceof JsonNull) {
                return fallback;
            }
            if (el.isJsonPrimitive() && (p = el.getAsJsonPrimitive()).isString()) {
                return Component.literal((String)p.getAsString());
            }
            return ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)el).result().orElse(fallback);
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] readComponent fallback due to: {}", (Object)"EZActions", (Object)t.toString());
            return fallback;
        }
    }

    private static JsonElement serializeComponent(Component c) {
        try {
            return ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)c).result().orElseGet(JsonObject::new);
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] serializeComponent fallback due to: {}", (Object)"EZActions", (Object)t.toString());
            return new JsonPrimitive(c == null ? "" : c.getString());
        }
    }

    public static MenuItem action(String id, String title, String note, IconSpec icon, IClickAction act) {
        return new MenuItem(id, MenuItem.safeLiteral(title), MenuItem.safeLiteral(note), icon, act, Collections.emptyList(), false, false);
    }

    public static MenuItem category(String id, String title, IconSpec icon, List<MenuItem> children) {
        return new MenuItem(id, MenuItem.safeLiteral(title), (Component)Component.literal((String)""), icon, null, children, false, false);
    }

    public String toString() {
        int childCount = this.children == null ? 0 : this.children.size();
        return "MenuItem{id='" + this.id + "', title='" + this.titleStr + "', noteLen=" + (this.noteStr == null ? 0 : this.noteStr.length()) + ", icon=" + (this.icon == null ? "null" : this.icon.id()) + ", action=" + String.valueOf(this.action == null ? "<category>" : this.action.getType()) + ", children=" + childCount + ", hideFromMainRadial=" + this.hideFromMainRadial + ", bundleKeybindEnabled=" + this.bundleKeybindEnabled + "}";
    }
}

