/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.data.menu;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.json.MenuLoader;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.gui.RadialMenuScreen;

public final class RadialMenu {
    private static List<MenuItem> ROOT = new ArrayList<MenuItem>();
    private static final Deque<MenuItem> PATH = new ArrayDeque<MenuItem>();

    private RadialMenu() {
    }

    public static void open() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null || mc.level == null) {
                Constants.LOG.debug("[{}] Radial open ignored: client/world not ready (mc={}, player={}, level={}).", new Object[]{"EZActions", mc != null, mc != null && mc.player != null, mc != null && mc.level != null});
                return;
            }
            if (mc.screen != null || mc.isPaused()) {
                String scr = mc.screen == null ? "none" : mc.screen.getClass().getSimpleName();
                Constants.LOG.debug("[{}] Radial open ignored: screen={}, paused={}", new Object[]{"EZActions", scr, mc.isPaused()});
                return;
            }
            RadialMenu.ensureLoaded();
            PATH.clear();
            mc.setScreen((Screen)new RadialMenuScreen());
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to open radial: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public static void openAtBundle(String bundleId) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null || mc.level == null) {
                Constants.LOG.debug("[{}] openAtBundle ignored: client/world not ready.", (Object)"EZActions");
                return;
            }
            if (mc.screen != null || mc.isPaused()) {
                String scr = mc.screen == null ? "none" : mc.screen.getClass().getSimpleName();
                Constants.LOG.debug("[{}] openAtBundle ignored: screen={}, paused={}, bundleId={}", new Object[]{"EZActions", scr, mc.isPaused(), bundleId});
                return;
            }
            RadialMenu.ensureLoaded();
            PATH.clear();
            List<MenuItem> path = RadialMenu.findPathToCategory(bundleId);
            if (path == null || path.isEmpty()) {
                Constants.LOG.info("[{}] Bundle '{}' not found; opening radial at root instead.", (Object)"EZActions", (Object)bundleId);
                mc.setScreen((Screen)new RadialMenuScreen());
                return;
            }
            for (MenuItem cat : path) {
                PATH.addLast(cat);
            }
            Constants.LOG.debug("[{}] openAtBundle resolved path depth={} for id='{}'", new Object[]{"EZActions", PATH.size(), bundleId});
            mc.setScreen((Screen)new RadialMenuScreen());
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] openAtBundle failed for '{}': {}", new Object[]{"EZActions", bundleId, t.toString()});
            RadialMenu.open();
        }
    }

    public static void resetToRoot() {
        PATH.clear();
    }

    public static void enterCategory(MenuItem cat) {
        if (cat == null || !cat.isCategory()) {
            return;
        }
        PATH.addLast(cat);
    }

    public static List<MenuItem> parentItems() {
        RadialMenu.ensureLoaded();
        if (PATH.isEmpty()) {
            return null;
        }
        List<MenuItem> items = ROOT;
        Iterator<MenuItem> it = PATH.iterator();
        while (it.hasNext()) {
            MenuItem cat = it.next();
            if (!it.hasNext()) {
                return items;
            }
            items = cat.childrenMutable();
        }
        return null;
    }

    public static boolean canGoBack() {
        return !PATH.isEmpty();
    }

    public static void goBack() {
        if (!PATH.isEmpty()) {
            PATH.removeLast();
        }
    }

    public static List<MenuItem> currentItems() {
        RadialMenu.ensureLoaded();
        List<MenuItem> items = ROOT;
        for (MenuItem cat : PATH) {
            items = cat.childrenMutable();
        }
        return items;
    }

    public static List<MenuItem> visibleItemsForDisplay() {
        try {
            List<MenuItem> base = RadialMenu.currentItems();
            if (base == null) {
                return Collections.emptyList();
            }
            if (PATH.isEmpty()) {
                ArrayList<MenuItem> out = new ArrayList<MenuItem>(base.size());
                for (MenuItem mi : base) {
                    if (mi == null || mi.hideFromMainRadial()) continue;
                    out.add(mi);
                }
                return out;
            }
            return base;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] visibleItemsForDisplay failed: {}", (Object)"EZActions", (Object)t.toString());
            return Collections.emptyList();
        }
    }

    public static List<String> pathTitles() {
        RadialMenu.ensureLoaded();
        ArrayList<String> out = new ArrayList<String>();
        out.add("root");
        for (MenuItem cat : PATH) {
            String t = cat == null ? "" : (cat.title() == null ? "" : cat.title());
            out.add(t.isEmpty() ? "(unnamed)" : t);
        }
        return out;
    }

    public static void reload() {
        try {
            ROOT = MenuLoader.loadMenu();
            PATH.clear();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] RadialMenu reload failed: {}", (Object)"EZActions", (Object)t.toString());
            ROOT = new ArrayList<MenuItem>();
            PATH.clear();
        }
    }

    private static void ensureLoaded() {
        if (ROOT.isEmpty()) {
            RadialMenu.reload();
        }
    }

    public static List<MenuItem> rootMutable() {
        RadialMenu.ensureLoaded();
        return ROOT;
    }

    public static boolean addToCurrent(MenuItem item) {
        List<MenuItem> cur = RadialMenu.currentItems();
        cur.add(item);
        RadialMenu.persist();
        return true;
    }

    public static boolean removeFromCurrent(String id) {
        List<MenuItem> cur = RadialMenu.currentItems();
        boolean removed = cur.removeIf(mi -> Objects.equals(mi.id(), id));
        if (removed) {
            RadialMenu.persist();
        }
        return removed;
    }

    public static boolean replaceInCurrent(String id, MenuItem replacement) {
        List<MenuItem> cur = RadialMenu.currentItems();
        for (int i = 0; i < cur.size(); ++i) {
            if (!Objects.equals(cur.get(i).id(), id)) continue;
            cur.set(i, replacement);
            RadialMenu.persist();
            return true;
        }
        return false;
    }

    public static boolean moveInCurrent(String id, int delta) {
        List<MenuItem> cur = RadialMenu.currentItems();
        for (int i = 0; i < cur.size(); ++i) {
            if (!Objects.equals(cur.get(i).id(), id)) continue;
            int j = Math.max(0, Math.min(cur.size() - 1, i + delta));
            if (i == j) {
                return false;
            }
            Collections.swap(cur, i, j);
            RadialMenu.persist();
            return true;
        }
        return false;
    }

    public static void persist() {
        try {
            MenuLoader.saveMenu(ROOT);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Failed to persist menu: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public static boolean removeInCurrent(String id) {
        try {
            List<MenuItem> items = RadialMenu.currentItems();
            if (items == null || id == null) {
                return false;
            }
            boolean removed = items.removeIf(mi -> Objects.equals(mi.id(), id));
            if (removed) {
                RadialMenu.persist();
            }
            return removed;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] removeInCurrent failed for '{}': {}", new Object[]{"EZActions", id, t.toString()});
            return false;
        }
    }

    public static boolean moveInCurrent(int from, int to) {
        try {
            List<MenuItem> items = RadialMenu.currentItems();
            if (items == null) {
                return false;
            }
            int n = items.size();
            if (n <= 1) {
                return false;
            }
            if (from < 0 || from >= n) {
                return false;
            }
            if (to < 0) {
                to = 0;
            }
            if (to > n) {
                to = n;
            }
            MenuItem m = items.remove(from);
            if (to > from) {
                --to;
            }
            items.add(to, m);
            RadialMenu.persist();
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] moveInCurrent failed {} -> {}: {}", new Object[]{"EZActions", from, to, t.toString()});
            return false;
        }
    }

    public static boolean isBundleNameTaken(String candidateId, MenuItem self) {
        try {
            RadialMenu.ensureLoaded();
            if (candidateId == null) {
                return false;
            }
            String id = candidateId.trim();
            if (id.isEmpty()) {
                return false;
            }
            return RadialMenu.isBundleNameTakenInList(ROOT, id, self);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] isBundleNameTaken failed for '{}': {}", new Object[]{"EZActions", candidateId, t.toString()});
            return false;
        }
    }

    private static boolean isBundleNameTakenInList(List<MenuItem> list, String id, MenuItem self) {
        if (list == null) {
            return false;
        }
        for (MenuItem mi : list) {
            if (mi == null || !mi.isCategory()) continue;
            if (mi != self && id.equals(mi.id())) {
                return true;
            }
            if (!RadialMenu.isBundleNameTakenInList(mi.childrenMutable(), id, self)) continue;
            return true;
        }
        return false;
    }

    private static List<MenuItem> findPathToCategory(String bundleId) {
        ArrayList<MenuItem> path = new ArrayList<MenuItem>();
        for (MenuItem rootChild : ROOT) {
            if (rootChild == null || !RadialMenu.dfsCategory(rootChild, bundleId, path)) continue;
            return path;
        }
        return null;
    }

    private static boolean dfsCategory(MenuItem current, String bundleId, List<MenuItem> path) {
        if (current == null || !current.isCategory()) {
            return false;
        }
        path.add(current);
        try {
            if (Objects.equals(current.id(), bundleId)) {
                return true;
            }
            for (MenuItem child : current.children()) {
                if (!RadialMenu.dfsCategory(child, bundleId, path)) continue;
                return true;
            }
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] dfsCategory error on '{}': {}", new Object[]{"EZActions", current.id(), t.toString()});
        }
        path.remove(path.size() - 1);
        return false;
    }
}

