/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.RadialAnimConfigView;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.RadialScreenDraw;
import org.z2six.ezactions.gui.RadialScreenMath;
import org.z2six.ezactions.gui.anim.RadialTransition;
import org.z2six.ezactions.gui.anim.SliceHoverAnim;
import org.z2six.ezactions.gui.noblur.NoMenuBlurScreen;
import org.z2six.ezactions.handler.KeyboardHandler;

public final class RadialMenuScreen
extends Screen
implements NoMenuBlurScreen {
    private int hoveredIndex = -1;
    private final RadialTransition openTrans = new RadialTransition();
    private final SliceHoverAnim hoverAnim = new SliceHoverAnim();

    public RadialMenuScreen() {
        super((Component)Component.literal((String)"ezactions Radial"));
    }

    protected void init() {
        super.init();
        this.openTrans.start(1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onHotkeyReleased() {
        try {
            MenuItem mi;
            List<MenuItem> items = RadialMenu.visibleItemsForDisplay();
            if (items != null && !items.isEmpty() && this.hoveredIndex >= 0 && this.hoveredIndex < items.size() && !(mi = items.get(this.hoveredIndex)).isCategory()) {
                KeyboardHandler.suppressReopenUntilReleased();
                this.executeAndClose(mi);
                return;
            }
            Minecraft.getInstance().setScreen(null);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] onHotkeyReleased error: {}", (Object)"EZActions", (Object)t.toString());
            Minecraft.getInstance().setScreen(null);
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        try {
            List<MenuItem> items = RadialMenu.visibleItemsForDisplay();
            int cx = this.width / 2;
            int cy = this.height / 2;
            int count = items == null ? 0 : items.size();
            RadialScreenMath.Radii rr = RadialScreenMath.computeRadii(count);
            this.hoveredIndex = count <= 0 ? -1 : RadialScreenMath.pickSector(mouseX, mouseY, cx, cy, count, rr);
            this.hoverAnim.tick(System.currentTimeMillis(), this.hoveredIndex, count);
            RadialAnimConfigView view = RadialAnimConfigView.get();
            float openProg = view.animationsEnabled && view.animOpenClose ? this.openTrans.progress() : 1.0f;
            RadialScreenDraw.drawRing(g, this.font, cx, cy, items, this.hoveredIndex, rr, this.hoverAnim, openProg);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Radial render error: {}", (Object)"EZActions", (Object)t.toString());
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            if (button == 1) {
                if (RadialMenu.canGoBack()) {
                    RadialMenu.goBack();
                    this.minecraft.setScreen((Screen)new RadialMenuScreen());
                } else {
                    this.onClose();
                }
                return true;
            }
            if (button == 0) {
                List<MenuItem> items = RadialMenu.visibleItemsForDisplay();
                if (items == null || items.isEmpty()) {
                    return true;
                }
                if (this.hoveredIndex < 0 || this.hoveredIndex >= items.size()) {
                    return true;
                }
                MenuItem mi = items.get(this.hoveredIndex);
                if (mi.isCategory()) {
                    RadialMenu.enterCategory(mi);
                    this.minecraft.setScreen((Screen)new RadialMenuScreen());
                    return true;
                }
                KeyboardHandler.suppressReopenUntilReleased();
                this.executeAndClose(mi);
                return true;
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Radial mouseClicked error: {}", (Object)"EZActions", (Object)t.toString());
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void executeAndClose(MenuItem mi) {
        try {
            Constants.LOG.info("[{}] Radial: execute action id='{}' title='{}' (closing then deferring)", new Object[]{"EZActions", mi.id(), mi.title()});
            Minecraft mc = this.minecraft;
            this.onClose();
            mc.execute(() -> {
                try {
                    boolean ok;
                    boolean bl = ok = mi.action() != null && mi.action().execute(mc);
                    if (!ok) {
                        Constants.LOG.info("[{}] Radial action returned false for '{}'", (Object)"EZActions", (Object)mi.id());
                    }
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Radial deferred execution error for '{}': {}", new Object[]{"EZActions", mi.id(), t.toString()});
                }
            });
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] executeAndClose error: {}", (Object)"EZActions", (Object)t.toString());
            this.onClose();
        }
    }

    public void onClose() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null) {
                mc.setScreen(null);
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Radial onClose error: {}", (Object)"EZActions", (Object)t.toString());
        }
    }
}

