/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import org.joml.Matrix4f;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.RadialAnimConfigView;
import org.z2six.ezactions.config.RadialConfig;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.RadialScreenMath;
import org.z2six.ezactions.gui.anim.SliceHoverAnim;

public final class RadialScreenDraw {
    private RadialScreenDraw() {
    }

    public static void drawRing(GuiGraphics g, Font font, int cx, int cy, List<MenuItem> items, int hoveredIdx, RadialScreenMath.Radii rr, SliceHoverAnim hover, float openProgress) {
        block24: {
            try {
                double rInner;
                double a1;
                double a0;
                int i;
                if (items == null || items.isEmpty()) {
                    g.fill(cx - 1, cy - 6, cx + 1, cy + 6, -1);
                    g.fill(cx - 6, cy - 1, cx + 6, cy + 1, -1);
                    return;
                }
                RadialConfig cfg = RadialConfig.get();
                RadialAnimConfigView anim = RadialAnimConfigView.get();
                int n = Math.max(1, items.size());
                double step = Math.PI * 2 / (double)n;
                double sweepLimit = -1.5707963267948966 + (double)RadialScreenDraw.clamp01(openProgress) * (Math.PI * 2);
                for (i = 0; i < n; ++i) {
                    float grow;
                    a0 = -1.5707963267948966 + (double)i * step;
                    a1 = a0 + step;
                    if (anim.animationsEnabled && anim.animOpenClose) {
                        if (sweepLimit <= a0) continue;
                        if (sweepLimit < a1) {
                            a1 = sweepLimit;
                        }
                    }
                    int color = cfg.ringColor;
                    rInner = rr.inner();
                    double rOuter = rr.outer();
                    if (anim.animationsEnabled && anim.animHover && hover != null && (grow = RadialScreenDraw.clamp01(hover.scaleFor(i))) > 0.0f) {
                        double growPct = 0.05;
                        rOuter *= 1.0 + 0.05 * (double)grow;
                    }
                    RadialScreenDraw.fillRingSector(g, cx, cy, rInner, rOuter, a0, a1, color);
                }
                if (!(anim.animationsEnabled && anim.animHover || hoveredIdx < 0 || hoveredIdx >= n)) {
                    double a02 = -1.5707963267948966 + (double)hoveredIdx * step;
                    double a12 = a02 + step;
                    if (anim.animOpenClose) {
                        if (sweepLimit > a02) {
                            if (sweepLimit < a12) {
                                a12 = sweepLimit;
                            }
                            RadialScreenDraw.fillRingSector(g, cx, cy, rr.inner(), rr.outer(), a02, a12, cfg.hoverColor);
                        }
                    } else {
                        RadialScreenDraw.fillRingSector(g, cx, cy, rr.inner(), rr.outer(), a02, a12, cfg.hoverColor);
                    }
                }
                if (anim.animationsEnabled && anim.animHover && hover != null && hoveredIdx >= 0 && hoveredIdx < n) {
                    i = hoveredIdx;
                    a0 = -1.5707963267948966 + (double)i * step;
                    a1 = a0 + step;
                    if (anim.animOpenClose) {
                        if (sweepLimit > a0) {
                            float sweep;
                            if (sweepLimit < a1) {
                                a1 = sweepLimit;
                            }
                            if ((sweep = RadialScreenDraw.clamp01(hover.sweepFor(i))) > 0.0f) {
                                rInner = rr.inner();
                                rOuterFill = rInner + (rr.outer() - rInner) * (double)sweep;
                                RadialScreenDraw.fillRingSector(g, cx, cy, rInner, rOuterFill, a0, a1, cfg.hoverColor);
                            }
                        }
                    } else {
                        float sweep = RadialScreenDraw.clamp01(hover.sweepFor(hoveredIdx));
                        if (sweep > 0.0f) {
                            rInner = rr.inner();
                            rOuterFill = rInner + (rr.outer() - rInner) * (double)sweep;
                            RadialScreenDraw.fillRingSector(g, cx, cy, rInner, rOuterFill, a0, a1, cfg.hoverColor);
                        }
                    }
                }
                double rMidBase = (rr.inner() + rr.outer()) * 0.5;
                for (int i2 = 0; i2 < n; ++i2) {
                    float grow;
                    double ang = -1.5707963267948966 + ((double)i2 + 0.5) * step;
                    double rMid = rMidBase;
                    if (anim.animationsEnabled && anim.animHover && hover != null && (grow = RadialScreenDraw.clamp01(hover.scaleFor(i2))) > 0.0f) {
                        double growPct = 0.05;
                        rMid *= 1.0 + 0.025 * (double)grow;
                    }
                    int ix = cx + (int)Math.round(Math.cos(ang) * rMid);
                    int iy = cy + (int)Math.round(Math.sin(ang) * rMid);
                    if (i2 >= items.size()) continue;
                    IconRenderer.drawIcon(g, ix, iy, items.get(i2).icon());
                }
                if (hoveredIdx < 0 || hoveredIdx >= items.size()) break block24;
                try {
                    Component comp = items.get(hoveredIdx).titleComponent();
                    if (comp != null && !comp.getString().isEmpty()) {
                        int tw = font.width(comp.getVisualOrderText());
                        int n2 = cx - tw / 2;
                        Objects.requireNonNull(font);
                        g.drawString(font, comp, n2, cy - 9 / 2, -1, false);
                    }
                }
                catch (Throwable t) {
                    Constants.LOG.debug("[{}] Center label draw failed: {}", (Object)"EZActions", (Object)t.toString());
                }
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] drawRing error: {}", (Object)"EZActions", (Object)t.toString());
            }
        }
    }

    public static void drawRing(GuiGraphics g, Font font, int cx, int cy, List<MenuItem> items, int hoveredIdx, RadialScreenMath.Radii rr) {
        RadialScreenDraw.drawRing(g, font, cx, cy, items, hoveredIdx, rr, null, 1.0f);
    }

    public static void drawRing(GuiGraphics g, Font font, int cx, int cy, List<MenuItem> items, int hoveredIdx) {
        RadialScreenMath.Radii rr = RadialScreenMath.computeRadii(items == null ? 0 : items.size());
        RadialScreenDraw.drawRing(g, font, cx, cy, items, hoveredIdx, rr, null, 1.0f);
    }

    private static void fillRingSector(GuiGraphics g, int cx, int cy, double rInner, double rOuter, double a0, double a1, int argb) {
        try {
            if (a1 <= a0) {
                return;
            }
            int segs = Math.max(12, (int)Math.ceil((a1 - a0) * 48.0));
            float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
            float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
            float gn = (float)(argb >>> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            Matrix4f pose = g.pose().last().pose();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Tesselator tess = Tesselator.getInstance();
            BufferBuilder buf = tess.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= segs; ++i) {
                double t = (double)i / (double)segs;
                double ang = a0 + (a1 - a0) * t;
                float cos = (float)Math.cos(ang);
                float sin = (float)Math.sin(ang);
                float xOuter = (float)((double)cx + (double)cos * rOuter);
                float yOuter = (float)((double)cy + (double)sin * rOuter);
                float xInner = (float)((double)cx + (double)cos * rInner);
                float yInner = (float)((double)cy + (double)sin * rInner);
                buf.addVertex(pose, xOuter, yOuter, 0.0f).setColor(r, gn, b, a);
                buf.addVertex(pose, xInner, yInner, 0.0f).setColor(r, gn, b, a);
            }
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
            RenderSystem.disableBlend();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static float clamp01(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }
}

