/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.IconPickerScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;

public final class CategoryEditScreen
extends Screen {
    private static final int LABEL_TO_FIELD = 10;
    private static final int FIELD_TO_NEXT_LABEL = 5;
    private static final int FIRST_BUTTON_ROW_OFFSET = 10;
    private static final int BETWEEN_BUTTON_ROWS = 5;
    private final Screen parent;
    private final MenuItem editing;
    private String draftTitle = "";
    private String draftNote = "";
    private IconSpec draftIcon = IconSpec.item("minecraft:stone");
    private boolean draftHideFromMainRadial = false;
    private boolean draftEnableKeybind = false;
    private EditBox titleBox;
    private EditBox noteBox;
    private Checkbox hideFromMainCheckbox;
    private Checkbox enableKeybindCheckbox;
    private boolean showRestartHint = false;

    public CategoryEditScreen(Screen parent, MenuItem editing) {
        super((Component)Component.literal((String)(editing == null ? "Add Bundle" : "Edit Bundle")));
        this.parent = parent;
        this.editing = editing;
        if (editing != null) {
            this.draftTitle = CategoryEditScreen.safe(editing.title());
            try {
                this.draftNote = CategoryEditScreen.safe(editing.note());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (editing.icon() != null) {
                this.draftIcon = editing.icon();
            }
            try {
                this.draftHideFromMainRadial = editing.hideFromMainRadial();
                this.draftEnableKeybind = editing.bundleKeybindEnabled();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    protected void init() {
        int cx = this.width / 2;
        int y = 48;
        this.titleBox = new EditBox(this.font, cx - 140, y, 280, 20, (Component)Component.literal((String)"Title"));
        this.titleBox.setHint((Component)Component.literal((String)"Bundle title (e.g., Utilities)"));
        this.titleBox.setValue(this.draftTitle);
        this.titleBox.setResponder(s -> {
            this.draftTitle = CategoryEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.titleBox);
        this.noteBox = new EditBox(this.font, cx - 140, y += 35, 280, 20, (Component)Component.literal((String)"Note"));
        this.noteBox.setHint((Component)Component.literal((String)"Optional note (shown as tooltip in editor)"));
        this.noteBox.setValue(this.draftNote);
        this.noteBox.setResponder(s -> {
            this.draftNote = CategoryEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.noteBox);
        y += 20;
        this.hideFromMainCheckbox = Checkbox.builder((Component)Component.literal((String)"Hide from main radial"), (Font)this.font).pos(cx - 140, y += 6).selected(this.draftHideFromMainRadial).onValueChange((cb, value) -> {
            this.draftHideFromMainRadial = value;
        }).maxWidth(280).build();
        this.addRenderableWidget((GuiEventListener)this.hideFromMainCheckbox);
        this.enableKeybindCheckbox = Checkbox.builder((Component)Component.literal((String)"Enable keybind"), (Font)this.font).pos(cx - 140, y += 24).selected(this.draftEnableKeybind).onValueChange((cb, value) -> {
            this.draftEnableKeybind = value;
            this.showRestartHint = true;
        }).maxWidth(280).build();
        this.addRenderableWidget((GuiEventListener)this.enableKeybindCheckbox);
        y += 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Choose Icon"), b -> this.minecraft.setScreen((Screen)new IconPickerScreen(this, ic -> {
            this.draftIcon = ic == null ? IconSpec.item("minecraft:stone") : ic;
            this.minecraft.setScreen((Screen)this);
        }))).bounds(cx - 140, y += 10, 280, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), b -> this.onSavePressed()).bounds(cx - 140, y += 25, 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onClose()).bounds(cx - 44, y, 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> this.minecraft.setScreen(this.parent)).bounds(cx + 52, y, 90, 20).build());
    }

    private void onSavePressed() {
        try {
            Screen screen;
            boolean ok;
            this.draftTitle = CategoryEditScreen.safe(this.titleBox == null ? this.draftTitle : this.titleBox.getValue()).trim();
            this.draftNote = CategoryEditScreen.safe(this.noteBox == null ? this.draftNote : this.noteBox.getValue()).trim();
            if (this.draftTitle.isEmpty()) {
                Constants.LOG.warn("[{}] CategoryEdit: Title empty; ignoring save.", (Object)"EZActions");
                return;
            }
            String newId = this.draftTitle;
            if (RadialMenu.isBundleNameTaken(newId, this.editing)) {
                Constants.LOG.warn("[{}] CategoryEdit: Duplicate bundle title/id '{}' detected; save aborted.", (Object)"EZActions", (Object)newId);
                try {
                    if (this.titleBox != null) {
                        this.titleBox.setTextColor(-43691);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            ArrayList<MenuItem> children = new ArrayList<MenuItem>();
            if (this.editing != null) {
                try {
                    children.addAll(this.editing.childrenMutable());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            boolean hideFlag = this.draftHideFromMainRadial;
            boolean keybindFlag = this.draftEnableKeybind;
            MenuItem newItem = new MenuItem(newId, this.draftTitle, this.draftNote, this.draftIcon, null, children, hideFlag, keybindFlag);
            boolean bl = ok = this.editing == null ? RadialMenu.addToCurrent(newItem) : RadialMenu.replaceInCurrent(this.editing.id(), newItem);
            if (!ok) {
                Constants.LOG.info("[{}] Category save failed (page full or replace failed) '{}'.", (Object)"EZActions", (Object)this.draftTitle);
            }
            if ((screen = this.parent) instanceof MenuEditorScreen) {
                MenuEditorScreen m = (MenuEditorScreen)screen;
                m.refreshFromChild();
            }
            this.minecraft.setScreen(this.parent);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] CategoryEdit onSave failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -2013265920);
        g.fill(12, 52, this.width - 12, this.height - 36, -1072689136);
        g.drawCenteredString(this.font, this.title.getString(), this.width / 2, 14, 0xFFFFFF);
        if (this.titleBox != null) {
            g.drawString(this.font, "Title:", this.titleBox.getX(), this.titleBox.getY() - 10, 0xA0A0A0);
        }
        if (this.noteBox != null) {
            g.drawString(this.font, "Note:", this.noteBox.getX(), this.noteBox.getY() - 10, 0xA0A0A0);
        }
        int boxW = 60;
        int boxH = 60;
        int bx = this.width - boxW - 16;
        int by = 16;
        g.fill(bx - 1, by - 1, bx + boxW + 1, by + boxH + 1, 0x40FFFFFF);
        g.fill(bx, by, bx + boxW, by + boxH, 0x20202020);
        g.drawString(this.font, "Icon", bx + 18, by + 4, 0xA0A0A0);
        try {
            IconRenderer.drawIcon(g, bx + boxW / 2, by + boxH / 2 + 6, this.draftIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.showRestartHint && this.enableKeybindCheckbox != null) {
            int hx = this.enableKeybindCheckbox.getX();
            int hy = this.enableKeybindCheckbox.getY() + 22;
            MutableComponent msg = Component.literal((String)"Applied on next restart").withStyle(ChatFormatting.RED);
            g.drawString(this.font, msg.getString(), hx, hy, -43691);
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

