/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.data.click.ClickActionCommand;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.IconPickerScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;

public final class CommandActionEditScreen
extends Screen {
    private static final int LABEL_TO_FIELD = 10;
    private static final int FIELD_TO_NEXT_LABEL = 5;
    private static final int FIRST_BUTTON_ROW_OFFSET = 10;
    private static final int BETWEEN_BUTTON_ROWS = 5;
    private final Screen parent;
    private final MenuItem editing;
    private String draftTitle = "";
    private String draftNote = "";
    private String draftCommand = "/say hi";
    private int draftDelayTicks = 0;
    private IconSpec draftIcon = IconSpec.item("minecraft:stone");
    private EditBox titleBox;
    private EditBox noteBox;
    private MultiLineEditBox cmdBox;
    private EditBox delayBox;

    public CommandActionEditScreen(Screen parent, MenuItem editing) {
        super((Component)Component.literal((String)(editing == null ? "Add Command" : "Edit Command")));
        IClickAction iClickAction;
        this.parent = parent;
        this.editing = editing;
        if (editing != null && (iClickAction = editing.action()) instanceof ClickActionCommand) {
            ClickActionCommand cc = (ClickActionCommand)iClickAction;
            this.draftTitle = CommandActionEditScreen.safe(editing.title());
            try {
                this.draftNote = CommandActionEditScreen.safe(editing.note());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String extracted = "";
            try {
                extracted = cc.getCommand();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (extracted == null || extracted.isEmpty()) {
                extracted = CommandActionEditScreen.tryExtractCommandString(cc);
            }
            if (!extracted.isEmpty()) {
                this.draftCommand = extracted;
            }
            int delay = 0;
            try {
                delay = cc.getDelayTicks();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (delay <= 0) {
                delay = CommandActionEditScreen.tryExtractDelayTicks(cc);
            }
            this.draftDelayTicks = Math.max(0, delay);
            if (editing.icon() != null) {
                this.draftIcon = editing.icon();
            }
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String tryExtractCommandString(ClickActionCommand cc) {
        String[] fieldNames;
        String[] methodNames;
        for (String mname : methodNames = new String[]{"command", "getCommand", "getCmd", "cmd"}) {
            try {
                String s;
                Method m = cc.getClass().getMethod(mname, new Class[0]);
                Object v = m.invoke((Object)cc, new Object[0]);
                if (!(v instanceof String) || (s = (String)v).isEmpty()) continue;
                return s;
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        for (String fname : fieldNames = new String[]{"command", "cmd", "commandRaw"}) {
            try {
                String s;
                Field f = cc.getClass().getDeclaredField(fname);
                f.setAccessible(true);
                Object v = f.get(cc);
                if (!(v instanceof String) || (s = (String)v).isEmpty()) continue;
                return s;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    private static int tryExtractDelayTicks(ClickActionCommand cc) {
        String[] fields;
        String[] methods;
        for (String mname : methods = new String[]{"getDelayTicks", "delayTicks", "getDelay", "delay"}) {
            try {
                Method m = cc.getClass().getMethod(mname, new Class[0]);
                Object v = m.invoke((Object)cc, new Object[0]);
                if (!(v instanceof Number)) continue;
                Number n = (Number)v;
                return n.intValue();
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        for (String fname : fields = new String[]{"delayTicks", "delay", "ticksDelay"}) {
            try {
                Field f = cc.getClass().getDeclaredField(fname);
                f.setAccessible(true);
                Object v = f.get(cc);
                if (!(v instanceof Number)) continue;
                Number n = (Number)v;
                return n.intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    protected void init() {
        int cx = this.width / 2;
        int y = 48;
        this.titleBox = new EditBox(this.font, cx - 160, y, 320, 20, (Component)Component.literal((String)"Title"));
        this.titleBox.setHint((Component)Component.literal((String)"Title (e.g., Say Time)"));
        this.titleBox.setValue(this.draftTitle);
        this.titleBox.setResponder(s -> {
            this.draftTitle = CommandActionEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.titleBox);
        this.noteBox = new EditBox(this.font, cx - 160, y += 35, 320, 20, (Component)Component.literal((String)"Note"));
        this.noteBox.setHint((Component)Component.literal((String)"Optional note (tooltip in editor)"));
        this.noteBox.setValue(this.draftNote);
        this.noteBox.setResponder(s -> {
            this.draftNote = CommandActionEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.noteBox);
        y += 35;
        int cfgLines = 5;
        try {
            cfgLines = GeneralClientConfig.CONFIG.commandEditorVisibleLines();
        }
        catch (Throwable t) {
            Constants.LOG.debug("[{}] commandEditorVisibleLines read failed; using default 5: {}", (Object)"EZActions", (Object)t.toString());
            cfgLines = 5;
        }
        if (cfgLines < 1) {
            cfgLines = 1;
        }
        if (cfgLines > 20) {
            cfgLines = 20;
        }
        int V_PADDING = 6;
        Objects.requireNonNull(this.font);
        int cmdH = 9 * cfgLines + 6;
        this.cmdBox = new MultiLineEditBox(this.font, cx - 160, y, 320, cmdH, (Component)Component.literal((String)"Command"), (Component)Component.literal((String)this.draftCommand));
        this.cmdBox.setCharacterLimit(Short.MAX_VALUE);
        this.cmdBox.setValue(this.draftCommand);
        this.cmdBox.setValueListener(s -> {
            this.draftCommand = CommandActionEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.cmdBox);
        this.delayBox = new EditBox(this.font, cx - 160, y += cmdH + 5 + 10, 80, 20, (Component)Component.literal((String)"Delay (ticks)"));
        this.delayBox.setValue(this.draftDelayTicks > 0 ? Integer.toString(this.draftDelayTicks) : "");
        this.delayBox.setResponder(s -> {
            try {
                int v = Integer.parseInt(s.trim());
                this.draftDelayTicks = Math.max(0, v);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.addRenderableWidget((GuiEventListener)this.delayBox);
        y += 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Choose Icon"), b -> this.minecraft.setScreen((Screen)new IconPickerScreen(this, ic -> {
            this.draftIcon = ic == null ? IconSpec.item("minecraft:stone") : ic;
            this.minecraft.setScreen((Screen)this);
        }))).bounds(cx - 160, y += 10, 320, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), b -> this.onSavePressed()).bounds(cx - 160, y += 25, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onClose()).bounds(cx - 52, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> this.minecraft.setScreen(this.parent)).bounds(cx + 56, y, 100, 20).build());
    }

    private void onSavePressed() {
        try {
            Screen screen;
            boolean ok;
            this.draftTitle = CommandActionEditScreen.safe(this.titleBox == null ? this.draftTitle : this.titleBox.getValue()).trim();
            this.draftNote = CommandActionEditScreen.safe(this.noteBox == null ? this.draftNote : this.noteBox.getValue()).trim();
            this.draftCommand = CommandActionEditScreen.safe(this.cmdBox == null ? this.draftCommand : this.cmdBox.getValue()).trim();
            int delay = 0;
            try {
                String s = this.delayBox == null ? "" : this.delayBox.getValue().trim();
                delay = s.isEmpty() ? 0 : Math.max(0, Integer.parseInt(s));
            }
            catch (Throwable s) {
                // empty catch block
            }
            this.draftDelayTicks = delay;
            if (this.draftTitle.isEmpty() || this.draftCommand.isEmpty()) {
                Constants.LOG.warn("[{}] CommandEdit: Title or Command empty; ignoring save.", (Object)"EZActions");
                return;
            }
            MenuItem item = new MenuItem(this.editing != null ? this.editing.id() : MenuEditorScreen.freshId("cmd"), this.draftTitle, this.draftNote, this.draftIcon, (IClickAction)new ClickActionCommand(this.draftCommand, this.draftDelayTicks), List.of());
            boolean bl = ok = this.editing == null ? RadialMenu.addToCurrent(item) : RadialMenu.replaceInCurrent(this.editing.id(), item);
            if (!ok) {
                Constants.LOG.info("[{}] Command save failed for '{}'.", (Object)"EZActions", (Object)this.draftTitle);
            }
            if ((screen = this.parent) instanceof MenuEditorScreen) {
                MenuEditorScreen m = (MenuEditorScreen)screen;
                m.refreshFromChild();
            }
            this.minecraft.setScreen(this.parent);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] CommandEdit onSave failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -2013265920);
        g.fill(12, 52, this.width - 12, this.height - 36, -1072689136);
        g.drawCenteredString(this.font, this.title.getString(), this.width / 2, 14, 0xFFFFFF);
        int labelX = this.width / 2 - 160;
        if (this.titleBox != null) {
            g.drawString(this.font, "Title:", labelX, this.titleBox.getY() - 10, 0xA0A0A0);
        }
        if (this.noteBox != null) {
            g.drawString(this.font, "Note:", labelX, this.noteBox.getY() - 10, 0xA0A0A0);
        }
        if (this.cmdBox != null) {
            g.drawString(this.font, "Command:", labelX, this.cmdBox.getY() - 10, 0xA0A0A0);
        }
        if (this.delayBox != null) {
            g.drawString(this.font, "Multi-command delay (ticks):", labelX, this.delayBox.getY() - 10, 0xA0A0A0);
        }
        int boxW = 60;
        int boxH = 60;
        int bx = this.width - boxW - 16;
        int by = 16;
        g.fill(bx - 1, by - 1, bx + boxW + 1, by + boxH + 1, 0x40FFFFFF);
        g.fill(bx, by, bx + boxW, by + boxH, 0x20202020);
        g.drawString(this.font, "Icon", bx + 18, by + 4, 0xA0A0A0);
        try {
            IconRenderer.drawIcon(g, bx + boxW / 2, by + boxH / 2 + 6, this.draftIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

