/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.data.click.ClickActionKey;
import org.z2six.ezactions.data.click.IClickAction;
import org.z2six.ezactions.data.icon.IconSpec;
import org.z2six.ezactions.data.menu.MenuItem;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.IconRenderer;
import org.z2six.ezactions.gui.editor.IconPickerScreen;
import org.z2six.ezactions.gui.editor.KeybindPickerScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;
import org.z2six.ezactions.helper.InputInjector;

public final class KeyActionEditScreen
extends Screen {
    private static final int FIELD_W = 240;
    private static final int FIELD_H = 20;
    private static final int LABEL_TO_FIELD = 10;
    private static final int FIELD_TO_NEXT_LABEL = 5;
    private static final int FIRST_BUTTON_ROW_OFFSET = 10;
    private static final int BETWEEN_BUTTON_ROWS = 5;
    private final Screen parent;
    private final MenuItem editing;
    private final SaveHandler onSave;
    private String draftTitle = "";
    private String draftNote = "";
    private String draftMapping = "";
    private boolean draftToggle = false;
    private InputInjector.DeliveryMode draftMode = InputInjector.DeliveryMode.AUTO;
    private IconSpec draftIcon = IconSpec.item("minecraft:stone");
    private EditBox titleBox;
    private EditBox noteBox;
    private EditBox mappingBox;
    private CycleButton<InputInjector.DeliveryMode> modeCycle;
    private CycleButton<Boolean> toggleCycle;

    public KeyActionEditScreen(Screen parent, MenuItem editing) {
        this(parent, editing, null);
    }

    public KeyActionEditScreen(Screen parent, MenuItem editing, SaveHandler onSave) {
        super((Component)Component.literal((String)(editing == null ? "Add Key Action" : "Edit Key Action")));
        IClickAction iClickAction;
        this.parent = parent;
        this.editing = editing;
        this.onSave = onSave;
        if (editing != null && (iClickAction = editing.action()) instanceof ClickActionKey) {
            ClickActionKey ck = (ClickActionKey)iClickAction;
            this.draftTitle = KeyActionEditScreen.safe(editing.title());
            try {
                this.draftNote = KeyActionEditScreen.safe(editing.note());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.draftMapping = KeyActionEditScreen.safe(ck.mappingName());
            this.draftToggle = ck.toggle();
            this.draftMode = ck.mode();
            IconSpec ic = editing.icon();
            if (ic != null) {
                this.draftIcon = ic;
            }
        }
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    protected void init() {
        int cx = this.width / 2;
        int y = 52;
        this.titleBox = new EditBox(this.font, cx - 120, y, 240, 20, (Component)Component.literal((String)"Title"));
        this.titleBox.setValue(this.draftTitle);
        this.titleBox.setHint((Component)Component.literal((String)"Title (e.g., Inventory)"));
        this.titleBox.setResponder(s -> {
            this.draftTitle = KeyActionEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.titleBox);
        this.noteBox = new EditBox(this.font, cx - 120, y += 35, 240, 20, (Component)Component.literal((String)"Note"));
        this.noteBox.setValue(this.draftNote);
        this.noteBox.setHint((Component)Component.literal((String)"Optional note (tooltip in editor)"));
        this.noteBox.setResponder(s -> {
            this.draftNote = KeyActionEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.noteBox);
        this.mappingBox = new EditBox(this.font, cx - 120, y += 35, 240, 20, (Component)Component.literal((String)"Mapping Name"));
        this.mappingBox.setValue(this.draftMapping);
        this.mappingBox.setHint((Component)Component.literal((String)"KeyMapping id (e.g., key.inventory)"));
        this.mappingBox.setResponder(s -> {
            this.draftMapping = KeyActionEditScreen.safe(s);
        });
        this.addRenderableWidget((GuiEventListener)this.mappingBox);
        y += 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Pick from Keybinds\u2026"), b -> {
            try {
                this.minecraft.setScreen((Screen)new KeybindPickerScreen(this, mapping -> {
                    if (mapping != null && !mapping.isEmpty()) {
                        this.draftMapping = mapping;
                        if (this.mappingBox != null) {
                            this.mappingBox.setValue(mapping);
                        }
                    }
                    this.minecraft.setScreen((Screen)this);
                }));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeyActionEdit: opening KeybindPickerScreen failed: {}", (Object)"EZActions", (Object)t.toString());
            }
        }).bounds(cx - 120, y += 10, 240, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Choose Icon"), b -> {
            try {
                this.minecraft.setScreen((Screen)new IconPickerScreen(this, ic -> {
                    this.draftIcon = ic == null ? IconSpec.item("minecraft:stone") : ic;
                    this.minecraft.setScreen((Screen)this);
                }));
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] KeyActionEdit: opening IconPickerScreen failed: {}", (Object)"EZActions", (Object)t.toString());
            }
        }).bounds(cx - 120, y += 25, 240, 20).build());
        this.modeCycle = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(dm -> Component.literal((String)dm.name())).withValues((Object[])new InputInjector.DeliveryMode[]{InputInjector.DeliveryMode.AUTO, InputInjector.DeliveryMode.INPUT, InputInjector.DeliveryMode.TICK}).withInitialValue((Object)this.draftMode).create(cx - 120, y += 25, 116, 20, (Component)Component.literal((String)"Delivery")));
        this.toggleCycle = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.draftToggle).create(cx + 4, y, 116, 20, (Component)Component.literal((String)"Toggle")));
        int totalW = 256;
        int leftX = cx - totalW / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), b -> this.onSavePressed()).bounds(leftX, y += 25, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onClose()).bounds(leftX + 80 + 8, y, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> this.minecraft.setScreen(this.parent)).bounds(leftX + 176, y, 80, 20).build());
    }

    private void onSavePressed() {
        try {
            boolean ok;
            this.draftTitle = KeyActionEditScreen.safe(this.titleBox == null ? this.draftTitle : this.titleBox.getValue()).trim();
            this.draftNote = KeyActionEditScreen.safe(this.noteBox == null ? this.draftNote : this.noteBox.getValue()).trim();
            this.draftMapping = KeyActionEditScreen.safe(this.mappingBox == null ? this.draftMapping : this.mappingBox.getValue()).trim();
            this.draftMode = this.modeCycle == null ? this.draftMode : (InputInjector.DeliveryMode)((Object)this.modeCycle.getValue());
            boolean bl = this.draftToggle = this.toggleCycle != null && Boolean.TRUE.equals(this.toggleCycle.getValue());
            if (this.draftTitle.isEmpty() || this.draftMapping.isEmpty()) {
                Constants.LOG.warn("[{}] KeyActionEdit: Title or Mapping empty; ignoring save.", (Object)"EZActions");
                return;
            }
            MenuItem newItem = new MenuItem(this.editing != null ? this.editing.id() : MenuEditorScreen.freshId("key"), this.draftTitle, this.draftNote, this.draftIcon, (IClickAction)new ClickActionKey(this.draftMapping, this.draftToggle, this.draftMode), List.of());
            if (this.onSave != null) {
                this.onSave.accept(newItem, this.editing);
                this.minecraft.setScreen(this.parent);
                return;
            }
            boolean bl2 = ok = this.editing == null ? RadialMenu.addToCurrent(newItem) : RadialMenu.replaceInCurrent(this.editing.id(), newItem);
            if (!ok) {
                Constants.LOG.info("[{}] Page full or replace failed for '{}'.", (Object)"EZActions", (Object)newItem.title());
            }
            this.minecraft.setScreen(this.parent);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] KeyActionEdit onSave failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -2013265920);
        g.fill(12, 52, this.width - 12, this.height - 36, -1072689136);
        g.drawCenteredString(this.font, this.title.getString(), this.width / 2, 20, 0xFFFFFF);
        if (this.titleBox != null) {
            g.drawString(this.font, "Title:", this.titleBox.getX(), this.titleBox.getY() - 10, 0xA0A0A0);
        }
        if (this.noteBox != null) {
            g.drawString(this.font, "Note:", this.noteBox.getX(), this.noteBox.getY() - 10, 0xA0A0A0);
        }
        if (this.mappingBox != null) {
            g.drawString(this.font, "Mapping Name:", this.mappingBox.getX(), this.mappingBox.getY() - 10, 0xA0A0A0);
        }
        try {
            IconRenderer.drawIcon(g, this.width - 28, 28, this.draftIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @FunctionalInterface
    public static interface SaveHandler
    extends BiConsumer<MenuItem, MenuItem> {
    }
}

