/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor.config;

import java.util.Locale;
import java.util.Objects;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static String toHexARGB(int a, int r, int g, int b) {
        int argb = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        Object s = Integer.toHexString(argb).toUpperCase(Locale.ROOT);
        if (((String)s).length() < 8) {
            s = "00000000".substring(((String)s).length()) + (String)s;
        }
        return "#" + (String)s;
    }

    public static String toHexARGB(int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        return ColorUtil.toHexARGB(a, r, g, b);
    }

    public static int[] parseHexARGB(String s) throws IllegalArgumentException {
        Object t = Objects.requireNonNull(s, "hex").trim();
        if (((String)t).startsWith("#")) {
            t = ((String)t).substring(1);
        }
        if (((String)t).length() == 6) {
            t = "FF" + (String)t;
        }
        if (((String)t).length() != 8) {
            throw new IllegalArgumentException("Hex must be 6 or 8 digits");
        }
        int v = (int)Long.parseLong((String)t, 16);
        return new int[]{v >>> 24 & 0xFF, v >>> 16 & 0xFF, v >>> 8 & 0xFF, v & 0xFF};
    }

    public static int[] hsvToRgb(float h, float s, float v) {
        h = ColorUtil.wrap01(h);
        s = ColorUtil.clamp01(s);
        float r = v = ColorUtil.clamp01(v);
        float g = v;
        float b = v;
        if (s > 0.0f) {
            float i = (float)Math.floor(h * 6.0f);
            float f = h * 6.0f - i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            switch ((int)i % 6) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = p;
                    b = q;
                }
            }
        }
        return new int[]{Math.round(r * 255.0f), Math.round(g * 255.0f), Math.round(b * 255.0f)};
    }

    public static float[] rgbToHsv(int r, int g, int b) {
        float min;
        float rf = (float)(r & 0xFF) / 255.0f;
        float gf = (float)(g & 0xFF) / 255.0f;
        float bf = (float)(b & 0xFF) / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float d = max - (min = Math.min(rf, Math.min(gf, bf)));
        float h = d == 0.0f ? 0.0f : (max == rf ? ((gf - bf) / d + (gf < bf ? 6.0f : 0.0f)) / 6.0f : (max == gf ? ((bf - rf) / d + 2.0f) / 6.0f : ((rf - gf) / d + 4.0f) / 6.0f));
        float s = max == 0.0f ? 0.0f : d / max;
        float v = max;
        return new float[]{ColorUtil.wrap01(h), ColorUtil.clamp01(s), ColorUtil.clamp01(v)};
    }

    public static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    public static float wrap01(float v) {
        if ((v %= 1.0f) < 0.0f) {
            v += 1.0f;
        }
        return v;
    }

    public static int clamp255(int v) {
        return v < 0 ? 0 : (v > 255 ? 255 : v);
    }
}

