/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.gui.editor.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.DesignClientConfig;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.config.RadialAnimConfig;
import org.z2six.ezactions.gui.editor.config.ColorPickerScreen;
import org.z2six.ezactions.gui.editor.config.ColorUtil;

public final class ConfigScreen
extends Screen {
    private final Screen parent;
    private Section section = Section.GENERAL;
    private boolean skipReloadDraftsOnce = false;
    private boolean draftMoveWhileRadialOpen;
    private int draftCmdVisibleLines;
    private boolean draftAnimEnabled;
    private boolean draftAnimOpenClose;
    private boolean draftAnimHover;
    private double draftHoverGrowPct;
    private int draftOpenCloseMs;
    private int draftDeadzone;
    private int draftBaseOuterRadius;
    private int draftRingThickness;
    private int draftScaleStartThreshold;
    private int draftScalePerItem;
    private int draftRingColor;
    private int draftHoverColor;
    private CycleButton<Boolean> wMoveWhileOpen;
    private EditBox wCmdLines;
    private CycleButton<Boolean> wAnimEnabled;
    private CycleButton<Boolean> wAnimOpenClose;
    private CycleButton<Boolean> wAnimHover;
    private EditBox wHoverGrowPct;
    private EditBox wOpenCloseMs;
    private EditBox wDeadzone;
    private EditBox wOuter;
    private EditBox wThick;
    private EditBox wScaleStart;
    private EditBox wScalePer;
    private Button wRingPick;
    private Button wHoverPick;

    public ConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"EZ Actions \u2013 Configuration"));
        this.parent = parent;
    }

    protected void init() {
        if (!this.skipReloadDraftsOnce) {
            this.readCurrentIntoDrafts();
        } else {
            this.skipReloadDraftsOnce = false;
        }
        this.buildUI();
    }

    private void readCurrentIntoDrafts() {
        try {
            this.draftMoveWhileRadialOpen = GeneralClientConfig.CONFIG.moveWhileRadialOpen();
            this.draftCmdVisibleLines = GeneralClientConfig.CONFIG.commandEditorVisibleLines();
            this.draftAnimEnabled = RadialAnimConfig.CONFIG.animationsEnabled();
            this.draftAnimOpenClose = RadialAnimConfig.CONFIG.animOpenClose();
            this.draftAnimHover = RadialAnimConfig.CONFIG.animHover();
            this.draftHoverGrowPct = RadialAnimConfig.CONFIG.hoverGrowPct();
            this.draftOpenCloseMs = RadialAnimConfig.CONFIG.openCloseMs();
            this.draftDeadzone = (Integer)DesignClientConfig.deadzone.get();
            this.draftBaseOuterRadius = (Integer)DesignClientConfig.baseOuterRadius.get();
            this.draftRingThickness = (Integer)DesignClientConfig.ringThickness.get();
            this.draftScaleStartThreshold = (Integer)DesignClientConfig.scaleStartThreshold.get();
            this.draftScalePerItem = (Integer)DesignClientConfig.scalePerItem.get();
            this.draftRingColor = (Integer)DesignClientConfig.ringColor.get();
            this.draftHoverColor = (Integer)DesignClientConfig.hoverColor.get();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] ConfigScreen: failed reading current specs: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    private void buildUI() {
        this.clearWidgets();
        int PAD = 12;
        int LEFT_W = 160;
        int FIELD_W = 160;
        int FIELD_H = 20;
        int RIGHT_INNER_PAD = 16;
        int HEADER_Y = 20;
        int FORM_TOP_GAP = 18;
        int x = 12;
        int y = 12;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"General"), b -> {
            this.section = Section.GENERAL;
            this.buildUI();
        }).bounds(x, y, 160, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Animations"), b -> {
            this.section = Section.ANIM;
            this.buildUI();
        }).bounds(x, y += 24, 160, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Design"), b -> {
            this.section = Section.DESIGN;
            this.buildUI();
        }).bounds(x, y += 24, 160, 20).build());
        int bottom = this.height - 12;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), b -> this.onSave()).bounds(x, bottom - 22, 160, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), b -> this.onClose()).bounds(x, bottom - 22 - 24, 160, 20).build());
        int rightPanelX = 184;
        int formX = rightPanelX + 16;
        int formY = 38;
        int row = 0;
        switch (this.section.ordinal()) {
            case 0: {
                this.wMoveWhileOpen = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.draftMoveWhileRadialOpen).create(formX, formY + row * 28, 160, 20, (Component)Component.literal((String)"Move While Radial Open")));
                this.wCmdLines = new EditBox(this.font, formX, formY + ++row * 28, 160, 20, (Component)Component.literal((String)""));
                this.wCmdLines.setValue(Integer.toString(this.draftCmdVisibleLines));
                this.addRenderableWidget((GuiEventListener)this.wCmdLines);
                break;
            }
            case 1: {
                this.wAnimEnabled = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.draftAnimEnabled).create(formX, formY + row * 28, 160, 20, (Component)Component.literal((String)"Animations Enabled")));
                this.wAnimOpenClose = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.draftAnimOpenClose).create(formX, formY + ++row * 28, 160, 20, (Component)Component.literal((String)"Open/Close Wipe")));
                this.wAnimHover = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.draftAnimHover).create(formX, formY + ++row * 28, 160, 20, (Component)Component.literal((String)"Hover Animation")));
                this.wHoverGrowPct = new EditBox(this.font, formX, formY + ++row * 28, 160, 20, (Component)Component.literal((String)""));
                this.wHoverGrowPct.setValue(Double.toString(this.draftHoverGrowPct));
                this.addRenderableWidget((GuiEventListener)this.wHoverGrowPct);
                this.wOpenCloseMs = new EditBox(this.font, formX, formY + ++row * 28, 160, 20, (Component)Component.literal((String)""));
                this.wOpenCloseMs.setValue(Integer.toString(this.draftOpenCloseMs));
                this.addRenderableWidget((GuiEventListener)this.wOpenCloseMs);
                break;
            }
            case 2: {
                this.wDeadzone = this.addIntBox(formX, formY + row * 28, 160, 20, this.draftDeadzone);
                this.wOuter = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftBaseOuterRadius);
                this.wThick = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftRingThickness);
                this.wScaleStart = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftScaleStartThreshold);
                this.wScalePer = this.addIntBox(formX, formY + ++row * 28, 160, 20, this.draftScalePerItem);
                int btnY = formY + ++row * 28;
                this.wRingPick = Button.builder((Component)Component.literal((String)"Pick Ring Color\u2026"), b -> {
                    this.skipReloadDraftsOnce = true;
                    this.minecraft.setScreen((Screen)new ColorPickerScreen(this, this.draftRingColor, argb -> {
                        this.draftRingColor = argb;
                    }));
                }).bounds(formX, btnY, 160, 20).build();
                this.addRenderableWidget((GuiEventListener)this.wRingPick);
                this.wHoverPick = Button.builder((Component)Component.literal((String)"Pick Hover Color\u2026"), b -> {
                    this.skipReloadDraftsOnce = true;
                    this.minecraft.setScreen((Screen)new ColorPickerScreen(this, this.draftHoverColor, argb -> {
                        this.draftHoverColor = argb;
                    }));
                }).bounds(formX, formY + ++row * 28, 160, 20).build();
                this.addRenderableWidget((GuiEventListener)this.wHoverPick);
            }
        }
    }

    private EditBox addIntBox(int x, int y, int w, int h, int value) {
        EditBox eb = new EditBox(this.font, x, y, w, h, (Component)Component.literal((String)""));
        eb.setValue(Integer.toString(value));
        this.addRenderableWidget((GuiEventListener)eb);
        return eb;
    }

    private void onSave() {
        try {
            switch (this.section.ordinal()) {
                case 0: {
                    this.draftMoveWhileRadialOpen = this.wMoveWhileOpen != null && Boolean.TRUE.equals(this.wMoveWhileOpen.getValue());
                    this.draftCmdVisibleLines = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wCmdLines, 5), 1, 20);
                    GeneralClientConfig.CONFIG.moveWhileRadialOpen.set((Object)this.draftMoveWhileRadialOpen);
                    GeneralClientConfig.CONFIG.commandEditorVisibleLines.set((Object)this.draftCmdVisibleLines);
                    break;
                }
                case 1: {
                    this.draftAnimEnabled = this.wAnimEnabled != null && Boolean.TRUE.equals(this.wAnimEnabled.getValue());
                    this.draftAnimOpenClose = this.wAnimOpenClose != null && Boolean.TRUE.equals(this.wAnimOpenClose.getValue());
                    this.draftAnimHover = this.wAnimHover != null && Boolean.TRUE.equals(this.wAnimHover.getValue());
                    this.draftHoverGrowPct = ConfigScreen.clampDouble(ConfigScreen.parseSafeDouble(this.wHoverGrowPct, 0.05), 0.0, 0.5);
                    this.draftOpenCloseMs = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wOpenCloseMs, 125), 0, 2000);
                    RadialAnimConfig.CONFIG.animationsEnabled.set((Object)this.draftAnimEnabled);
                    RadialAnimConfig.CONFIG.animOpenClose.set((Object)this.draftAnimOpenClose);
                    RadialAnimConfig.CONFIG.animHover.set((Object)this.draftAnimHover);
                    RadialAnimConfig.CONFIG.hoverGrowPct.set((Object)this.draftHoverGrowPct);
                    RadialAnimConfig.CONFIG.openCloseMs.set((Object)this.draftOpenCloseMs);
                    break;
                }
                case 2: {
                    this.draftDeadzone = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wDeadzone, 18), 0, 90);
                    this.draftBaseOuterRadius = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wOuter, 72), 24, 512);
                    this.draftRingThickness = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wThick, 28), 6, 256);
                    this.draftScaleStartThreshold = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wScaleStart, 8), 0, 128);
                    this.draftScalePerItem = ConfigScreen.clamp(ConfigScreen.parseSafeInt(this.wScalePer, 6), 0, 100);
                    DesignClientConfig.deadzone.set((Object)this.draftDeadzone);
                    DesignClientConfig.baseOuterRadius.set((Object)this.draftBaseOuterRadius);
                    DesignClientConfig.ringThickness.set((Object)this.draftRingThickness);
                    DesignClientConfig.scaleStartThreshold.set((Object)this.draftScaleStartThreshold);
                    DesignClientConfig.scalePerItem.set((Object)this.draftScalePerItem);
                    DesignClientConfig.ringColor.set((Object)this.draftRingColor);
                    DesignClientConfig.hoverColor.set((Object)this.draftHoverColor);
                }
            }
            this.buildUI();
            Constants.LOG.info("[{}] Config saved (section: {})", (Object)"EZActions", (Object)this.section.name());
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Config save failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int PAD = 12;
        int LEFT_W = 160;
        int RIGHT_INNER_PAD = 16;
        int LABEL_COLOR = 0xA0A0A0;
        g.fill(0, 0, this.width, this.height, -2013265920);
        g.fill(12, 12, 172, this.height - 12, -1072689136);
        int rightPanelX = 184;
        g.fill(rightPanelX, 12, this.width - 12, this.height - 12, -1072689136);
        g.drawCenteredString(this.font, this.title.getString(), this.width / 2, 8, 0xFFFFFF);
        String sec = switch (this.section.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "General";
            case 1 -> "Animations";
            case 2 -> "Design";
        };
        int headerX = rightPanelX + 16;
        int headerY = 20;
        g.drawString(this.font, sec, headerX, headerY, 0xA0A0A0);
        switch (this.section.ordinal()) {
            case 0: {
                this.drawRightLabel(g, this.wCmdLines, "Visible lines (1\u201320)");
                break;
            }
            case 1: {
                this.drawRightLabel(g, this.wHoverGrowPct, "Hover Grow % (0.0\u20130.5)");
                this.drawRightLabel(g, this.wOpenCloseMs, "Open/Close (ms)");
                break;
            }
            case 2: {
                int y;
                int x;
                this.drawRightLabel(g, this.wDeadzone, "Deadzone");
                this.drawRightLabel(g, this.wOuter, "Outer Radius");
                this.drawRightLabel(g, this.wThick, "Ring Thickness");
                this.drawRightLabel(g, this.wScaleStart, "Scale Start");
                this.drawRightLabel(g, this.wScalePer, "Scale / Item");
                if (this.wRingPick != null) {
                    x = this.wRingPick.getX() + this.wRingPick.getWidth() + 8;
                    y = this.wRingPick.getY();
                    this.drawColorPreview(g, x, y, this.draftRingColor);
                    g.drawString(this.font, ColorUtil.toHexARGB(this.draftRingColor), x + 64 + 6, y + 4, 0xFFFFFF);
                }
                if (this.wHoverPick == null) break;
                x = this.wHoverPick.getX() + this.wHoverPick.getWidth() + 8;
                y = this.wHoverPick.getY();
                this.drawColorPreview(g, x, y, this.draftHoverColor);
                g.drawString(this.font, ColorUtil.toHexARGB(this.draftHoverColor), x + 64 + 6, y + 4, 0xFFFFFF);
            }
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    private void drawRightLabel(GuiGraphics g, EditBox eb, String label) {
        if (eb == null) {
            return;
        }
        int GAP = 8;
        int lx = eb.getX() + eb.getWidth() + 8;
        int ly = eb.getY() + 4;
        g.drawString(this.font, label, lx, ly, 0xA0A0A0);
    }

    private void drawColorPreview(GuiGraphics g, int x, int y, int argb) {
        int sw = 64;
        int sh = 18;
        int cell = 6;
        for (int yy = 0; yy < sh; yy += cell) {
            for (int xx = 0; xx < sw; xx += cell) {
                int c = (xx / cell + yy / cell) % 2 == 0 ? -3355444 : -1;
                g.fill(x + xx, y, x + Math.min(xx + cell, sw), y + Math.min(sh, cell), c);
            }
        }
        g.fill(x, y, x + sw, y + sh, argb);
        g.fill(x, y, x + sw, y + 1, -16777216);
        g.fill(x, y + sh - 1, x + sw, y + sh, -16777216);
        g.fill(x, y, x + 1, y + sh, -16777216);
        g.fill(x + sw - 1, y, x + sw, y + sh, -16777216);
    }

    private static int parseSafeInt(EditBox eb, int dflt) {
        try {
            return Integer.parseInt(eb.getValue().trim());
        }
        catch (Throwable ignored) {
            return dflt;
        }
    }

    private static double parseSafeDouble(EditBox eb, double dflt) {
        try {
            return Double.parseDouble(eb.getValue().trim());
        }
        catch (Throwable ignored) {
            return dflt;
        }
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static double clampDouble(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    private static enum Section {
        GENERAL,
        ANIM,
        DESIGN;

    }
}

