/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.handler;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.lwjgl.glfw.GLFW;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.config.GeneralClientConfig;
import org.z2six.ezactions.data.menu.RadialMenu;
import org.z2six.ezactions.gui.RadialMenuScreen;
import org.z2six.ezactions.gui.editor.MenuEditorScreen;
import org.z2six.ezactions.helper.ClientTaskQueue;
import org.z2six.ezactions.helper.InputInjector;
import org.z2six.ezactions.helper.KeyboardHandlerHelper;
import org.z2six.ezactions.util.BundleHotkeyManager;
import org.z2six.ezactions.util.CommandSequencer;
import org.z2six.ezactions.util.EZActionsKeybinds;

public final class KeyboardHandler {
    private static boolean openHeldPrev = false;
    private static boolean suppressUntilRelease = false;
    private static boolean contextsPushed = false;
    private static KeyMapping[] trackedKeys = null;
    private static IKeyConflictContext[] prevContexts = null;

    private KeyboardHandler() {
    }

    public static void suppressReopenUntilReleased() {
        suppressUntilRelease = true;
    }

    public static void onClientTickPre(ClientTickEvent.Pre e) {
        try {
            boolean heldNow;
            ClientTaskQueue.drain();
            KeyboardHandlerHelper.onClientTick();
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null) {
                return;
            }
            boolean rootDown = EZActionsKeybinds.OPEN_MENU != null && KeyboardHandler.isPhysicallyDown(mc, EZActionsKeybinds.OPEN_MENU);
            String bundleIdDown = null;
            if (!rootDown) {
                for (Map.Entry<String, KeyMapping> entry : BundleHotkeyManager.getBundleKeyMappings().entrySet()) {
                    KeyMapping mapping = entry.getValue();
                    if (mapping == null || !KeyboardHandler.isPhysicallyDown(mc, mapping)) continue;
                    bundleIdDown = entry.getKey();
                    break;
                }
            }
            boolean bl = heldNow = rootDown || bundleIdDown != null;
            if (heldNow && !openHeldPrev && !suppressUntilRelease) {
                if (bundleIdDown != null) {
                    Constants.LOG.debug("[{}] Radial bundle hotkey pressed; opening at bundle '{}'.", (Object)"EZActions", bundleIdDown);
                    RadialMenu.openAtBundle(bundleIdDown);
                } else {
                    Constants.LOG.debug("[{}] Radial root hotkey pressed; opening at root.", (Object)"EZActions");
                    RadialMenu.open();
                }
            }
            if (!heldNow && openHeldPrev) {
                Screen screen = mc.screen;
                if (screen instanceof RadialMenuScreen) {
                    RadialMenuScreen s = (RadialMenuScreen)screen;
                    s.onHotkeyReleased();
                }
                KeyboardHandler.releaseMovementKeys(mc);
                KeyboardHandler.popMovementKeyContexts(mc);
                suppressUntilRelease = false;
            }
            openHeldPrev = heldNow;
            boolean allowMove = GeneralClientConfig.CONFIG.moveWhileRadialOpen();
            if (mc.screen instanceof RadialMenuScreen) {
                if (allowMove) {
                    KeyboardHandler.pushMovementKeyContexts(mc);
                    KeyboardHandler.tickMovementPassthrough(mc);
                } else if (contextsPushed) {
                    KeyboardHandler.popMovementKeyContexts(mc);
                }
            } else if (contextsPushed) {
                KeyboardHandler.popMovementKeyContexts(mc);
            }
            if (EZActionsKeybinds.OPEN_EDITOR != null && EZActionsKeybinds.OPEN_EDITOR.consumeClick()) {
                mc.setScreen((Screen)new MenuEditorScreen(mc.screen));
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Exception during onClientTickPre: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public static void onClientTickPost(ClientTickEvent.Post e) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null) {
                return;
            }
            boolean allowMove = GeneralClientConfig.CONFIG.moveWhileRadialOpen();
            if (allowMove && mc.screen instanceof RadialMenuScreen) {
                KeyboardHandler.tickMovementPassthrough(mc);
            }
            CommandSequencer.tickClient();
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Exception during onClientTickPost: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    public static boolean isPhysicallyDown(Minecraft mc, KeyMapping mapping) {
        if (mapping == null || mc == null || mc.getWindow() == null) {
            return false;
        }
        long window = mc.getWindow().getWindow();
        if (window == 0L) {
            return false;
        }
        InputConstants.Key key = mapping.getKey();
        if (key == null) {
            return false;
        }
        return switch (key.getType()) {
            case InputConstants.Type.KEYSYM -> {
                int state;
                int code = key.getValue();
                int v0 = state = code >= 0 ? GLFW.glfwGetKey((long)window, (int)code) : 0;
                if (state == 1 || state == 2) {
                    yield true;
                }
                yield false;
            }
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)window, (int)key.getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void tickMovementPassthrough(Minecraft mc) {
        try {
            Options o = mc.options;
            if (o == null) {
                return;
            }
            KeyboardHandler.mirrorKey(mc, o.keyUp);
            KeyboardHandler.mirrorKey(mc, o.keyDown);
            KeyboardHandler.mirrorKey(mc, o.keyLeft);
            KeyboardHandler.mirrorKey(mc, o.keyRight);
            KeyboardHandler.mirrorKey(mc, o.keyJump);
            KeyboardHandler.mirrorKey(mc, o.keySprint);
            KeyboardHandler.mirrorKey(mc, o.keyShift);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Movement passthrough tick failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    private static void mirrorKey(Minecraft mc, KeyMapping km) {
        long window;
        if (km == null) {
            return;
        }
        InputConstants.Key k = km.getKey();
        if (k == null) {
            InputInjector.setKeyPressed(km, false);
            return;
        }
        long l = window = mc.getWindow() != null ? mc.getWindow().getWindow() : 0L;
        if (window == 0L) {
            InputInjector.setKeyPressed(km, false);
            return;
        }
        boolean down = switch (k.getType()) {
            case InputConstants.Type.KEYSYM -> {
                int state = GLFW.glfwGetKey((long)window, (int)k.getValue());
                if (state == 1 || state == 2) {
                    yield true;
                }
                yield false;
            }
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)window, (int)k.getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        InputInjector.setKeyPressed(km, down);
    }

    private static void releaseMovementKeys(Minecraft mc) {
        try {
            Options o = mc.options;
            if (o == null) {
                return;
            }
            InputInjector.setKeyPressed(o.keyUp, false);
            InputInjector.setKeyPressed(o.keyDown, false);
            InputInjector.setKeyPressed(o.keyLeft, false);
            InputInjector.setKeyPressed(o.keyRight, false);
            InputInjector.setKeyPressed(o.keyJump, false);
            InputInjector.setKeyPressed(o.keySprint, false);
            InputInjector.setKeyPressed(o.keyShift, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void pushMovementKeyContexts(Minecraft mc) {
        if (contextsPushed) {
            return;
        }
        try {
            Options o = mc.options;
            if (o == null) {
                return;
            }
            trackedKeys = new KeyMapping[]{o.keyUp, o.keyDown, o.keyLeft, o.keyRight, o.keyJump, o.keySprint, o.keyShift};
            prevContexts = new IKeyConflictContext[trackedKeys.length];
            for (int i = 0; i < trackedKeys.length; ++i) {
                KeyMapping km = trackedKeys[i];
                if (km == null) continue;
                try {
                    KeyboardHandler.prevContexts[i] = km.getKeyConflictContext();
                    km.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.UNIVERSAL);
                    continue;
                }
                catch (Throwable perKey) {
                    Constants.LOG.debug("[{}] Could not push context for movement key {}: {}", new Object[]{"EZActions", i, perKey.toString()});
                }
            }
            contextsPushed = true;
            Constants.LOG.debug("[{}] Movement key contexts pushed (UNIVERSAL).", (Object)"EZActions");
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] pushMovementKeyContexts failed: {}", (Object)"EZActions", (Object)t.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void popMovementKeyContexts(Minecraft mc) {
        if (!contextsPushed) {
            return;
        }
        try {
            if (trackedKeys != null && prevContexts != null) {
                for (int i = 0; i < trackedKeys.length; ++i) {
                    KeyMapping km = trackedKeys[i];
                    IKeyConflictContext prev = prevContexts[i];
                    if (km == null || prev == null) continue;
                    try {
                        km.setKeyConflictContext(prev);
                        continue;
                    }
                    catch (Throwable perKey) {
                        Constants.LOG.debug("[{}] Could not pop context for movement key {}: {}", new Object[]{"EZActions", i, perKey.toString()});
                    }
                }
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] popMovementKeyContexts failed: {}", (Object)"EZActions", (Object)t.toString());
        }
        finally {
            contextsPushed = false;
            trackedKeys = null;
            prevContexts = null;
            Constants.LOG.debug("[{}] Movement key contexts restored.", (Object)"EZActions");
        }
    }
}

