/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.helper;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.z2six.ezactions.Constants;
import org.z2six.ezactions.helper.ClientTaskQueue;
import org.z2six.ezactions.mixin.KeyboardHandlerAccessor;

public final class InputInjector {
    private static final int MODKEY_CTRL = 341;
    private static final int MODKEY_SHIFT = 340;
    private static final int MODKEY_ALT = 342;

    private InputInjector() {
    }

    public static boolean deliver(String mappingName, boolean toggle, DeliveryMode mode) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                Constants.LOG.warn("[{}] deliver('{}'): Minecraft instance is null", (Object)"EZActions", (Object)mappingName);
                return false;
            }
            Resolution res = InputInjector.resolveMappingByName(mc.options, mappingName);
            if (res.mapping == null) {
                Constants.LOG.warn("[{}] deliver('{}'): mapping not found (tried exact, localized, contains).", (Object)"EZActions", (Object)mappingName);
                return false;
            }
            InputInjector.logResolved(res);
            return InputInjector.deliverKey(res.mapping, null, null, 0, toggle, mode);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] deliver('{}') failed: {}", new Object[]{"EZActions", mappingName, t.toString()});
            return false;
        }
    }

    public static boolean deliverKey(KeyMapping mapping, @Nullable Integer explicitGlfwKey, @Nullable Integer explicitScanCode, int glfwMods, boolean toggle, DeliveryMode mode) {
        try {
            int derivedScan;
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                Constants.LOG.warn("[{}] deliverKey: Minecraft instance null for mapping '{}'", (Object)"EZActions", (Object)InputInjector.safeName(mapping));
                return false;
            }
            if (InputInjector.isTextInputFocused(mc)) {
                Constants.LOG.info("[{}] Input injection blocked: text field (Chat) focused.", (Object)"EZActions");
                return false;
            }
            InputConstants.Key current = mapping.getKey();
            String keyType = current == null ? "UNKNOWN" : current.getType().name();
            int key = explicitGlfwKey != null ? explicitGlfwKey : InputInjector.keyCodeFrom(mapping);
            int scan = explicitScanCode != null ? explicitScanCode : -1;
            boolean unbound = InputInjector.isUnbound(current);
            int n = derivedScan = key >= 0 ? GLFW.glfwGetKeyScancode((int)key) : 0;
            if (scan <= 0 && derivedScan > 0) {
                scan = derivedScan;
            }
            ModReq req = InputInjector.detectRequiredModifiers(mapping);
            DeliveryMode nominalEff = mode == DeliveryMode.AUTO ? (unbound ? DeliveryMode.TICK : DeliveryMode.INPUT) : mode;
            Constants.LOG.info("[{}] Key action fired: mapping='{}' mode={} (nominalEff={}) toggle={} [reason: {}] [type={}, glfwKey={}, scan={}, derivedScan={}, mods={} reqMods={}]", new Object[]{"EZActions", InputInjector.safeName(mapping), mode, nominalEff, toggle, unbound ? "UNBOUND" : (scan > 0 ? "BOUND+SCAN" : "BOUND+NO_SCAN"), keyType, key, scan, derivedScan, glfwMods, req.brief()});
            DeliveryMode eff = nominalEff;
            if (req.any() && eff == DeliveryMode.TICK) {
                Constants.LOG.info("[{}] Elevating TICK->INPUT because '{}' requires modifiers: {}", new Object[]{"EZActions", InputInjector.safeName(mapping), req.brief()});
                eff = DeliveryMode.INPUT;
            }
            if (req.any()) {
                boolean ok = InputInjector.deliverViaModifierShim(mc, mapping);
                if (ok) {
                    return true;
                }
                if (scan <= 0) {
                    boolean ok2 = InputInjector.deliverInputViaTemporaryBinding(mc, mapping, req);
                    if (ok2) {
                        return true;
                    }
                    Constants.LOG.warn("[{}] ModShim failed and temp-key shim failed for '{}'; falling back to legacy TICK.", (Object)"EZActions", (Object)InputInjector.safeName(mapping));
                    return InputInjector.deliverTick(mapping, toggle);
                }
                return InputInjector.deliverInputWithModifiers(mc, key, scan, req);
            }
            if (eff == DeliveryMode.INPUT && scan <= 0) {
                boolean ok = InputInjector.deliverInputViaTemporaryBinding(mc, mapping, req);
                if (ok) {
                    return true;
                }
                Constants.LOG.warn("[{}] INPUT (no-scan) shim failed for '{}'; falling back to legacy TICK.", (Object)"EZActions", (Object)InputInjector.safeName(mapping));
                return InputInjector.deliverTick(mapping, toggle);
            }
            if (mode == DeliveryMode.AUTO && (unbound || scan <= 0)) {
                boolean ok = InputInjector.deliverInputViaTemporaryBinding(mc, mapping, req);
                if (ok) {
                    return true;
                }
                Constants.LOG.warn("[{}] AUTO shim failed for '{}' (unboundOrNoScan={}): falling back to {}.", new Object[]{"EZActions", InputInjector.safeName(mapping), unbound || scan <= 0, unbound ? "TICK" : "INPUT"});
                return unbound ? InputInjector.deliverTick(mapping, toggle) : InputInjector.deliverInputWithModifiers(mc, key, scan, req);
            }
            return switch (eff.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> InputInjector.deliverInputWithModifiers(mc, key, scan, req);
                case 2 -> InputInjector.deliverTick(mapping, toggle);
                case 0 -> unbound ? InputInjector.deliverTick(mapping, toggle) : InputInjector.deliverInputWithModifiers(mc, key, scan, req);
            };
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] deliverKey('{}') failed: {}", new Object[]{"EZActions", InputInjector.safeName(mapping), t.toString()});
            return false;
        }
    }

    public static void setKeyPressed(@Nullable KeyMapping mapping, boolean down) {
        if (mapping == null) {
            return;
        }
        try {
            mapping.setDown(down);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setMappingPressed(String nameOrKey, boolean down) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.options == null) {
                return;
            }
            Resolution res = InputInjector.resolveMappingByName(mc.options, nameOrKey);
            InputInjector.setKeyPressed(res.mapping, down);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ModReq detectRequiredModifiers(KeyMapping mapping) {
        try {
            Enum<?> km = InputInjector.keyModGet(mapping, true);
            if (km == null) {
                km = InputInjector.keyModGet(mapping, false);
            }
            if (km == null) {
                return new ModReq(false, false, false);
            }
            String name = km.name();
            boolean ctrl = "CONTROL".equals(name) || "CTRL".equals(name);
            boolean shift = "SHIFT".equals(name);
            boolean alt = "ALT".equals(name);
            return new ModReq(ctrl, shift, alt);
        }
        catch (Throwable ignored) {
            return new ModReq(false, false, false);
        }
    }

    private static boolean deliverInputWithModifiers(Minecraft mc, int glfwKey, int glfwScanCode, ModReq req) {
        try {
            long window;
            long l = window = mc.getWindow() != null ? mc.getWindow().getWindow() : 0L;
            if (window == 0L) {
                Constants.LOG.warn("[{}] INPUT+MODS: window handle missing", (Object)"EZActions");
                return false;
            }
            if (glfwKey < 0) {
                Constants.LOG.warn("[{}] INPUT+MODS: invalid main key (<0).", (Object)"EZActions");
                return false;
            }
            if (glfwScanCode <= 0) {
                Constants.LOG.warn("[{}] INPUT+MODS: scancode {} (<=0). Some keys may be ignored.", (Object)"EZActions", (Object)glfwScanCode);
            }
            boolean ctrlDown = InputInjector.isPhysicallyDown(window, 341);
            boolean shiftDown = InputInjector.isPhysicallyDown(window, 340);
            boolean altDown = InputInjector.isPhysicallyDown(window, 342);
            ArrayList<Integer> pressedByUs = new ArrayList<Integer>(3);
            if (req.ctrl && !ctrlDown) {
                InputInjector.pressModifier(window, 341, pressedByUs);
            }
            if (req.shift && !shiftDown) {
                InputInjector.pressModifier(window, 340, pressedByUs);
            }
            if (req.alt && !altDown) {
                InputInjector.pressModifier(window, 342, pressedByUs);
            }
            int mods = 0;
            if (req.ctrl || ctrlDown) {
                mods |= 2;
            }
            if (req.shift || shiftDown) {
                mods |= 1;
            }
            if (req.alt || altDown) {
                mods |= 4;
            }
            int modsMask = mods;
            Constants.LOG.debug("[{}] INPUT+MODS: mainKey={} scan={} mods={} pressedByUs={}", new Object[]{"EZActions", glfwKey, glfwScanCode, modsMask, pressedByUs});
            KeyboardHandlerAccessor acc = (KeyboardHandlerAccessor)mc.keyboardHandler;
            acc.ezactions$keyPress(window, glfwKey, glfwScanCode, 1, modsMask);
            ClientTaskQueue.post(() -> {
                try {
                    acc.ezactions$keyPress(window, glfwKey, glfwScanCode, 0, modsMask);
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] INPUT+MODS main release failed: {}", (Object)"EZActions", (Object)t.toString());
                }
                Iterator iterator = pressedByUs.iterator();
                while (iterator.hasNext()) {
                    int modKey = (Integer)iterator.next();
                    try {
                        int modScan = InputInjector.safeScan(modKey);
                        acc.ezactions$keyPress(window, modKey, modScan, 0, 0);
                    }
                    catch (Throwable t) {
                        Constants.LOG.warn("[{}] INPUT+MODS mod release failed (modKey={}): {}", new Object[]{"EZActions", modKey, t.toString()});
                    }
                }
            });
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] INPUT+MODS delivery exception: {}", (Object)"EZActions", (Object)t.toString());
            return false;
        }
    }

    private static void pressModifier(long window, int modKey, List<Integer> pressedByUs) {
        try {
            int modScan = InputInjector.safeScan(modKey);
            KeyboardHandlerAccessor acc = (KeyboardHandlerAccessor)Minecraft.getInstance().keyboardHandler;
            acc.ezactions$keyPress(window, modKey, modScan, 1, 0);
            pressedByUs.add(modKey);
            Constants.LOG.debug("[{}] INPUT+MODS: pressed modifier {}", (Object)"EZActions", (Object)modKey);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] INPUT+MODS mod press failed (modKey={}): {}", new Object[]{"EZActions", modKey, t.toString()});
        }
    }

    private static boolean isPhysicallyDown(long window, int key) {
        try {
            int state = GLFW.glfwGetKey((long)window, (int)key);
            return state == 1 || state == 2;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int safeScan(int glfwKey) {
        try {
            int sc = GLFW.glfwGetKeyScancode((int)glfwKey);
            return sc > 0 ? sc : 0;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static boolean deliverInputViaTemporaryBinding(Minecraft mc, KeyMapping mapping, ModReq req) {
        try {
            Options opts = mc.options;
            if (opts == null) {
                return false;
            }
            TempKey temp = InputInjector.findTemporaryKey(opts);
            if (temp == null) {
                Constants.LOG.warn("[{}] Shim: no suitable temporary key found (in-use or scancode<=0).", (Object)"EZActions");
                return false;
            }
            InputConstants.Key oldKey = mapping.getKey();
            InputConstants.Key newKey = InputConstants.Type.KEYSYM.getOrCreate(temp.glfwKey);
            try {
                mapping.setKey(newKey);
                KeyMapping.resetMapping();
                Constants.LOG.info("[{}] Shim: temporarily bound '{}' to tempKey={} (scan={})", new Object[]{"EZActions", InputInjector.safeName(mapping), temp.glfwKey, temp.scancode});
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Shim: failed to set temporary key: {}", (Object)"EZActions", (Object)t.toString());
                return false;
            }
            boolean pressed = InputInjector.deliverInputWithModifiers(mc, temp.glfwKey, temp.scancode, req);
            ClientTaskQueue.post(() -> {
                try {
                    mapping.setKey(oldKey == null ? InputConstants.UNKNOWN : oldKey);
                    KeyMapping.resetMapping();
                    Constants.LOG.info("[{}] Shim: restored '{}' to {}.", new Object[]{"EZActions", InputInjector.safeName(mapping), oldKey == null || oldKey.getValue() < 0 ? "UNBOUND" : "key=" + oldKey.getValue()});
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] Shim: failed to restore original key for '{}': {}", new Object[]{"EZActions", InputInjector.safeName(mapping), t.toString()});
                }
            });
            return pressed;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Shim exception for '{}': {}", new Object[]{"EZActions", InputInjector.safeName(mapping), t.toString()});
            return false;
        }
    }

    @Nullable
    private static TempKey findTemporaryKey(Options opts) {
        ArrayList<Integer> candidates = new ArrayList<Integer>(32);
        candidates.add(348);
        candidates.add(331);
        candidates.add(332);
        candidates.add(333);
        candidates.add(334);
        candidates.add(330);
        candidates.add(300);
        candidates.add(299);
        candidates.add(298);
        candidates.add(297);
        candidates.add(296);
        candidates.add(283);
        candidates.add(281);
        candidates.add(284);
        candidates.add(59);
        candidates.add(39);
        candidates.add(161);
        candidates.add(162);
        StringBuilder tried = new StringBuilder(128);
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            int cand = (Integer)iterator.next();
            if (InputInjector.isKeyInUse(opts, cand)) {
                tried.append(cand).append("(in-use), ");
                continue;
            }
            int sc = GLFW.glfwGetKeyScancode((int)cand);
            if (sc <= 0) {
                tried.append(cand).append("(no-scan), ");
                continue;
            }
            Constants.LOG.debug("[{}] Shim: selected tempKey {} with scancode {} (tried: {}).", new Object[]{"EZActions", cand, sc, tried.toString()});
            return new TempKey(cand, sc);
        }
        Constants.LOG.debug("[{}] Shim: exhausted candidates (tried: {}).", (Object)"EZActions", (Object)tried.toString());
        return null;
    }

    private static boolean isKeyInUse(Options opts, int glfwKey) {
        try {
            if (opts == null || opts.keyMappings == null) {
                return false;
            }
            for (KeyMapping km : opts.keyMappings) {
                InputConstants.Key k;
                if (km == null || (k = km.getKey()) == null || k.getType() != InputConstants.Type.KEYSYM || k.getValue() != glfwKey) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    private static Class<? extends Enum<?>> keyModEnum(boolean neoFirst) {
        String[] candidates;
        String[] stringArray;
        if (neoFirst) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "net.neoforged.neoforge.client.settings.KeyModifier";
            stringArray = stringArray2;
            stringArray2[1] = "net.minecraftforge.client.settings.KeyModifier";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "net.minecraftforge.client.settings.KeyModifier";
            stringArray = stringArray3;
            stringArray3[1] = "net.neoforged.neoforge.client.settings.KeyModifier";
        }
        for (String fqn : candidates = stringArray) {
            try {
                return Class.forName(fqn);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    @Nullable
    private static Enum<?> keyModGet(KeyMapping mapping, boolean neoFirst) {
        try {
            Method m = mapping.getClass().getMethod("getKeyModifier", new Class[0]);
            Object km = m.invoke((Object)mapping, new Object[0]);
            return km instanceof Enum ? (Enum)km : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    private static Enum<?> keyModConstant(String name, boolean neoFirst) {
        try {
            Class<? extends Enum<?>> cls = InputInjector.keyModEnum(neoFirst);
            if (cls == null) {
                return null;
            }
            Enum<?> v = Enum.valueOf(cls, name);
            return v;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean setKeyModifierAndCode(KeyMapping mapping, @Nullable Enum<?> keyMod, InputConstants.Key key) {
        for (boolean neoFirst : new boolean[]{true, false}) {
            try {
                Class<? extends Enum<?>> kmEnum = InputInjector.keyModEnum(neoFirst);
                if (kmEnum == null) continue;
                Method m = mapping.getClass().getMethod("setKeyModifierAndCode", kmEnum, InputConstants.Key.class);
                m.invoke((Object)mapping, keyMod, key);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean deliverViaModifierShim(Minecraft mc, KeyMapping mapping) {
        try {
            int useScan;
            int useKeyCode;
            Enum<?> NONE;
            Options opts = mc.options;
            if (opts == null) {
                return false;
            }
            Enum<?> origMod = InputInjector.keyModGet(mapping, true);
            if (origMod == null) {
                origMod = InputInjector.keyModGet(mapping, false);
            }
            if ((NONE = InputInjector.keyModConstant("NONE", true)) == null) {
                NONE = InputInjector.keyModConstant("NONE", false);
            }
            if (NONE == null) {
                return false;
            }
            InputConstants.Key oldKey = mapping.getKey();
            int currentKeyCode = oldKey != null ? oldKey.getValue() : -1;
            int currentScan = currentKeyCode >= 0 ? GLFW.glfwGetKeyScancode((int)currentKeyCode) : 0;
            boolean usingTempKey = false;
            if (currentScan > 0 && currentKeyCode >= 0) {
                useKeyCode = currentKeyCode;
                useScan = currentScan;
            } else {
                TempKey temp = InputInjector.findTemporaryKey(opts);
                if (temp == null) {
                    Constants.LOG.warn("[{}] ModShim: no suitable temp key for '{}'.", (Object)"EZActions", (Object)InputInjector.safeName(mapping));
                    return false;
                }
                useKeyCode = temp.glfwKey;
                useScan = temp.scancode;
                usingTempKey = true;
            }
            InputConstants.Key newKey = InputConstants.Type.KEYSYM.getOrCreate(useKeyCode);
            boolean setOk = InputInjector.setKeyModifierAndCode(mapping, NONE, newKey);
            if (!setOk) {
                return false;
            }
            KeyMapping.resetMapping();
            Constants.LOG.info("[{}] ModShim: '{}' -> modifier=NONE key={} (scan={}){}", new Object[]{"EZActions", InputInjector.safeName(mapping), useKeyCode, useScan, usingTempKey ? " [temp]" : ""});
            boolean pressed = InputInjector.deliverInput(mc, useKeyCode, useScan, 0);
            Enum<?> restoreMod = origMod == null ? NONE : origMod;
            String restoreModLabel = origMod == null ? "NONE?" : origMod.name();
            InputConstants.Key restoreKeyFinal = oldKey == null ? InputConstants.UNKNOWN : oldKey;
            ClientTaskQueue.post(() -> {
                try {
                    if (InputInjector.setKeyModifierAndCode(mapping, restoreMod, restoreKeyFinal)) {
                        KeyMapping.resetMapping();
                        Constants.LOG.info("[{}] ModShim: restored '{}' to modifier={} key={}.", new Object[]{"EZActions", InputInjector.safeName(mapping), restoreModLabel, oldKey == null ? "UNBOUND" : Integer.valueOf(oldKey.getValue())});
                    } else {
                        mapping.setKey(restoreKeyFinal);
                        KeyMapping.resetMapping();
                        Constants.LOG.info("[{}] ModShim: restored '{}' key only (modifier restore failed).", (Object)"EZActions", (Object)InputInjector.safeName(mapping));
                    }
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] ModShim: restore failed for '{}': {}", new Object[]{"EZActions", InputInjector.safeName(mapping), t.toString()});
                }
            });
            return pressed;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] ModShim exception for '{}': {}", new Object[]{"EZActions", InputInjector.safeName(mapping), t.toString()});
            return false;
        }
    }

    private static boolean deliverInput(Minecraft mc, int glfwKey, int glfwScanCode, int glfwMods) {
        try {
            long window;
            long l = window = mc.getWindow() != null ? mc.getWindow().getWindow() : 0L;
            if (window == 0L) {
                Constants.LOG.warn("[{}] INPUT: window handle missing", (Object)"EZActions");
                return false;
            }
            if (glfwKey < 0) {
                Constants.LOG.warn("[{}] INPUT: invalid key (<0).", (Object)"EZActions");
                return false;
            }
            if (glfwScanCode <= 0) {
                Constants.LOG.warn("[{}] INPUT: scancode is {} (<=0). Some keys will be ignored by the input pipeline.", (Object)"EZActions", (Object)glfwScanCode);
            }
            KeyboardHandlerAccessor acc = (KeyboardHandlerAccessor)mc.keyboardHandler;
            acc.ezactions$keyPress(window, glfwKey, glfwScanCode, 1, glfwMods);
            ClientTaskQueue.post(() -> {
                try {
                    acc.ezactions$keyPress(window, glfwKey, glfwScanCode, 0, glfwMods);
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] INPUT release failed: {}", (Object)"EZActions", (Object)t.toString());
                }
            });
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] INPUT delivery exception: {}", (Object)"EZActions", (Object)t.toString());
            return false;
        }
    }

    private static boolean deliverTick(KeyMapping mapping, boolean toggle) {
        try {
            if (toggle) {
                boolean newState = !mapping.isDown();
                mapping.setDown(newState);
                Constants.LOG.info("[{}] TICK toggle '{}' -> {}", new Object[]{"EZActions", InputInjector.safeName(mapping), newState});
                return true;
            }
            mapping.setDown(true);
            ClientTaskQueue.post(() -> {
                try {
                    mapping.setDown(false);
                }
                catch (Throwable t) {
                    Constants.LOG.warn("[{}] TICK release failed: {}", (Object)"EZActions", (Object)t.toString());
                }
            });
            Constants.LOG.info("[{}] TICK tap '{}'", (Object)"EZActions", (Object)InputInjector.safeName(mapping));
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] TICK delivery exception '{}': {}", new Object[]{"EZActions", InputInjector.safeName(mapping), t.toString()});
            return false;
        }
    }

    private static boolean isTextInputFocused(Minecraft mc) {
        try {
            Screen s = mc.screen;
            return s instanceof ChatScreen;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int keyCodeFrom(KeyMapping mapping) {
        try {
            InputConstants.Key k = mapping.getKey();
            return k != null ? k.getValue() : -1;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static boolean isUnbound(InputConstants.Key k) {
        return k == null || k.getValue() < 0;
    }

    private static String safeName(KeyMapping km) {
        try {
            return km.getName();
        }
        catch (Throwable t) {
            return "<unknown-key>";
        }
    }

    @Nullable
    private static Resolution resolveExact(Options opts, String needle) {
        KeyMapping[] all = opts.keyMappings;
        if (all == null || all.length == 0) {
            return null;
        }
        for (KeyMapping km : all) {
            String disp;
            if (km == null || !needle.equalsIgnoreCase(disp = km.getName())) continue;
            return new Resolution(km, "exact-translation-key", disp);
        }
        return null;
    }

    @Nullable
    private static Resolution resolveLocalized(Options opts, String needle) {
        KeyMapping[] all = opts.keyMappings;
        if (all == null || all.length == 0) {
            return null;
        }
        for (KeyMapping km : all) {
            String localized;
            if (km == null || !needle.equalsIgnoreCase(localized = Component.translatable((String)km.getName()).getString())) continue;
            return new Resolution(km, "exact-localized", localized);
        }
        return null;
    }

    @Nullable
    private static Resolution resolveContains(Options opts, String needle) {
        KeyMapping[] all = opts.keyMappings;
        if (all == null || all.length == 0) {
            return null;
        }
        String nlc = needle.toLowerCase(Locale.ROOT);
        for (KeyMapping km : all) {
            if (km == null) continue;
            String keyName = km.getName();
            String loc = Component.translatable((String)keyName).getString();
            if (!keyName.equalsIgnoreCase(needle) && !keyName.toLowerCase(Locale.ROOT).contains(nlc) && !loc.equalsIgnoreCase(needle) && !loc.toLowerCase(Locale.ROOT).contains(nlc)) continue;
            return new Resolution(km, "contains", loc);
        }
        return null;
    }

    private static Resolution resolveMappingByName(Options opts, String nameOrKey) {
        try {
            String needle = Objects.requireNonNullElse(nameOrKey, "").trim();
            if (needle.isEmpty()) {
                return new Resolution(null, "empty", "");
            }
            Resolution r = InputInjector.resolveExact(opts, needle);
            if (r != null) {
                return r;
            }
            r = InputInjector.resolveLocalized(opts, needle);
            if (r != null) {
                return r;
            }
            r = InputInjector.resolveContains(opts, needle);
            if (r != null) {
                return r;
            }
            return new Resolution(null, "not-found", needle);
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] resolveMappingByName('{}') failed: {}", new Object[]{"EZActions", nameOrKey, t.toString()});
            return new Resolution(null, "exception", nameOrKey);
        }
    }

    private static void logResolved(Resolution res) {
        if (res == null || res.mapping == null) {
            return;
        }
        try {
            InputConstants.Key k = res.mapping.getKey();
            String type = k == null ? "UNKNOWN" : k.getType().name();
            int val = k == null ? -1 : k.getValue();
            Constants.LOG.info("[{}] Resolved mapping: name='{}' match={} localized='{}' keyType={} keyVal={}", new Object[]{"EZActions", res.mapping.getName(), res.matchKind, Component.translatable((String)res.mapping.getName()).getString(), type, val});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private record Resolution(@Nullable KeyMapping mapping, String matchKind, String needleShown) {
    }

    public static enum DeliveryMode {
        AUTO,
        INPUT,
        TICK;

    }

    private record ModReq(boolean ctrl, boolean shift, boolean alt) {
        boolean any() {
            return this.ctrl || this.shift || this.alt;
        }

        int toBitmask() {
            int m = 0;
            if (this.ctrl) {
                m |= 2;
            }
            if (this.shift) {
                m |= 1;
            }
            if (this.alt) {
                m |= 4;
            }
            return m;
        }

        String brief() {
            return (this.ctrl ? "C" : "-") + (this.shift ? "S" : "-") + (this.alt ? "A" : "-");
        }
    }

    private record TempKey(int glfwKey, int scancode) {
    }
}

