/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.platform;

import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.z2six.ezactions.platform.services.IPlatformHelper;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NeoForgePlatformHelper.class);

    @Override
    public String getPlatformName() {
        LOG.debug("[EZActions] getPlatformName() -> NeoForge");
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        try {
            boolean loaded = ModList.get().isLoaded(modId);
            LOG.debug("[EZActions] isModLoaded('{}') -> {}", (Object)modId, (Object)loaded);
            return loaded;
        }
        catch (Throwable t) {
            LOG.warn("[EZActions] isModLoaded('{}') failed; assuming not loaded. Reason: {}", (Object)modId, (Object)t.toString());
            return false;
        }
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        try {
            boolean production = FMLEnvironment.production;
            boolean dev = !production;
            LOG.debug("[EZActions] isDevelopmentEnvironment() -> {} (production={})", (Object)dev, (Object)production);
            return dev;
        }
        catch (Throwable t) {
            LOG.warn("[EZActions] isDevelopmentEnvironment() detection failed; defaulting to production. Reason: {}", (Object)t.toString());
            return false;
        }
    }
}

