/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.util;

import net.minecraft.client.Minecraft;
import org.z2six.ezactions.Constants;

public final class ClipboardIO {
    private ClipboardIO() {
    }

    public static String getClipboard() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.keyboardHandler == null) {
                Constants.LOG.debug("[{}] Clipboard get: MC not ready.", (Object)"EZActions");
                return null;
            }
            String s = mc.keyboardHandler.getClipboard();
            if (s == null) {
                Constants.LOG.debug("[{}] Clipboard get: empty (null).", (Object)"EZActions");
                return null;
            }
            Constants.LOG.debug("[{}] Clipboard get: {} chars.", (Object)"EZActions", (Object)s.length());
            return s;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Clipboard get failed: {}", (Object)"EZActions", (Object)t.toString());
            return null;
        }
    }

    public static boolean setClipboard(String text) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.keyboardHandler == null) {
                Constants.LOG.debug("[{}] Clipboard set: MC not ready.", (Object)"EZActions");
                return false;
            }
            if (text == null) {
                text = "";
            }
            mc.keyboardHandler.setClipboard(text);
            Constants.LOG.debug("[{}] Clipboard set ok ({} chars).", (Object)"EZActions", (Object)text.length());
            return true;
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] Clipboard set failed: {}", (Object)"EZActions", (Object)t.toString());
            return false;
        }
    }
}

