/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.ezactions.util;

import java.util.ArrayDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.z2six.ezactions.Constants;

public final class CommandSequencer {
    private static final ArrayDeque<String> queue = new ArrayDeque();
    private static int delayTicks = 0;
    private static int ticksLeft = 0;

    private CommandSequencer() {
    }

    public static void enqueue(String[] commands, int perLineDelayTicks) {
        try {
            queue.clear();
            if (commands != null) {
                for (String s : commands) {
                    if (s == null || s.isBlank()) continue;
                    queue.addLast(s.trim());
                }
            }
            delayTicks = Math.max(0, perLineDelayTicks);
            ticksLeft = 0;
            Constants.LOG.debug("[{}] CommandSequencer: queued {} cmd(s), delay={} ticks.", new Object[]{"EZActions", queue.size(), delayTicks});
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] CommandSequencer.enqueue failed: {}", (Object)"EZActions", (Object)t.toString());
            queue.clear();
            delayTicks = 0;
            ticksLeft = 0;
        }
    }

    public static void tickClient() {
        try {
            if (queue.isEmpty()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                CommandSequencer.clear();
                return;
            }
            LocalPlayer p = mc.player;
            if (p == null || p.connection == null) {
                CommandSequencer.clear();
                return;
            }
            if (ticksLeft > 0) {
                --ticksLeft;
                return;
            }
            String next = queue.pollFirst();
            if (next == null) {
                CommandSequencer.clear();
                return;
            }
            try {
                p.connection.sendCommand(next);
                Constants.LOG.debug("[{}] Sequencer sent command: {}", (Object)"EZActions", (Object)next);
            }
            catch (Throwable t) {
                Constants.LOG.warn("[{}] Sequencer send failed for '{}': {}", new Object[]{"EZActions", next, t.toString()});
            }
            if (queue.isEmpty()) {
                CommandSequencer.clear();
            } else {
                ticksLeft = Math.max(0, delayTicks);
            }
        }
        catch (Throwable t) {
            Constants.LOG.warn("[{}] CommandSequencer.tickClient failed: {}", (Object)"EZActions", (Object)t.toString());
            CommandSequencer.clear();
        }
    }

    private static void clear() {
        queue.clear();
        ticksLeft = 0;
    }
}

